/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.GridDirectory;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.McIDASUtil;
import visad.CoordinateSystem;
import visad.VisADException;
import visad.data.mcidas.GRIDCoordinateSystem;
import visad.data.units.ParseException;
import visad.data.units.Parser;
import visad.jmet.MetGridDirectory;
import visad.jmet.MetUnits;

public class McIDASGridDirectory
extends MetGridDirectory {
    CoordinateSystem coordSystem = null;
    GridDirectory directory = null;
    private double paramScale;

    private void setParameters() {
        this.paramName = this.directory.getParamName();
        this.rows = this.directory.getRows();
        this.columns = this.directory.getColumns();
        this.levels = 1;
        this.validHour = this.directory.getForecastHour();
        this.referenceTime = this.directory.getReferenceTime();
        this.validTime = this.directory.getValidTime();
        this.levelValue = this.directory.getLevelValue();
        try {
            MetUnits metUnits = new MetUnits();
            String string = this.directory.getParamUnitName();
            String string2 = this.directory.getLevelUnitName();
            try {
                this.paramUnit = Parser.parse(metUnits.makeSymbol(string));
            }
            catch (ParseException parseException) {
                this.paramUnit = null;
            }
            try {
                this.levelUnit = Parser.parse(metUnits.makeSymbol(string2));
            }
            catch (ParseException parseException) {
                this.levelUnit = null;
            }
        }
        catch (VisADException visADException) {
            System.out.println(visADException);
        }
        this.secondLevelValue = this.directory.getSecondLevelValue();
        this.secondTime = this.directory.getSecondTime();
        this.paramScale = this.directory.getParamScale();
    }

    public double getParamScale() {
        return this.paramScale;
    }

    public CoordinateSystem getCoordinateSystem() {
        if (this.coordSystem == null) {
            try {
                if (this.directory == null) {
                    throw new Exception("null directory");
                }
                this.coordSystem = new GRIDCoordinateSystem(this.directory);
            }
            catch (Exception exception) {
                this.coordSystem = null;
                System.out.println("No navigation available");
            }
        }
        return this.coordSystem;
    }

    public String toString() {
        return new String(this.paramName + " " + this.paramUnit + " " + this.rows + " " + this.columns + " " + this.levelValue + " " + this.levelUnit + " " + this.referenceTime.toGMTString() + " " + (int)this.validHour + " or " + this.validTime.toGMTString());
    }

    public McIDASGridDirectory(GridDirectory gridDirectory) {
        this.directory = gridDirectory;
        if (gridDirectory != null) {
            this.setParameters();
        }
    }

    public McIDASGridDirectory(byte[] byArray) {
        int[] nArray = new int[64];
        int n = 0;
        while (n < 64) {
            nArray[n] = McIDASUtil.bytesToInteger(byArray, n * 4);
            ++n;
        }
        try {
            this.directory = new GridDirectory(nArray);
        }
        catch (McIDASException mcIDASException) {
            this.directory = null;
        }
        if (this.directory != null) {
            this.setParameters();
        }
    }
}

