/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.GRIDnav;
import edu.wisc.ssec.mcidas.GridDirectory;
import edu.wisc.ssec.mcidas.McIDASException;
import java.awt.geom.Rectangle2D;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.MapProjection;

public class GRIDCoordinateSystem
extends MapProjection {
    private static Unit[] coordinate_system_units = new Unit[]{null, null};
    private GRIDnav gnav = null;
    private int rows;
    private int columns;

    public double[][] toReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 2) {
            throw new CoordinateSystemException("GRIDCoordinateSystem.toReference: tuples wrong dimension");
        }
        if (this.gnav == null) {
            throw new CoordinateSystemException("GRID navigation data not available");
        }
        return this.gnav.toLatLon(dArray);
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 2) {
            throw new CoordinateSystemException("GRIDCoordinateSystem.fromReference: tuples wrong dimension");
        }
        if (this.gnav == null) {
            throw new CoordinateSystemException("GRID navigation data not available");
        }
        return this.gnav.toRowCol(dArray);
    }

    public Rectangle2D getDefaultMapArea() {
        return new Rectangle2D.Double(0.0, 0.0, this.columns - 1, this.rows - 1);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GRIDCoordinateSystem)) {
            return false;
        }
        GRIDCoordinateSystem gRIDCoordinateSystem = (GRIDCoordinateSystem)object;
        return this == gRIDCoordinateSystem || this.gnav.equals(gRIDCoordinateSystem.gnav) && this.rows == gRIDCoordinateSystem.rows && this.columns == gRIDCoordinateSystem.columns;
    }

    public GRIDCoordinateSystem(GridDirectory gridDirectory) throws VisADException {
        super(RealTupleType.LatitudeLongitudeTuple, coordinate_system_units);
        this.rows = gridDirectory.getRows();
        this.columns = gridDirectory.getColumns();
        this.gnav = gridDirectory.getNavigation();
        if (this.gnav == null) {
            throw new VisADException("Grid cannot be navigated");
        }
        this.gnav.setStart(0, 0);
        this.gnav.setFlipRowCoordinates(this.rows);
    }

    public GRIDCoordinateSystem(int[] nArray) throws VisADException {
        super(RealTupleType.LatitudeLongitudeTuple, coordinate_system_units);
        this.rows = nArray[1];
        this.columns = nArray[2];
        try {
            this.gnav = new GRIDnav(nArray);
            this.gnav.setStart(0, 0);
            this.gnav.setFlipRowCoordinates(this.rows);
        }
        catch (McIDASException mcIDASException) {
            throw new VisADException("Grid cannot be navigated");
        }
    }
}

