/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.Gridded2DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.UnionSet;
import visad.VisADException;

public class BaseMapAdapter {
    private boolean isCoordinateSystem = false;
    private int latMax = 900000;
    private int latMin = -900000;
    private int lonMax = 1800000;
    private int lonMin = -1800000;
    private int segmentPointer = 0;
    private int numEles = 0;
    private int numLines = 0;
    private CoordinateSystem cs = null;
    private DataInputStream din;
    private MathType coordMathType;
    private int position;
    private int numSegments = 0;
    private int[][] segList;
    private boolean isEastPositive = true;
    private int xfirst = 0;
    private int xlast = 0;
    private int yfirst = 0;
    private int ylast = 0;
    private int MAX_SEGMENTS = 100000;

    public void setLatLonLimits(Rectangle2D rectangle2D) {
        this.setLatLonLimits((float)rectangle2D.getMinY(), (float)rectangle2D.getMaxY(), (float)rectangle2D.getMinX(), (float)rectangle2D.getMaxX());
    }

    public void setLatLonLimits(float f, float f2, float f3, float f4) {
        this.latMin = f == Float.NaN ? -900000 : (int)(f * 10000.0f);
        this.latMax = f2 == Float.NaN ? 900000 : (int)(f2 * 10000.0f);
        this.lonMin = f3 == Float.NaN ? -1800000 : (int)(f3 * 10000.0f);
        this.lonMax = f4 == Float.NaN ? 1800000 : (int)(f4 * 10000.0f);
    }

    public void setDomainSet(Linear2DSet linear2DSet) throws VisADException {
        this.coordMathType = linear2DSet.getType();
        this.cs = linear2DSet.getCoordinateSystem();
        this.numEles = linear2DSet.getX().getLength();
        this.numLines = linear2DSet.getY().getLength();
        this.xfirst = (int)linear2DSet.getX().getFirst();
        this.xlast = (int)linear2DSet.getX().getLast();
        this.yfirst = (int)linear2DSet.getY().getFirst();
        this.ylast = (int)linear2DSet.getY().getLast();
        this.computeLimits();
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem, int n, int n2, RealTupleType realTupleType) throws VisADException {
        this.numEles = n;
        this.numLines = n2;
        this.cs = coordinateSystem;
        this.coordMathType = realTupleType;
        this.xlast = n - 1;
        this.ylast = n2 - 1;
        this.computeLimits();
    }

    public void doByLatLon() {
        this.isCoordinateSystem = false;
        try {
            this.coordMathType = new RealTupleType(RealType.Latitude, RealType.Longitude);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void computeLimits() {
        float[][] fArray = new float[][]{{this.xfirst, this.xlast, this.xlast, this.xfirst}, {this.yfirst, this.yfirst, this.ylast, this.ylast}};
        try {
            float[][] fArray2 = this.cs.toReference(fArray);
            if (Float.isNaN(fArray2[0][0])) {
                fArray2[0][0] = 90.0f;
            }
            if (Float.isNaN(fArray2[1][0])) {
                fArray2[1][0] = 180.0f;
            }
            if (Float.isNaN(fArray2[0][1])) {
                fArray2[0][1] = 90.0f;
            }
            if (Float.isNaN(fArray2[1][1])) {
                fArray2[1][1] = -180.0f;
            }
            if (Float.isNaN(fArray2[0][2])) {
                fArray2[0][2] = -90.0f;
            }
            if (Float.isNaN(fArray2[1][2])) {
                fArray2[1][2] = 180.0f;
            }
            if (Float.isNaN(fArray2[0][3])) {
                fArray2[0][3] = -90.0f;
            }
            if (Float.isNaN(fArray2[1][3])) {
                fArray2[1][3] = -180.0f;
            }
            this.setLatLonLimits(Math.min(fArray2[0][0], Math.min(fArray2[0][1], Math.min(fArray2[0][2], fArray2[0][3]))), Math.max(fArray2[0][0], Math.max(fArray2[0][1], Math.max(fArray2[0][2], fArray2[0][3]))), Math.min(fArray2[1][0], Math.min(fArray2[1][1], Math.min(fArray2[1][2], fArray2[1][3]))), Math.max(fArray2[1][0], Math.max(fArray2[1][1], Math.max(fArray2[1][2], fArray2[1][3]))));
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.isCoordinateSystem = true;
    }

    private void InitFile() throws VisADException {
        this.coordMathType = RealTupleType.LatitudeLongitudeTuple;
        try {
            this.numSegments = this.din.readInt();
        }
        catch (IOException iOException) {
            throw new VisADException("Error reading map file " + iOException);
        }
        if (this.numSegments <= 0 || this.numSegments > this.MAX_SEGMENTS) {
            throw new VisADException("McIDAS map file format error: number of segments = " + this.numSegments);
        }
        this.position = 4;
        this.segList = new int[this.numSegments][6];
        int n = 0;
        while (n < this.numSegments) {
            try {
                int n2 = 0;
                while (n2 < 6) {
                    this.segList[n][n2] = this.din.readInt();
                    if (n2 == 4 && this.segList[n][4] < 0) {
                        throw new VisADException("McIDAS map file format error: Negative pointer (" + this.segList[n][4] + ") to start of data for segment " + n);
                    }
                    if (n2 == 5 && (this.segList[n][5] < 0 || this.segList[n][5] % 2 != 0)) {
                        throw new VisADException("McIDAS map file format error: Wrong number of words (" + this.segList[n][5] + ") to read for segment " + n);
                    }
                    this.position += 4;
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new VisADException("Base Map: Error reading map file: " + iOException);
            }
            ++n;
        }
        this.segmentPointer = -1;
    }

    private int findNextSegment() throws VisADException {
        while (true) {
            ++this.segmentPointer;
            if (this.segmentPointer >= this.numSegments) {
                return 0;
            }
            if (this.segList[this.segmentPointer][0] > this.latMax || this.segList[this.segmentPointer][1] < this.latMin) continue;
            if (this.isEastPositive) {
                int n = -this.segList[this.segmentPointer][2];
                int n2 = -this.segList[this.segmentPointer][3];
                if (this.lonMax > 1800000) {
                    if (n < 0 && n < this.lonMin) {
                        n += 3600000;
                    }
                    if (n2 < 0 && n2 < this.lonMin) {
                        n2 += 3600000;
                    }
                }
                if (n <= this.lonMax && n2 >= this.lonMin) break;
                continue;
            }
            if (this.segList[this.segmentPointer][2] <= this.lonMax && this.segList[this.segmentPointer][3] >= this.lonMin) break;
        }
        return this.segList[this.segmentPointer][5] / 2;
    }

    private float[][] getLatLons() throws VisADException {
        float[][] fArray;
        int n;
        int n2 = this.segList[this.segmentPointer][5] / 2;
        if (n2 < 0) {
            throw new VisADException("Error in map file: Negative number of lat/lon pairs");
        }
        float f = (float)this.lonMin / 10000.0f;
        try {
            n = this.segList[this.segmentPointer][4] * 4 - this.position;
            try {
                this.din.skipBytes(n);
            }
            catch (Exception exception) {
                throw new VisADException("Base Map: IOException in skip" + exception);
            }
            fArray = new float[2][n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.din.readInt();
                int n5 = this.din.readInt();
                fArray[0][n3] = (float)n4 / 10000.0f;
                fArray[1][n3] = (float)n5 / 10000.0f;
                if (this.isEastPositive) {
                    fArray[1][n3] = -fArray[1][n3];
                    if ((double)fArray[1][n3] < 0.0 && fArray[1][n3] < f && this.lonMax > 1800000) {
                        fArray[1][n3] = 360.0f + fArray[1][n3];
                    }
                }
                ++n3;
            }
        }
        catch (IOException iOException) {
            throw new VisADException("Base Map: read past EOF");
        }
        this.position = this.position + n + 8 * n2;
        return fArray;
    }

    public UnionSet getData() {
        UnionSet unionSet = null;
        int n = 1;
        Vector<Gridded2DSet> vector = new Vector<Gridded2DSet>();
        float f = (float)this.numEles / 2.0f;
        try {
            int n2 = 0;
            while ((n = this.findNextSegment()) != 0) {
                Gridded2DSet gridded2DSet;
                float[][] fArray = this.getLatLons();
                int n3 = fArray[0].length;
                int n4 = 0;
                int n5 = 0;
                if (this.isCoordinateSystem) {
                    float[][] fArray2;
                    float[][] fArray3 = this.cs.fromReference(fArray);
                    boolean bl = false;
                    int n6 = 0;
                    while (n6 < n3) {
                        if (Float.isNaN(fArray3[0][n6])) {
                            bl = true;
                            break;
                        }
                        if (n6 > 0 && Math.abs(fArray3[0][n6] - fArray3[0][n6 - 1]) > f) {
                            if (n5 > 1) {
                                fArray2 = new float[2][n5];
                                System.arraycopy(fArray3[0], n4, fArray2[0], 0, n5);
                                System.arraycopy(fArray3[1], n4, fArray2[1], 0, n5);
                                gridded2DSet = new Gridded2DSet(this.coordMathType, fArray2, n5);
                                vector.addElement(gridded2DSet);
                            }
                            n5 = 0;
                            n4 = n6;
                        }
                        ++n5;
                        ++n6;
                    }
                    if (bl) continue;
                    if (n5 == n3) {
                        gridded2DSet = new Gridded2DSet(this.coordMathType, fArray3, n3);
                        vector.addElement(gridded2DSet);
                    } else if (n5 > 1) {
                        fArray2 = new float[2][n5];
                        System.arraycopy(fArray3[0], n4, fArray2[0], 0, n5);
                        System.arraycopy(fArray3[1], n4, fArray2[1], 0, n5);
                        gridded2DSet = new Gridded2DSet(this.coordMathType, fArray2, n5);
                        vector.addElement(gridded2DSet);
                    }
                } else {
                    gridded2DSet = new Gridded2DSet(this.coordMathType, fArray, n3);
                    vector.addElement(gridded2DSet);
                }
                n2 += n3;
            }
            if (!vector.isEmpty()) {
                Object[] objectArray = new Gridded2DSet[vector.size()];
                vector.copyInto(objectArray);
                unionSet = new UnionSet(this.coordMathType, (SampledSet[])objectArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return unionSet;
    }

    public void setEastPositive(boolean bl) {
        this.isEastPositive = bl;
    }

    public boolean isEastPositive() {
        return this.isEastPositive;
    }

    public BaseMapAdapter(String string) throws IOException, VisADException {
        this(new FileInputStream(string), null);
    }

    public BaseMapAdapter(String string, Rectangle2D rectangle2D) throws IOException, VisADException {
        this(new FileInputStream(string), null);
    }

    public BaseMapAdapter(URL uRL) throws IOException, VisADException {
        this(uRL.openStream(), null);
    }

    public BaseMapAdapter(URL uRL, Rectangle2D rectangle2D) throws IOException, VisADException {
        this(uRL.openStream(), rectangle2D);
    }

    public BaseMapAdapter(InputStream inputStream) throws IOException, VisADException {
        this(inputStream, null);
    }

    public BaseMapAdapter(InputStream inputStream, Rectangle2D rectangle2D) throws IOException, VisADException {
        this.din = new DataInputStream(new BufferedInputStream(inputStream));
        this.InitFile();
        if (rectangle2D != null) {
            this.setLatLonLimits((float)rectangle2D.getMinY(), (float)rectangle2D.getMaxY(), (float)rectangle2D.getMinX(), (float)rectangle2D.getMaxX());
        }
    }
}

