/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.McIDASException;
import java.io.IOException;
import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.DateTime;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.VisADException;
import visad.data.mcidas.AREACoordinateSystem;
import visad.meteorology.NavigatedImage;
import visad.meteorology.SingleBandedImage;
import visad.meteorology.SingleBandedImageImpl;

public class AreaAdapter {
    private FlatField field = null;
    private AREACoordinateSystem cs;
    private AreaDirectory areaDirectory;

    private void buildFlatField(AreaFile areaFile) throws VisADException {
        Set[] setArray;
        int[] nArray = null;
        try {
            this.areaDirectory = areaFile.getAreaDirectory();
            nArray = areaFile.getNav();
        }
        catch (Exception exception) {
            throw new VisADException("Problem getting Area file directory or navigation");
        }
        int n = this.areaDirectory.getLines();
        int n2 = this.areaDirectory.getElements();
        RealType realType = RealType.getRealType("ImageLine", null, null);
        RealType realType2 = RealType.getRealType("ImageElement", null, null);
        int[] nArray2 = this.areaDirectory.getBands();
        int n3 = nArray2.length;
        RealType[] realTypeArray = new RealType[n3];
        int n4 = 0;
        while (n4 < n3) {
            realTypeArray[n4] = RealType.getRealType("Band" + nArray2[n4]);
            ++n4;
        }
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        RealType[] realTypeArray2 = new RealType[]{realType2, realType};
        try {
            this.cs = new AREACoordinateSystem(RealTupleType.LatitudeLongitudeTuple, this.areaDirectory.getDirectoryBlock(), nArray);
        }
        catch (VisADException visADException) {
            System.out.println(visADException);
            System.out.println("Using null CoordinateSystem");
            this.cs = null;
        }
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2, (CoordinateSystem)this.cs, null);
        Linear2DSet linear2DSet = new Linear2DSet((MathType)realTupleType2, 0.0, (double)(n2 - 1), n2, n - 1, 0.0, n);
        FunctionType functionType = new FunctionType(realTupleType2, realTupleType);
        if (this.areaDirectory.getCalibrationType().equalsIgnoreCase("BRIT")) {
            setArray = new Set[n3];
            int n5 = 0;
            while (n5 < n3) {
                setArray[n5] = new Integer1DSet((MathType)realTypeArray[n5], 255);
                ++n5;
            }
            this.field = new FlatField(functionType, (Set)linear2DSet, null, setArray, null);
        } else {
            this.field = new FlatField(functionType, linear2DSet);
        }
        try {
            setArray = (Set[])areaFile.getData();
        }
        catch (McIDASException mcIDASException) {
            throw new VisADException("Problem reading AREA file: " + mcIDASException);
        }
        try {
            float[][] fArray = new float[n3][n2 * n];
            int n6 = 0;
            while (n6 < n3) {
                int n7 = 0;
                while (n7 < n) {
                    int n8 = 0;
                    while (n8 < n2) {
                        fArray[n6][n8 + n2 * n7] = this.areaDirectory.getCalibrationType().equalsIgnoreCase("BRIT") && setArray[n6][n7][n8] == 255 ? 254.0f : (float)setArray[n6][n7][n8];
                        ++n8;
                    }
                    ++n7;
                }
                ++n6;
            }
            this.field.setSamples(fArray, false);
        }
        catch (RemoteException remoteException) {
            throw new VisADException("Couldn't finish image initialization");
        }
    }

    public int[] getDimensions() {
        int[] nArray = new int[]{this.areaDirectory.getNumberOfBands(), this.areaDirectory.getElements(), this.areaDirectory.getLines()};
        return nArray;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.cs;
    }

    public FlatField getData() {
        return this.field;
    }

    public DateTime getNominalTime() throws VisADException {
        return new DateTime(this.areaDirectory.getNominalTime());
    }

    public DateTime getImageStartTime() throws VisADException {
        return new DateTime(this.areaDirectory.getStartTime());
    }

    public SingleBandedImage getImage() throws VisADException {
        FlatField flatField;
        if (this.field.getRangeDimension() > 1) {
            try {
                flatField = (FlatField)this.field.extract(0);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("AreaAdapter.getImage(): RemoteException");
            }
        } else {
            flatField = this.field;
        }
        return this.cs == null ? new SingleBandedImageImpl(flatField, this.getNominalTime(), "McIDAS Image") : new NavigatedImage(flatField, this.getNominalTime(), "McIDAS Image");
    }

    public AreaAdapter(String string) throws IOException, VisADException {
        try {
            AreaFile areaFile = new AreaFile(string);
            this.buildFlatField(areaFile);
        }
        catch (McIDASException mcIDASException) {
            throw new VisADException("Problem with McIDAS AREA file: " + mcIDASException);
        }
    }
}

