/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASException;
import java.awt.geom.Rectangle2D;
import visad.CoordinateSystemException;
import visad.QuickSort;
import visad.RealTupleType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.georef.MapProjection;

public class AREACoordinateSystem
extends MapProjection {
    private static Unit[] coordinate_system_units = new Unit[]{null, null};
    private AREAnav anav = null;
    private int lines;
    private int elements;

    public double[][] toReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 2) {
            throw new CoordinateSystemException("AREACoordinateSystem.toReference: tuples wrong dimension");
        }
        if (this.anav == null) {
            throw new CoordinateSystemException("AREA O & A data not availble");
        }
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        int[] nArray = new int[2];
        double[][] dArray4 = this.makeSpline(dArray, dArray2, dArray3, nArray);
        if (dArray4 != null) {
            double[][] dArray5 = this.anav.toLatLon(dArray4);
            int n = dArray[0].length;
            double[][] dArray6 = new double[2][n];
            int[][] nArray2 = new int[1][n];
            double[][] dArray7 = this.applySpline(dArray, dArray2, dArray3, nArray, dArray5, dArray6, nArray2);
            if (nArray2[0] != null) {
                double[][] dArray8 = this.anav.toLatLon(dArray6);
                int n2 = 0;
                while (n2 < nArray2[0].length) {
                    dArray7[0][nArray2[0][n2]] = dArray8[0][n2];
                    dArray7[1][nArray2[0][n2]] = dArray8[1][n2];
                    ++n2;
                }
            }
            return dArray7;
        }
        return this.anav.toLatLon(dArray);
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 2) {
            throw new CoordinateSystemException("AREACoordinateSystem.fromReference: tuples wrong dimension");
        }
        if (this.anav == null) {
            throw new CoordinateSystemException("AREA O & A data not availble");
        }
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        int[] nArray = new int[2];
        double[][] dArray4 = this.makeSpline(dArray, dArray2, dArray3, nArray);
        if (dArray4 != null) {
            double[][] dArray5 = this.anav.toLinEle(dArray4);
            int n = dArray[0].length;
            double[][] dArray6 = new double[2][n];
            int[][] nArray2 = new int[1][n];
            double[][] dArray7 = this.applySpline(dArray, dArray2, dArray3, nArray, dArray5, dArray6, nArray2);
            if (nArray2[0] != null) {
                double[][] dArray8 = this.anav.toLinEle(dArray6);
                int n2 = 0;
                while (n2 < nArray2[0].length) {
                    dArray7[0][nArray2[0][n2]] = dArray8[0][n2];
                    dArray7[1][nArray2[0][n2]] = dArray8[1][n2];
                    ++n2;
                }
            }
            return dArray7;
        }
        return this.anav.toLinEle(dArray);
    }

    public float[][] toReference(float[][] fArray) throws VisADException {
        int[] nArray;
        double[] dArray;
        double[] dArray2;
        if (fArray == null || fArray.length != 2) {
            throw new CoordinateSystemException("AREACoordinateSystem.toReference: tuples wrong dimension");
        }
        if (this.anav == null) {
            throw new CoordinateSystemException("AREA O & A data not availble");
        }
        double[][] dArray3 = Set.floatToDouble(fArray);
        double[][] dArray4 = this.makeSpline(dArray3, dArray2 = new double[2], dArray = new double[2], nArray = new int[2]);
        if (dArray4 != null) {
            double[][] dArray5 = this.anav.toLatLon(dArray4);
            int n = fArray[0].length;
            double[][] dArray6 = new double[2][n];
            int[][] nArray2 = new int[1][n];
            dArray3 = this.applySpline(dArray3, dArray2, dArray, nArray, dArray5, dArray6, nArray2);
            if (nArray2[0] != null) {
                double[][] dArray7 = this.anav.toLatLon(dArray6);
                int n2 = 0;
                while (n2 < nArray2[0].length) {
                    dArray3[0][nArray2[0][n2]] = dArray7[0][n2];
                    dArray3[1][nArray2[0][n2]] = dArray7[1][n2];
                    ++n2;
                }
            }
        } else {
            dArray3 = this.anav.toLatLon(dArray3);
        }
        return Set.doubleToFloat(dArray3);
    }

    public float[][] fromReference(float[][] fArray) throws VisADException {
        int[] nArray;
        double[] dArray;
        double[] dArray2;
        if (fArray == null || fArray.length != 2) {
            throw new CoordinateSystemException("AREACoordinateSystem.fromReference: tuples wrong dimension");
        }
        if (this.anav == null) {
            throw new CoordinateSystemException("AREA O & A data not availble");
        }
        double[][] dArray3 = Set.floatToDouble(fArray);
        double[][] dArray4 = this.makeSpline(dArray3, dArray2 = new double[2], dArray = new double[2], nArray = new int[2]);
        if (dArray4 != null) {
            double[][] dArray5 = this.anav.toLinEle(dArray4);
            int n = fArray[0].length;
            double[][] dArray6 = new double[2][n];
            int[][] nArray2 = new int[1][n];
            dArray3 = this.applySpline(dArray3, dArray2, dArray, nArray, dArray5, dArray6, nArray2);
            if (nArray2[0] != null) {
                double[][] dArray7 = this.anav.toLinEle(dArray6);
                int n2 = 0;
                while (n2 < nArray2[0].length) {
                    dArray3[0][nArray2[0][n2]] = dArray7[0][n2];
                    dArray3[1][nArray2[0][n2]] = dArray7[1][n2];
                    ++n2;
                }
            }
        } else {
            dArray3 = this.anav.toLinEle(dArray3);
        }
        return Set.doubleToFloat(dArray3);
    }

    private double[][] makeSpline(double[][] dArray, double[] dArray2, double[] dArray3, int[] nArray) throws VisADException {
        int n = dArray[0].length;
        if (n < 1000) {
            return null;
        }
        double d = 10.0;
        if (n < 10000) {
            d = 2.0;
        } else if (n < 100000) {
            d = 5.0;
        }
        dArray2[0] = Double.MAX_VALUE;
        dArray3[0] = -1.7976931348623157E308;
        dArray2[1] = Double.MAX_VALUE;
        dArray3[1] = -1.7976931348623157E308;
        int n2 = 0;
        while (n2 < n) {
            if (dArray[0][n2] == dArray[0][n2]) {
                if (dArray[0][n2] < dArray2[0]) {
                    dArray2[0] = dArray[0][n2];
                }
                if (dArray[0][n2] > dArray3[0]) {
                    dArray3[0] = dArray[0][n2];
                }
            }
            if (dArray[1][n2] == dArray[1][n2]) {
                if (dArray[1][n2] < dArray2[1]) {
                    dArray2[1] = dArray[1][n2];
                }
                if (dArray[1][n2] > dArray3[1]) {
                    dArray3[1] = dArray[1][n2];
                }
            }
            ++n2;
        }
        float[] fArray = new float[n - 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n - 1) {
            float f = (float)Math.sqrt((dArray[0][n4] - dArray[0][n4 + 1]) * (dArray[0][n4] - dArray[0][n4 + 1]) + (dArray[1][n4] - dArray[1][n4 + 1]) * (dArray[1][n4] - dArray[1][n4 + 1]));
            if (f == f) {
                fArray[n3++] = f;
            }
            ++n4;
        }
        if (n3 < 3) {
            return null;
        }
        float[] fArray2 = new float[n3];
        System.arraycopy(fArray, 0, fArray2, 0, n3);
        QuickSort.sort(fArray2);
        double d2 = d * (double)fArray2[n3 / 4];
        nArray[0] = (int)((dArray3[0] - dArray2[0]) / d2) + 1;
        nArray[1] = (int)((dArray3[1] - dArray2[1]) / d2) + 1;
        if (nArray[0] < 20 || nArray[1] < 20) {
            return null;
        }
        if (nArray[0] * nArray[1] > n / 4) {
            return null;
        }
        double d3 = (dArray3[0] - dArray2[0]) / (double)(nArray[0] - 1);
        double d4 = (dArray3[1] - dArray2[1]) / (double)(nArray[1] - 1);
        double[][] dArray4 = new double[2][nArray[0] * nArray[1]];
        n3 = 0;
        int n5 = 0;
        while (n5 < nArray[0]) {
            int n6 = 0;
            while (n6 < nArray[1]) {
                dArray4[0][n3] = dArray2[0] + (double)n5 * d3;
                dArray4[1][n3] = dArray2[1] + (double)n6 * d4;
                ++n3;
                ++n6;
            }
            ++n5;
        }
        return dArray4;
    }

    private double[][] applySpline(double[][] dArray, double[] dArray2, double[] dArray3, int[] nArray, double[][] dArray4, double[][] dArray5, int[][] nArray2) throws VisADException {
        int n;
        int n2 = nArray[0];
        int n3 = nArray[1];
        double d = (dArray3[0] - dArray2[0]) / (double)(n2 - 1);
        double d2 = (dArray3[1] - dArray2[1]) / (double)(n3 - 1);
        int n4 = dArray[0].length;
        double[][] dArray6 = new double[2][n4];
        boolean[] blArray = new boolean[n2 * n3];
        double[] dArray7 = new double[]{Double.MAX_VALUE, Double.MAX_VALUE};
        double[] dArray8 = new double[]{-1.7976931348623157E308, -1.7976931348623157E308};
        int n5 = 0;
        while (n5 < n2 * n3) {
            if (dArray4[0][n5] == dArray4[0][n5]) {
                if (dArray4[0][n5] < dArray7[0]) {
                    dArray7[0] = dArray4[0][n5];
                }
                if (dArray4[0][n5] > dArray8[0]) {
                    dArray8[0] = dArray4[0][n5];
                }
            }
            if (dArray4[1][n5] == dArray4[1][n5]) {
                if (dArray4[1][n5] < dArray7[1]) {
                    dArray7[1] = dArray4[1][n5];
                }
                if (dArray4[1][n5] > dArray8[1]) {
                    dArray8[1] = dArray4[1][n5];
                }
            }
            blArray[n5] = false;
            ++n5;
        }
        double d3 = Math.min(n2, n3);
        double d4 = (dArray8[0] - dArray7[0]) / d3;
        double d5 = (dArray8[1] - dArray7[1]) / d3;
        int n6 = 0;
        while (n6 < n2 - 1) {
            n = 0;
            while (n < n3 - 1) {
                int n7 = n + n6 * n3;
                if (Math.abs(dArray4[0][n7 + n3] - dArray4[0][n7]) > 3.0 * d4 || Math.abs(dArray4[0][n7 + 1] - dArray4[0][n7]) > 3.0 * d4 || Math.abs(dArray4[0][n7 + n3 + 1] - dArray4[0][n7 + 1]) > 3.0 * d4 || Math.abs(dArray4[0][n7 + n3 + 1] - dArray4[0][n7 + n3]) > 3.0 * d4 || Math.abs(dArray4[1][n7 + n3] - dArray4[1][n7]) > 3.0 * d5 || Math.abs(dArray4[1][n7 + 1] - dArray4[1][n7]) > 3.0 * d5 || Math.abs(dArray4[1][n7 + n3 + 1] - dArray4[1][n7 + 1]) > 3.0 * d5 || Math.abs(dArray4[1][n7 + n3 + 1] - dArray4[1][n7 + n3]) > 3.0 * d5) {
                    blArray[n7] = true;
                }
                ++n;
            }
            ++n6;
        }
        n6 = 0;
        n = 0;
        while (n < n4) {
            double d6 = (dArray[0][n] - dArray2[0]) / d;
            int n8 = (int)d6;
            if (n8 < 0) {
                n8 = 0;
            }
            if (n8 > n2 - 2) {
                n8 = n2 - 2;
            }
            d6 -= (double)n8;
            double d7 = (dArray[1][n] - dArray2[1]) / d2;
            int n9 = (int)d7;
            if (n9 < 0) {
                n9 = 0;
            }
            if (n9 > n3 - 2) {
                n9 = n3 - 2;
            }
            d7 -= (double)n9;
            int n10 = n9 + n8 * n3;
            if (blArray[n10]) {
                dArray5[0][n6] = dArray[0][n];
                dArray5[1][n6] = dArray[1][n];
                nArray2[0][n6] = n;
                ++n6;
            } else {
                dArray6[0][n] = (1.0 - d6) * ((1.0 - d7) * dArray4[0][n10] + d7 * dArray4[0][n10 + 1]) + d6 * ((1.0 - d7) * dArray4[0][n10 + n3] + d7 * dArray4[0][n10 + n3 + 1]);
                dArray6[1][n] = (1.0 - d6) * ((1.0 - d7) * dArray4[1][n10] + d7 * dArray4[1][n10 + 1]) + d6 * ((1.0 - d7) * dArray4[1][n10 + n3] + d7 * dArray4[1][n10 + n3 + 1]);
                if (dArray6[0][n] != dArray6[0][n] || dArray6[1][n] != dArray6[1][n]) {
                    dArray5[0][n6] = dArray[0][n];
                    dArray5[1][n6] = dArray[1][n];
                    nArray2[0][n6] = n;
                    ++n6;
                }
            }
            ++n;
        }
        if (n6 == 0) {
            nArray2[0] = null;
            dArray5[0] = null;
            dArray5[1] = null;
        } else {
            double[] dArray9 = new double[n6];
            System.arraycopy(dArray5[0], 0, dArray9, 0, n6);
            dArray5[0] = dArray9;
            dArray9 = new double[n6];
            System.arraycopy(dArray5[1], 0, dArray9, 0, n6);
            dArray5[1] = dArray9;
            int[] nArray3 = new int[n6];
            System.arraycopy(nArray2[0], 0, nArray3, 0, n6);
            nArray2[0] = nArray3;
        }
        return dArray6;
    }

    public Rectangle2D getDefaultMapArea() {
        return new Rectangle2D.Double(0.0, 0.0, this.elements - 1, this.lines - 1);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AREACoordinateSystem)) {
            return false;
        }
        AREACoordinateSystem aREACoordinateSystem = (AREACoordinateSystem)object;
        return this == aREACoordinateSystem || this.anav.equals(aREACoordinateSystem.anav) && this.lines == aREACoordinateSystem.lines && this.elements == aREACoordinateSystem.elements;
    }

    public AREACoordinateSystem(RealTupleType realTupleType, int[] nArray, int[] nArray2) throws VisADException {
        super(realTupleType, coordinate_system_units);
        try {
            this.anav = AREAnav.makeAreaNav(nArray2);
        }
        catch (McIDASException mcIDASException) {
            throw new CoordinateSystemException("AREACoordinateSystem: problem creating navigation" + mcIDASException);
        }
        this.anav.setImageStart(nArray[5], nArray[6]);
        this.anav.setRes(nArray[11], nArray[12]);
        this.anav.setStart(1, 1);
        this.anav.setMag(1, 1);
        this.lines = nArray[8];
        this.elements = nArray[9];
        this.anav.setFlipLineCoordinates(nArray[8]);
    }
}

