/*
 * Decompiled with CFR 0.152.
 */
package visad.data.jai;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.util.DataUtility;
import visad.util.ReflectedUniverse;

public class JAIForm
extends Form
implements FormFileInformer {
    private static int num = 0;
    private static final String[] suffixes = new String[]{"bmp", "gif", "flashpix", "jpg", "jpeg", "jpe", "png", "pnm", "tif", "tiff"};
    private static boolean noJai = false;
    private static ReflectedUniverse r = JAIForm.createReflectedUniverse();

    private static ReflectedUniverse createReflectedUniverse() {
        ReflectedUniverse reflectedUniverse = null;
        try {
            reflectedUniverse = new ReflectedUniverse();
            reflectedUniverse.exec("import javax.media.jai.JAI");
            reflectedUniverse.exec("import javax.media.jai.PlanarImage");
        }
        catch (VisADException visADException) {
            noJai = true;
        }
        return reflectedUniverse;
    }

    private static BufferedImage createImage(String string, Object object) {
        BufferedImage bufferedImage = null;
        try {
            r.setVar("s", string);
            r.setVar("o", object);
            r.exec("pi = JAI.create(s, o)");
            bufferedImage = (BufferedImage)r.exec("pi.getAsBufferedImage()");
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        return bufferedImage;
    }

    public boolean isThisType(String string) {
        if (noJai) {
            return false;
        }
        int n = 0;
        while (n < suffixes.length) {
            if (string.toLowerCase().endsWith(suffixes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isThisType(byte[] byArray) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] stringArray = new String[suffixes.length];
        System.arraycopy(suffixes, 0, stringArray, 0, suffixes.length);
        return stringArray;
    }

    public void save(String string, Data data, boolean bl) throws BadFormException, IOException, RemoteException, VisADException {
        throw new BadFormException("JAIForm.save");
    }

    public void add(String string, Data data, boolean bl) throws BadFormException {
        throw new BadFormException("JAIForm.add");
    }

    public DataImpl open(String string) throws BadFormException, IOException, VisADException {
        if (noJai) {
            throw new BadFormException("you need to install JAI from http://java.sun.com/products/java-media/jai/index.html");
        }
        BufferedImage bufferedImage = JAIForm.createImage("fileload", string);
        return this.open(bufferedImage);
    }

    public DataImpl open(URL uRL) throws BadFormException, IOException, VisADException {
        if (noJai) {
            throw new BadFormException("you need to install JAI from http://java.sun.com/products/java-media/jai/index.html");
        }
        BufferedImage bufferedImage = JAIForm.createImage("URL", uRL);
        return this.open(bufferedImage);
    }

    private DataImpl open(BufferedImage bufferedImage) throws BadFormException, IOException, VisADException {
        if (bufferedImage == null) {
            throw new BadFormException("JAI could not read the file as an image");
        }
        return DataUtility.makeField(bufferedImage);
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        if (stringArray == null || stringArray.length < 1) {
            System.out.println("To test read an image file, run:");
            System.out.println("  java visad.data.jai.JAIForm in_file");
            System.exit(2);
        }
        JAIForm jAIForm = new JAIForm();
        System.out.print("Reading " + stringArray[0] + " ");
        DataImpl dataImpl = jAIForm.open(stringArray[0]);
        System.out.println("[done]");
        System.out.println("MathType =\n" + dataImpl.getType().prettyString());
        System.exit(0);
    }

    public JAIForm() {
        super("JAIForm" + num++);
    }
}

