/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.data.in.ValueProcessor;
import visad.data.in.ValueRanger;

public class ValueRanger
extends ValueProcessor {
    private static final WeakHashMap map = new WeakHashMap();
    private static final ValueRanger trivialRanger = new 1();
    private float floatLower = Float.NEGATIVE_INFINITY;
    private float floatUpper = Float.POSITIVE_INFINITY;
    private double doubleLower = Double.NEGATIVE_INFINITY;
    private double doubleUpper = Double.POSITIVE_INFINITY;

    public static ValueRanger valueRanger(double d, double d2) {
        ValueRanger valueRanger;
        if (!(d == d && d != Double.NEGATIVE_INFINITY || d2 == d2 && d2 != Double.POSITIVE_INFINITY)) {
            valueRanger = trivialRanger;
        } else {
            valueRanger = new ValueRanger(d, d2);
            WeakReference weakReference = (WeakReference)map.get(valueRanger);
            if (weakReference == null) {
                map.put(valueRanger, new WeakReference<ValueRanger>(valueRanger));
            } else {
                ValueRanger valueRanger2 = (ValueRanger)weakReference.get();
                if (valueRanger2 == null) {
                    map.put(valueRanger, new WeakReference<ValueRanger>(valueRanger));
                } else {
                    valueRanger = valueRanger2;
                }
            }
        }
        return valueRanger;
    }

    public double getMin() {
        return this.doubleLower;
    }

    public double getMax() {
        return this.doubleUpper;
    }

    public float process(float f) {
        return f < this.floatLower || f > this.floatUpper ? Float.NaN : f;
    }

    public double process(double d) {
        return d < this.doubleLower || d > this.doubleUpper ? Double.NaN : d;
    }

    public float[] process(float[] fArray) {
        int n = 0;
        while (n < fArray.length) {
            double d = fArray[n];
            if (d < (double)this.floatLower || d > (double)this.floatUpper) {
                fArray[n] = Float.NaN;
            }
            ++n;
        }
        return fArray;
    }

    public double[] process(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            double d = dArray[n];
            if (d < this.doubleLower || d > this.doubleUpper) {
                dArray[n] = Double.NaN;
            }
            ++n;
        }
        return dArray;
    }

    public boolean equals(Object object) {
        ValueRanger valueRanger;
        boolean bl = !this.getClass().isInstance(object) ? false : this == (valueRanger = (ValueRanger)object) || this.doubleLower == valueRanger.doubleLower && this.doubleUpper == valueRanger.doubleUpper;
        return bl;
    }

    public int hashCode() {
        return new Double(this.doubleLower).hashCode() ^ new Double(this.doubleUpper).hashCode();
    }

    protected ValueRanger() {
    }

    private ValueRanger(double d, double d2) {
        this.doubleLower = d == d ? d : Double.NEGATIVE_INFINITY;
        this.doubleUpper = d2 == d2 ? d2 : Double.POSITIVE_INFINITY;
        this.floatLower = (float)this.doubleLower;
        this.floatUpper = (float)this.doubleUpper;
    }
}

