/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.data.in.ValueVetter;

final class SingleValueVetter
extends ValueVetter {
    private static final WeakHashMap map = new WeakHashMap();
    private double doubleValue;
    private float floatValue;

    static synchronized SingleValueVetter singleValueVetter(double d) {
        SingleValueVetter singleValueVetter = new SingleValueVetter(d);
        WeakReference weakReference = (WeakReference)map.get(singleValueVetter);
        if (weakReference == null) {
            map.put(singleValueVetter, new WeakReference<SingleValueVetter>(singleValueVetter));
        } else {
            SingleValueVetter singleValueVetter2 = (SingleValueVetter)weakReference.get();
            if (singleValueVetter2 == null) {
                map.put(singleValueVetter, new WeakReference<SingleValueVetter>(singleValueVetter));
            } else {
                singleValueVetter = singleValueVetter2;
            }
        }
        return singleValueVetter;
    }

    public float process(float f) {
        return f == this.floatValue ? Float.NaN : f;
    }

    public double process(double d) {
        return d == this.doubleValue ? Double.NaN : d;
    }

    public float[] process(float[] fArray) {
        int n = 0;
        while (n < fArray.length) {
            if (fArray[n] == this.floatValue) {
                fArray[n] = Float.NaN;
            }
            ++n;
        }
        return fArray;
    }

    public double[] process(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] == this.doubleValue) {
                dArray[n] = Double.NaN;
            }
            ++n;
        }
        return dArray;
    }

    public boolean equals(Object object) {
        SingleValueVetter singleValueVetter;
        boolean bl = !this.getClass().isInstance(object) ? false : this == (singleValueVetter = (SingleValueVetter)object) || this.doubleValue == singleValueVetter.doubleValue;
        return bl;
    }

    public int hashCode() {
        return new Double(this.doubleValue).hashCode();
    }

    private SingleValueVetter(double d) {
        this.doubleValue = d;
        this.floatValue = (float)d;
    }
}

