/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.data.in.ValueUnpacker;

public final class ScaleUnpacker
extends ValueUnpacker {
    private static final WeakHashMap map = new WeakHashMap();
    private final float floatScale;
    private final double doubleScale;

    public static synchronized ScaleUnpacker scaleUnpacker(double d) {
        ScaleUnpacker scaleUnpacker = new ScaleUnpacker(d);
        WeakReference weakReference = (WeakReference)map.get(scaleUnpacker);
        if (weakReference == null) {
            map.put(scaleUnpacker, new WeakReference<ScaleUnpacker>(scaleUnpacker));
        } else {
            ScaleUnpacker scaleUnpacker2 = (ScaleUnpacker)weakReference.get();
            if (scaleUnpacker2 == null) {
                map.put(scaleUnpacker, new WeakReference<ScaleUnpacker>(scaleUnpacker));
            } else {
                scaleUnpacker = scaleUnpacker2;
            }
        }
        return scaleUnpacker;
    }

    public double getIncrement() {
        return Math.abs(this.doubleScale);
    }

    public float process(float f) {
        return this.floatScale * f;
    }

    public double process(double d) {
        return this.doubleScale * d;
    }

    public float[] process(float[] fArray) {
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] * this.floatScale;
        }
        return fArray;
    }

    public double[] process(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * this.doubleScale;
        }
        return dArray;
    }

    public boolean equals(Object object) {
        ScaleUnpacker scaleUnpacker;
        boolean bl = !this.getClass().isInstance(object) ? false : this == (scaleUnpacker = (ScaleUnpacker)object) || this.doubleScale == scaleUnpacker.doubleScale;
        return bl;
    }

    public int hashCode() {
        return new Double(this.doubleScale).hashCode();
    }

    private ScaleUnpacker(double d) {
        this.floatScale = (float)d;
        this.doubleScale = d;
    }
}

