/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.data.in.ValueUnpacker;

public final class ScaleAndOffsetUnpacker
extends ValueUnpacker {
    private static final WeakHashMap map = new WeakHashMap();
    private final float floatScale;
    private final double doubleScale;
    private final float floatOffset;
    private final double doubleOffset;

    public static synchronized ScaleAndOffsetUnpacker scaleAndOffsetUnpacker(double d, double d2) {
        ScaleAndOffsetUnpacker scaleAndOffsetUnpacker = new ScaleAndOffsetUnpacker(d, d2);
        WeakReference weakReference = (WeakReference)map.get(scaleAndOffsetUnpacker);
        if (weakReference == null) {
            map.put(scaleAndOffsetUnpacker, new WeakReference<ScaleAndOffsetUnpacker>(scaleAndOffsetUnpacker));
        } else {
            ScaleAndOffsetUnpacker scaleAndOffsetUnpacker2 = (ScaleAndOffsetUnpacker)weakReference.get();
            if (scaleAndOffsetUnpacker2 == null) {
                map.put(scaleAndOffsetUnpacker, new WeakReference<ScaleAndOffsetUnpacker>(scaleAndOffsetUnpacker));
            } else {
                scaleAndOffsetUnpacker = scaleAndOffsetUnpacker2;
            }
        }
        return scaleAndOffsetUnpacker;
    }

    public double getIncrement() {
        return Math.abs(this.doubleScale);
    }

    public float process(float f) {
        return this.floatScale * f + this.floatOffset;
    }

    public double process(double d) {
        return this.doubleScale * d + this.doubleOffset;
    }

    public float[] process(float[] fArray) {
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = fArray[n] * this.floatScale + this.floatOffset;
            ++n;
        }
        return fArray;
    }

    public double[] process(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = dArray[n] * this.doubleScale + this.doubleOffset;
            ++n;
        }
        return dArray;
    }

    public boolean equals(Object object) {
        ScaleAndOffsetUnpacker scaleAndOffsetUnpacker;
        boolean bl = !this.getClass().isInstance(object) ? false : this == (scaleAndOffsetUnpacker = (ScaleAndOffsetUnpacker)object) || this.doubleOffset == scaleAndOffsetUnpacker.doubleOffset && this.doubleScale == scaleAndOffsetUnpacker.doubleScale;
        return bl;
    }

    public int hashCode() {
        return new Double(this.doubleOffset).hashCode() ^ new Double(this.doubleScale).hashCode();
    }

    private ScaleAndOffsetUnpacker(double d, double d2) {
        this.floatScale = (float)d;
        this.doubleScale = d;
        this.floatOffset = (float)d2;
        this.doubleOffset = d2;
    }
}

