/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.data.in.ValueVetter;

final class DoubleValueVetter
extends ValueVetter {
    private static final WeakHashMap map = new WeakHashMap();
    private double doubleValue1;
    private double doubleValue2;
    private float floatValue1;
    private float floatValue2;

    static synchronized DoubleValueVetter doubleValueVetter(double d, double d2) {
        DoubleValueVetter doubleValueVetter = new DoubleValueVetter(d, d2);
        WeakReference weakReference = (WeakReference)map.get(doubleValueVetter);
        if (weakReference == null) {
            map.put(doubleValueVetter, new WeakReference<DoubleValueVetter>(doubleValueVetter));
        } else {
            DoubleValueVetter doubleValueVetter2 = (DoubleValueVetter)weakReference.get();
            if (doubleValueVetter2 == null) {
                map.put(doubleValueVetter, new WeakReference<DoubleValueVetter>(doubleValueVetter));
            } else {
                doubleValueVetter = doubleValueVetter2;
            }
        }
        return doubleValueVetter;
    }

    public float process(float f) {
        return f == this.floatValue1 || f == this.floatValue2 ? Float.NaN : f;
    }

    public double process(double d) {
        return d == this.doubleValue1 || d == this.doubleValue2 ? Double.NaN : d;
    }

    public float[] process(float[] fArray) {
        int n = 0;
        while (n < fArray.length) {
            float f = fArray[n];
            if (f == this.floatValue1 || f == this.floatValue2) {
                fArray[n] = Float.NaN;
            }
            ++n;
        }
        return fArray;
    }

    public double[] process(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            double d = dArray[n];
            if (d == this.doubleValue1 || d == this.doubleValue2) {
                dArray[n] = Double.NaN;
            }
            ++n;
        }
        return dArray;
    }

    public boolean equals(Object object) {
        DoubleValueVetter doubleValueVetter;
        boolean bl = !this.getClass().isInstance(object) ? false : this == (doubleValueVetter = (DoubleValueVetter)object) || this.doubleValue1 == doubleValueVetter.doubleValue1 && this.doubleValue2 == doubleValueVetter.doubleValue2;
        return bl;
    }

    public int hashCode() {
        return new Double(this.doubleValue1).hashCode() ^ new Double(this.doubleValue2).hashCode();
    }

    private DoubleValueVetter(double d, double d2) {
        this.doubleValue1 = d;
        this.doubleValue2 = d2;
        this.floatValue1 = (float)d;
        this.floatValue2 = (float)d2;
    }
}

