/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import visad.VisADException;

public class ArithProg {
    protected long n;
    protected double first = Double.NaN;
    protected double last = Double.NaN;
    protected double meanDel = Double.NaN;
    protected boolean isConsistent = true;
    protected final double fEps;
    protected final double dEps;
    private final double[] dValues = new double[1];
    private final float[] fValues = new float[1];

    public synchronized boolean accumulate(float[] fArray) throws VisADException {
        if (!this.isConsistent()) {
            throw new VisADException(this.getClass().getName() + ".accumulate(float[]): " + "Sequence isn't an arithmetic progression");
        }
        int n = 0;
        while (n < fArray.length) {
            double d = fArray[n];
            if (this.n == 0L) {
                this.first = d;
            } else if (this.n == 1L) {
                this.meanDel = d - this.first;
            } else if (this.isConsistent) {
                this.accum(d, 5.0E-5f);
            }
            this.last = d;
            ++this.n;
            ++n;
        }
        return this.isConsistent;
    }

    public synchronized boolean accumulate(double[] dArray) throws VisADException {
        if (!this.isConsistent()) {
            throw new VisADException(this.getClass().getName() + ".accumulate(double[]): " + "Sequence isn't an arithmetic progression");
        }
        int n = 0;
        while (n < dArray.length) {
            double d = dArray[n];
            if (this.n == 0L) {
                this.first = d;
            } else if (this.n == 1L) {
                this.meanDel = d - this.first;
            } else if (this.isConsistent) {
                this.accum(d, 5.0E-9);
            }
            this.last = d;
            ++this.n;
            ++n;
        }
        return this.isConsistent;
    }

    private void accum(double d, double d2) {
        double d3 = d - (this.last + this.meanDel);
        double d4 = this.last * d2;
        double d5 = d * d2;
        double d6 = d4 * d4 + d5 * d5;
        if (d3 * d3 > d6) {
            this.isConsistent = false;
        } else {
            this.meanDel = (d - this.first) / (double)this.n;
        }
    }

    public final synchronized boolean accumulate(float f) throws VisADException {
        if (!this.isConsistent()) {
            throw new VisADException(this.getClass().getName() + ".accumulate(double): " + "Sequence isn't an arithmetic progression");
        }
        this.fValues[0] = f;
        return this.accumulate(this.fValues);
    }

    public final synchronized boolean accumulate(double d) throws VisADException {
        if (!this.isConsistent()) {
            throw new VisADException(this.getClass().getName() + ".accumulate(double): " + "Sequence isn't an arithmetic progression");
        }
        this.dValues[0] = d;
        return this.accumulate(this.dValues);
    }

    public final synchronized boolean isConsistent() {
        return this.isConsistent;
    }

    public final synchronized long getNumber() throws VisADException {
        if (!this.isConsistent()) {
            throw new VisADException(this.getClass().getName() + ".getNumber(): " + "Sequence isn't an arithmetic progression");
        }
        return this.n;
    }

    public final synchronized double getFirst() throws VisADException {
        if (!this.isConsistent()) {
            throw new VisADException(this.getClass().getName() + ".getFirst(): " + "Sequence isn't an arithmetic progression");
        }
        return this.first;
    }

    public final synchronized double getLast() throws VisADException {
        if (!this.isConsistent()) {
            throw new VisADException(this.getClass().getName() + ".getLast(): " + "Sequence isn't an arithmetic progression");
        }
        return this.last;
    }

    public final synchronized double getCommonDifference() throws VisADException {
        if (!this.isConsistent()) {
            throw new VisADException(this.getClass().getName() + ".getCommonDifference(): " + "Sequence isn't an arithmetic progression");
        }
        return this.meanDel;
    }

    public static void main(String[] stringArray) throws Exception {
        double[] dArray = new double[]{39.2, 39.21, 39.22, 39.23, 39.24, 39.25, 39.26, 39.27, 39.28, 39.29, 39.3, 39.31, 39.32, 39.33, 39.34, 39.35, 39.36, 39.37, 39.38, 39.39, 39.4, 39.41, 39.42, 39.43, 39.44, 39.45, 39.46, 39.47, 39.48, 39.49, 39.5, 39.51, 39.52, 39.53, 39.54, 39.55, 39.56, 39.57, 39.58, 39.59, 39.6, 39.61, 39.62, 39.63, 39.64, 39.65, 39.66, 39.67, 39.68, 39.69, 39.7, 39.71, 39.72, 39.73, 39.74, 39.75, 39.76, 39.77, 39.78, 39.79, 39.8, 39.81, 39.82, 39.83, 39.84, 39.85, 39.86, 39.87, 39.88, 39.89, 39.9, 39.91, 39.92, 39.93, 39.94, 39.95, 39.96, 39.97, 39.98, 39.99, 40.0};
        ArithProg arithProg = new ArithProg();
        arithProg.accumulate(dArray);
    }

    public ArithProg() {
        this.fEps = 5.0E-5f;
        this.dEps = 5.0E-9;
    }
}

