/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.data.hdfeos.Calibration;
import visad.data.hdfeos.DimensionSet;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.NamedDimension;

public class Variable {
    String name;
    int rank;
    int type;
    DimensionSet dimSet;
    Calibration calibration;
    boolean coordVar = false;

    public String getName() {
        String string = this.name;
        return string;
    }

    public int getRank() {
        return this.rank;
    }

    public Calibration getCalibration() {
        return this.calibration;
    }

    public boolean equals(Variable variable) {
        return this.name.equals(variable.getName());
    }

    public DimensionSet getDimSet() {
        return this.dimSet;
    }

    public NamedDimension getDim(int n) {
        return this.dimSet.getElement(n);
    }

    public int getNumberType() {
        return this.type;
    }

    public boolean isCoordVar() {
        return this.coordVar;
    }

    public String toString() {
        String string = "Variable:  " + this.name + "\n" + "    rank:  " + this.rank + "\n" + "    type:  " + this.type + "\n" + "  " + this.dimSet.toString() + "\n";
        return string;
    }

    Variable(String string, DimensionSet dimensionSet, int n, int n2, Calibration calibration) throws HdfeosException {
        if (dimensionSet.getSize() != n) {
            throw new HdfeosException(" rank and DimensionSet length don't match");
        }
        this.name = string;
        this.dimSet = dimensionSet;
        this.type = n2;
        this.rank = n;
        this.calibration = calibration;
        if (n == 1 && string.equalsIgnoreCase(dimensionSet.getElement(0).getName())) {
            this.coordVar = true;
        }
    }
}

