/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.GctpFunction;

public class PolarStereographic
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{null, null};
    double r_major;
    double r_minor;
    double es;
    double e;
    double e4;
    double center_lon;
    double center_lat;
    double fac;
    double ind;
    double mcs;
    double tcs;
    double false_northing;
    double false_easting;

    public static PolarStereographic makePolarStereographic(RealTupleType realTupleType, double d, double d2, double d3) throws VisADException {
        return PolarStereographic.makePolarStereographic(realTupleType, 6371230.0, 6371230.0, d, d2, d3, 1.0471975511965976);
    }

    public static PolarStereographic makePolarStereographic(RealTupleType realTupleType, double d, double d2, double d3, double d4, double d5, double d6) throws VisADException {
        PolarStereographic polarStereographic = new PolarStereographic(realTupleType, d, d2, d5, d6, 0.0, 0.0);
        double[][] dArray = polarStereographic.fromReference(new double[][]{{d4}, {d3}});
        double d7 = dArray[0][0];
        double d8 = dArray[1][0];
        return new PolarStereographic(realTupleType, d, d2, d5, d6, -d7, -d8);
    }

    public double[][] toReference(double[][] dArray) throws VisADException {
        int n = dArray[0].length;
        int n2 = dArray.length;
        if (n2 != 2) {
            throw new VisADException("PolarStereographic: tuple dim != 2");
        }
        double[][] dArray2 = new double[2][n];
        int n3 = 0;
        while (n3 < n) {
            double d;
            double d2 = (dArray[0][n3] - this.false_easting) * this.fac;
            double d3 = (dArray[1][n3] - this.false_northing) * this.fac;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            double d5 = this.ind != 0.0 ? d4 * this.tcs / (this.r_major * this.mcs) : d4 * this.e4 / (this.r_major * 2.0);
            double d6 = GctpFunction.phi2z(this.e, d5);
            if (d6 != Double.NaN) {
                d6 *= this.fac;
            }
            if (d4 == 0.0) {
                d = this.fac * this.center_lon;
            } else {
                double d7 = Math.atan2(d2, -d3);
                d = GctpFunction.adjust_lon(this.fac * d7 + this.center_lon);
            }
            dArray2[0][n3] = d;
            dArray2[1][n3] = d6;
            ++n3;
        }
        return dArray2;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        int n = dArray[0].length;
        int n2 = dArray.length;
        if (n2 != 2) {
            throw new VisADException("PolarStereographic: tuple dim != 2");
        }
        double[][] dArray2 = new double[2][n];
        int n3 = 0;
        while (n3 < n) {
            double d = dArray[0][n3];
            double d2 = dArray[1][n3];
            double d3 = this.fac * GctpFunction.adjust_lon(d - this.center_lon);
            double d4 = this.fac * d2;
            double d5 = Math.sin(d4);
            double d6 = GctpFunction.tsfnz(this.e, d4, d5);
            double d7 = this.ind != 0.0 ? this.r_major * this.mcs * d6 / this.tcs : 2.0 * this.r_major * d6 / this.e4;
            dArray2[0][n3] = this.fac * d7 * Math.sin(d3) + this.false_easting;
            dArray2[1][n3] = -this.fac * d7 * Math.cos(d3) + this.false_northing;
            ++n3;
        }
        return dArray2;
    }

    public boolean equals(Object object) {
        return object instanceof PolarStereographic;
    }

    public static void main(String[] stringArray) throws VisADException {
        double d = 6371230.0;
        double d2 = 6371230.0;
        double d3 = 0.6981317007977318;
        double d4 = -1.7453292519943295;
        double d5 = 0.0;
        double d6 = 0.0;
        double[][] dArray = new double[][]{{-2.3292989, -1.6580627, -1.6580627, -1.6580627, d4}, {0.2127555, 0.4363323, 0.6981317, 0.8726646, 1.5707963267948966}};
        RealType[] realTypeArray = new RealType[]{RealType.Longitude, RealType.Latitude};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        PolarStereographic polarStereographic = new PolarStereographic(realTupleType, d, d2, d4, d3, d5, d6);
        double[][] dArray2 = ((CoordinateSystem)polarStereographic).fromReference(dArray);
        int n = 0;
        while (n < dArray[0].length) {
            System.out.println(dArray[0][n] + ",  " + dArray[1][n]);
            ++n;
        }
        System.out.println("--------------------------\n");
        n = 0;
        while (n < dArray2[0].length) {
            System.out.println(dArray2[0][n] + ",  " + dArray2[1][n]);
            ++n;
        }
        double[][] dArray3 = ((CoordinateSystem)polarStereographic).toReference(dArray2);
        System.out.println("--------------------------\n");
        int n2 = 0;
        while (n2 < dArray3[0].length) {
            System.out.println(dArray3[0][n2] + ",  " + dArray3[1][n2]);
            ++n2;
        }
        PolarStereographic polarStereographic2 = PolarStereographic.makePolarStereographic(realTupleType, -0.36348227002033906, -2.6179938779914944, -1.8325957145940461);
        dArray2 = polarStereographic2.fromReference(new double[][]{{-2.6179938779914944}, {-0.36348227002033906}});
        System.out.println("x: " + dArray2[0][0]);
        System.out.println("y: " + dArray2[1][0]);
        dArray2 = polarStereographic2.fromReference(new double[][]{{-1.8325957145940461}, {1.5707963267948966}});
        System.out.println("x: " + dArray2[0][0]);
        System.out.println("y: " + dArray2[1][0]);
    }

    public PolarStereographic(double d, double d2) throws VisADException {
        this(RealTupleType.SpatialEarth2DTuple, 6371230.0, 6371230.0, d, d2, 0.0, 0.0);
    }

    public PolarStereographic(double d, double d2, double d3, double d4) throws VisADException {
        this(RealTupleType.SpatialEarth2DTuple, d, d2, d3, d4, 0.0, 0.0);
    }

    public PolarStereographic(RealTupleType realTupleType, double d, double d2, double d3, double d4) throws VisADException {
        this(realTupleType, d, d2, d3, d4, 0.0, 0.0);
    }

    public PolarStereographic(RealTupleType realTupleType, double d, double d2, double d3, double d4, double d5, double d6) throws VisADException {
        super(realTupleType, coordinate_system_units);
        this.r_major = d;
        this.r_minor = d2;
        this.center_lon = d3;
        this.center_lat = d4;
        this.false_easting = d5;
        this.false_northing = d6;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double d7 = d2 / d;
        this.es = 1.0 - d7 * d7;
        this.e = Math.sqrt(this.es);
        this.e4 = GctpFunction.e4fn(this.e);
        this.fac = d4 < 0.0 ? -1.0 : 1.0;
        this.ind = 0.0;
        if (Math.abs(Math.abs(d4) - 1.5707963267948966) > 1.0E-10) {
            double d8;
            this.ind = 1.0;
            dArray[0] = d8 = this.fac * this.center_lat;
            GctpFunction.sincos(dArray, dArray2, dArray3);
            double d9 = dArray2[0];
            double d10 = dArray3[0];
            this.mcs = GctpFunction.msfnz(this.e, d9, d10);
            this.tcs = GctpFunction.tsfnz(this.e, d8, d9);
        }
    }
}

