/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.GctpException;
import visad.data.hdfeos.GctpFunction;

public class LambertConformalConic
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{SI.meter, SI.meter};
    double r_major;
    double es;
    double e;
    double r_minor;
    double lon_center;
    double lat_center;
    double ns;
    double f0;
    double rh;
    double false_easting;
    double false_northing;

    public double[][] toReference(double[][] dArray) throws VisADException {
        int n = dArray[0].length;
        int n2 = dArray.length;
        if (n2 != 2) {
            throw new VisADException("LambertConformalConic: tuple dim != 2");
        }
        double[][] dArray2 = new double[2][n];
        int n3 = 0;
        while (n3 < n) {
            double d;
            double d2;
            double d3 = dArray[1][n3];
            double d4 = dArray[0][n3];
            long l = 0L;
            d4 -= this.false_easting;
            d3 = this.rh - d3 + this.false_northing;
            if (this.ns > 0.0) {
                d2 = Math.sqrt(d4 * d4 + d3 * d3);
                d = 1.0;
            } else {
                d2 = -Math.sqrt(d4 * d4 + d3 * d3);
                d = -1.0;
            }
            double d5 = 0.0;
            if (d2 != 0.0) {
                d5 = Math.atan2(d * d4, d * d3);
            }
            if (d2 != 0.0 || this.ns > 0.0) {
                d = 1.0 / this.ns;
                double d6 = Math.pow(d2 / (this.r_major * this.f0), d);
                dArray2[1][n3] = GctpFunction.phi2z(this.e, d6);
            } else {
                dArray2[1][n3] = -1.5707963267948966;
            }
            dArray2[0][n3] = GctpFunction.adjust_lon(d5 / this.ns + this.lon_center);
            ++n3;
        }
        return dArray2;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        int n = dArray[0].length;
        int n2 = dArray.length;
        if (n2 != 2) {
            throw new VisADException("LambertConformalConic: tuple dim != 2");
        }
        double[] dArray2 = new double[n];
        double[][] dArray3 = new double[2][n];
        int n3 = 0;
        while (n3 < n) {
            double d = dArray[0][n3];
            double d2 = dArray[1][n3];
            double d3 = Math.abs(Math.abs(d2) - 1.5707963267948966);
            if (d3 > 1.0E-10) {
                double d4 = Math.sin(d2);
                double d5 = GctpFunction.tsfnz(this.e, d2, d4);
                dArray2[n3] = this.r_major * this.f0 * Math.pow(d5, this.ns);
            } else {
                d3 = d2 * this.ns;
                if (d3 <= 0.0) {
                    dArray3[0][n3] = Double.NaN;
                    dArray3[1][n3] = Double.NaN;
                }
                dArray2[n3] = 0.0;
            }
            double d6 = this.ns * GctpFunction.adjust_lon(d - this.lon_center);
            dArray3[0][n3] = dArray2[n3] * Math.sin(d6) + this.false_easting;
            dArray3[1][n3] = this.rh - dArray2[n3] * Math.cos(d6) + this.false_northing;
            ++n3;
        }
        return dArray3;
    }

    public boolean equals(Object object) {
        return object instanceof LambertConformalConic;
    }

    public static void main(String[] stringArray) throws VisADException {
        LambertConformalConic lambertConformalConic = null;
        double[][] dArray = new double[][]{{-2.3292989, -1.6580627, -1.6580627, -1.6580627}, {0.2127555, 0.4363323, 0.6981317, 0.8726646}};
        RealType realType = new RealType("Theta", (Unit)SI.radian, null);
        RealType realType2 = new RealType("radius", (Unit)SI.meter, null);
        RealType[] realTypeArray = new RealType[]{RealType.Longitude, RealType.Latitude};
        double d = 6367470.0;
        double d2 = 6367470.0;
        double d3 = 0.4014257279586958;
        double d4 = 0.47123889803846897;
        double d5 = 0.4363323129985824;
        double d6 = -1.6580627893946132;
        double d7 = 0.0;
        double d8 = 0.0;
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        lambertConformalConic = new LambertConformalConic(realTupleType, d, d2, d3, d4, d6, d5, d7, d8);
        double[][] dArray2 = ((CoordinateSystem)lambertConformalConic).fromReference(dArray);
        int n = 0;
        while (n < dArray2[0].length) {
            System.out.println(dArray2[0][n] + ",  " + dArray2[1][n]);
            ++n;
        }
        System.out.println(" ");
        double[][] dArray3 = ((CoordinateSystem)lambertConformalConic).toReference(dArray2);
        int n2 = 0;
        while (n2 < dArray3[0].length) {
            System.out.println(dArray3[0][n2] + ",  " + dArray3[1][n2]);
            ++n2;
        }
    }

    public LambertConformalConic(RealTupleType realTupleType, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) throws VisADException {
        super(realTupleType, coordinate_system_units);
        this.r_major = d;
        this.r_minor = d2;
        this.lon_center = d5;
        this.lat_center = d6;
        this.false_easting = d7;
        this.false_northing = d8;
        if (Math.abs(d3 + d4) < 1.0E-10) {
            throw new GctpException("Equal latitudes for st. paralles on opposite sides of equator");
        }
        double d9 = d2 / d;
        this.es = 1.0 - d9 * d9;
        this.e = Math.sqrt(this.es);
        double d10 = Math.sin(d3);
        double d11 = Math.cos(d3);
        double d12 = d10;
        double d13 = GctpFunction.msfnz(this.e, d10, d11);
        double d14 = GctpFunction.tsfnz(this.e, d3, d10);
        d10 = Math.sin(d4);
        d11 = Math.cos(d4);
        double d15 = GctpFunction.msfnz(this.e, d10, d11);
        double d16 = GctpFunction.tsfnz(this.e, d4, d10);
        d10 = Math.sin(d6);
        double d17 = GctpFunction.tsfnz(this.e, d6, d10);
        this.ns = Math.abs(d3 - d4) > 1.0E-10 ? Math.log(d13 / d15) / Math.log(d14 / d16) : d12;
        this.f0 = d13 / (this.ns * Math.pow(d14, this.ns));
        this.rh = d * this.f0 * Math.pow(d17, this.ns);
    }
}

