/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.GctpFunction;

public class LambertAzimuthalEqualArea
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{null, null};
    double R;
    double lon_center;
    double lat_center;
    double false_easting;
    double false_northing;
    double sin_lat_o;
    double cos_lat_o;

    public double[][] toReference(double[][] dArray) throws VisADException {
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        int n = dArray[0].length;
        int n2 = dArray.length;
        if (n2 != 2) {
            throw new VisADException("LambertAzimuthalEqualArea: tuple dim != 2");
        }
        double[][] dArray5 = new double[2][n];
        int n3 = 0;
        while (n3 < n) {
            double d;
            double d2;
            double d3 = dArray[0][n3] - this.false_easting;
            double d4 = dArray[0][n3] - this.false_northing;
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            double d6 = d5 / (2.0 * this.R);
            if (d6 > 1.0) {
                // empty if block
            }
            dArray4[0] = d2 = 2.0 * GctpFunction.asinz(d6);
            GctpFunction.sincos(dArray4, dArray2, dArray3);
            double d7 = dArray2[0];
            double d8 = dArray3[0];
            double d9 = this.lon_center;
            if (Math.abs(d5) > 1.0E-10) {
                d = GctpFunction.asinz(this.sin_lat_o * d8 + this.cos_lat_o * d7 * d4 / d5);
                d6 = Math.abs(this.lat_center) - 1.5707963267948966;
                if (Math.abs(d6) > 1.0E-10) {
                    d6 = d8 - this.sin_lat_o * Math.sin(d);
                    if (d6 != 0.0) {
                        d9 = GctpFunction.adjust_lon(this.lon_center + Math.atan2(d3 * d7 * this.cos_lat_o, d6 * d5));
                    }
                } else {
                    d9 = this.lat_center < 0.0 ? GctpFunction.adjust_lon(this.lon_center - Math.atan2(-d3, d4)) : GctpFunction.adjust_lon(this.lon_center + Math.atan2(d3, -d4));
                }
            } else {
                d = this.lat_center;
            }
            dArray5[0][n3] = d;
            dArray5[1][n3] = d9;
            ++n3;
        }
        return dArray5;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        int n = dArray[0].length;
        int n2 = dArray.length;
        if (n2 != 2) {
            throw new VisADException("LambertAzimuthalEqualArea: tuple dim != 2");
        }
        double[][] dArray2 = new double[2][n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray3[n3] = dArray[1][n3] - this.lon_center;
            ++n3;
        }
        GctpFunction.adjust_lon(dArray3);
        GctpFunction.sincos(dArray[0], dArray4, dArray5);
        GctpFunction.sincos(dArray3, dArray6, dArray7);
        n3 = 0;
        while (n3 < n) {
            double d = this.sin_lat_o * dArray4[n3] + this.cos_lat_o * dArray5[n3] * dArray7[n3];
            if (d == -1.0) {
                throw new VisADException("Point projects to a circle of radius = " + 2.0 * this.R);
            }
            double d2 = this.R * Math.sqrt(2.0 / (1.0 + d));
            dArray2[0][n3] = d2 * dArray5[n3] * dArray6[n3] + this.false_easting;
            dArray2[1][n3] = d2 * (this.cos_lat_o * dArray4[n3] - this.sin_lat_o * dArray5[n3] * dArray7[n3]) + this.false_northing;
            ++n3;
        }
        dArray3 = null;
        dArray4 = null;
        dArray5 = null;
        dArray6 = null;
        dArray7 = null;
        return dArray2;
    }

    public boolean equals(Object object) {
        return object instanceof LambertAzimuthalEqualArea;
    }

    public static void main(String[] stringArray) throws VisADException {
        CoordinateSystem coordinateSystem = null;
        double[][] dArray = new double[][]{{0.0, 0.5236, 1.0472, 1.5708}, {1.0, 1.0, 1.0, 1.0}};
        double[][] dArray2 = new double[2][4];
        RealType realType = new RealType("Theta", (Unit)SI.radian, null);
        RealType realType2 = new RealType("radius", (Unit)SI.meter, null);
        RealType[] realTypeArray = new RealType[]{realType, realType2};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray, coordinateSystem, null);
        dArray2 = realTupleType2.getCoordinateSystem().fromReference(dArray);
        int n = 0;
        while (n < dArray2[0].length) {
            System.out.println(dArray2[0][n] + ",  " + dArray2[1][n]);
            ++n;
        }
        dArray = realTupleType2.getCoordinateSystem().toReference(dArray2);
        n = 0;
        while (n < dArray[0].length) {
            System.out.println(dArray[0][n] + ",  " + dArray[1][n]);
            ++n;
        }
        ScaledUnit scaledUnit = new ScaledUnit(1000.0, SI.meter);
    }

    public LambertAzimuthalEqualArea(RealTupleType realTupleType, double d, double d2, double d3, double d4, double d5) throws VisADException {
        super(realTupleType, coordinate_system_units);
        this.R = d;
        this.lon_center = d2;
        this.lat_center = d3;
        this.false_easting = d4;
        this.false_northing = d5;
        this.sin_lat_o = Math.sin(d3);
        this.cos_lat_o = Math.cos(d3);
    }
}

