/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.CacheStrategy;
import visad.data.FormNode;
import visad.data.hdfeos.DimensionSet;
import visad.data.hdfeos.EosGrid;
import visad.data.hdfeos.EosStruct;
import visad.data.hdfeos.EosSwath;
import visad.data.hdfeos.GctpMap;
import visad.data.hdfeos.Hdfeos;
import visad.data.hdfeos.HdfeosData;
import visad.data.hdfeos.HdfeosDomain;
import visad.data.hdfeos.HdfeosDomainMap;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.HdfeosField;
import visad.data.hdfeos.HdfeosFile;
import visad.data.hdfeos.HdfeosFlatField;
import visad.data.hdfeos.HdfeosTuple;
import visad.data.hdfeos.NamedDimension;
import visad.data.hdfeos.Shape;
import visad.data.hdfeos.ShapeSet;
import visad.data.hdfeos.Variable;
import visad.data.hdfeos.VariableSet;

public class HdfeosForm
extends Hdfeos {
    static CacheStrategy c_strategy = new CacheStrategy();

    public DataImpl open(String string) throws VisADException, RemoteException {
        DataImpl dataImpl = null;
        HdfeosFile hdfeosFile = new HdfeosFile(string);
        dataImpl = this.getFileData(hdfeosFile);
        return dataImpl;
    }

    public DataImpl open(URL uRL) throws VisADException {
        throw new UnimplementedException("HdfeosForm.open( URL url )");
    }

    public void add(String string, Data data, boolean bl) throws BadFormException {
        throw new BadFormException("HdfeosForm.add");
    }

    public void save(String string, Data data, boolean bl) throws BadFormException, RemoteException, VisADException {
        throw new UnimplementedException("HdfeosForm.save");
    }

    public FormNode getForms(Data data) {
        return this;
    }

    MathType getMathType(HdfeosFile hdfeosFile) throws VisADException, RemoteException {
        MathType mathType = null;
        HdfeosData hdfeosData = null;
        int n = hdfeosFile.getNumberOfStructs();
        if (n == 0) {
            throw new HdfeosException("no HDF-EOS data structures in file: " + hdfeosFile.getFileName());
        }
        MathType[] mathTypeArray = new MathType[n];
        int n2 = 0;
        while (n2 < n) {
            Object var9_9;
            EosStruct eosStruct = hdfeosFile.getStruct(n2);
            if (eosStruct instanceof EosGrid) {
                hdfeosData = this.getGridData((EosGrid)eosStruct);
            } else if (eosStruct instanceof EosSwath) {
                hdfeosData = this.getSwathData((EosSwath)eosStruct);
            }
            try {
                try {
                    mathType = hdfeosData.getType();
                }
                catch (VisADException visADException) {
                    System.out.println(visADException.getMessage());
                    var9_9 = null;
                    mathTypeArray[n2] = mathType;
                }
                var9_9 = null;
                mathTypeArray[n2] = mathType;
            }
            catch (Throwable throwable) {
                var9_9 = null;
                mathTypeArray[n2] = mathType;
                throw throwable;
            }
            ++n2;
        }
        TupleType tupleType = new TupleType(mathTypeArray);
        return tupleType;
    }

    DataImpl getFileData(HdfeosFile hdfeosFile) throws VisADException, RemoteException {
        Object var2_2 = null;
        HdfeosData hdfeosData = null;
        int n = hdfeosFile.getNumberOfStructs();
        if (n == 0) {
            throw new HdfeosException("no EOS data structures in file: " + hdfeosFile.getFileName());
        }
        HdfeosData[] hdfeosDataArray = new HdfeosData[n];
        int n2 = 0;
        while (n2 < n) {
            EosStruct eosStruct = hdfeosFile.getStruct(n2);
            if (eosStruct instanceof EosGrid) {
                hdfeosData = this.getGridData((EosGrid)eosStruct);
            } else if (eosStruct instanceof EosSwath) {
                hdfeosData = this.getSwathData((EosSwath)eosStruct);
            }
            hdfeosDataArray[n2] = hdfeosData;
            ++n2;
        }
        return this.assembleStructs(hdfeosDataArray);
    }

    private DataImpl assembleStructs(HdfeosData[] hdfeosDataArray) throws VisADException, RemoteException {
        DataImpl dataImpl = null;
        int n = hdfeosDataArray.length;
        if (n == 1) {
            return this.getVisADDataObject(hdfeosDataArray[0]);
        }
        boolean bl = true;
        MathType[] mathTypeArray = new MathType[n];
        Data[] dataArray = new DataImpl[n];
        dataArray[0] = this.getVisADDataObject(hdfeosDataArray[0]);
        mathTypeArray[0] = dataArray[0].getType();
        MathType mathType = mathTypeArray[0];
        int n2 = 1;
        while (n2 < n) {
            dataArray[n2] = this.getVisADDataObject(hdfeosDataArray[n2]);
            mathTypeArray[n2] = ((DataImpl)dataArray[n2]).getType();
            if (!mathTypeArray[n2].equals(mathType)) {
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            RealType realType = new RealType("struct_id", null, null);
            Integer1DSet integer1DSet = new Integer1DSet((MathType)realType, n);
            FieldImpl fieldImpl = new FieldImpl(new FunctionType(realType, mathType), integer1DSet);
            int n3 = 0;
            while (n3 < n) {
                fieldImpl.setSample(n3, dataArray[n3]);
                ++n3;
            }
            dataImpl = fieldImpl;
        } else {
            TupleType tupleType = new TupleType(mathTypeArray);
            dataImpl = new Tuple(tupleType, dataArray, false);
        }
        return dataImpl;
    }

    DataImpl getVisADDataObject(HdfeosData hdfeosData) throws VisADException, RemoteException {
        return hdfeosData.getData();
    }

    HdfeosData getGridData(EosGrid eosGrid) throws HdfeosException, VisADException, RemoteException {
        int n;
        HdfeosData[] hdfeosDataArray;
        Vector<HdfeosData> vector = new Vector<HdfeosData>();
        ShapeSet shapeSet = eosGrid.getShapeSet();
        GctpMap gctpMap = eosGrid.getMap();
        VariableSet variableSet = shapeSet.get1DVariables();
        Enumeration enumeration = shapeSet.getEnum();
        while (enumeration.hasMoreElements()) {
            HdfeosFlatField hdfeosFlatField;
            Shape shape = (Shape)enumeration.nextElement();
            DimensionSet dimensionSet = shape.getShape();
            int n2 = dimensionSet.getSize();
            hdfeosDataArray = shape.getVariables();
            DimensionSet dimensionSet2 = new DimensionSet();
            DimensionSet dimensionSet3 = new DimensionSet();
            n = 0;
            while (n < n2) {
                NamedDimension namedDimension = dimensionSet.getElement(n);
                if (namedDimension.getName().equals("XDim") || namedDimension.getName().equals("YDim")) {
                    dimensionSet2.add(namedDimension);
                } else {
                    dimensionSet3.add(namedDimension);
                }
                ++n;
            }
            if (dimensionSet2.getSize() != 2) {
                HdfeosDomain hdfeosDomain = new HdfeosDomain((EosStruct)eosGrid, dimensionSet);
                hdfeosFlatField = new HdfeosFlatField(hdfeosDomain, (VariableSet)hdfeosDataArray);
                vector.addElement(hdfeosFlatField);
                continue;
            }
            HdfeosDomainMap hdfeosDomainMap = new HdfeosDomainMap((EosStruct)eosGrid, dimensionSet2, gctpMap);
            hdfeosFlatField = new HdfeosFlatField((HdfeosDomain)hdfeosDomainMap, (VariableSet)hdfeosDataArray);
            if (dimensionSet3.getSize() == 0) {
                vector.addElement(hdfeosFlatField);
                continue;
            }
            HdfeosField hdfeosField = this.makeField(eosGrid, dimensionSet3, hdfeosFlatField);
            vector.addElement(hdfeosField);
        }
        int n3 = vector.size();
        if (n3 == 0) {
            return null;
        }
        if (n3 == 1) {
            return (HdfeosData)vector.elementAt(0);
        }
        hdfeosDataArray = new HdfeosData[n3];
        n = 0;
        while (n < n3) {
            hdfeosDataArray[n] = (HdfeosData)vector.elementAt(n);
            ++n;
        }
        return new HdfeosTuple(hdfeosDataArray);
    }

    HdfeosData getSwathData(EosSwath eosSwath) throws VisADException, RemoteException, HdfeosException {
        Shape shape;
        DimensionSet dimensionSet = null;
        DimensionSet dimensionSet2 = null;
        Variable variable = null;
        Variable variable2 = null;
        Variable variable3 = null;
        HdfeosDomain hdfeosDomain = null;
        HdfeosDomain hdfeosDomain2 = null;
        HdfeosFlatField hdfeosFlatField = null;
        HdfeosField hdfeosField = null;
        ShapeSet shapeSet = eosSwath.getDV_shapeSet();
        ShapeSet shapeSet2 = eosSwath.getGV_shapeSet();
        Vector<HdfeosData> vector = new Vector<HdfeosData>();
        Variable[] variableArray = shapeSet2.getEnum();
        while (variableArray.hasMoreElements()) {
            shape = (Shape)variableArray.nextElement();
            VariableSet variableSet = shape.getVariables();
            Variable variable4 = variableSet.getByName("Latitude");
            if (variable4 != null) {
                variable = variable4;
            }
            if ((variable4 = variableSet.getByName("Longitude")) != null) {
                variable2 = variable4;
            }
            variable4 = variableSet.getByName("Time");
            if (variable3 == null) continue;
            variable3 = variable4;
        }
        if (variable == null || variable2 == null) {
            hdfeosDomain2 = null;
        } else {
            variableArray = new Variable[]{variable2, variable};
            dimensionSet2 = variable2.getDimSet();
            if (variable.getDimSet().sameSetSameOrder(dimensionSet2)) {
                int n = variable.getDimSet().getSize();
                if (n == 1) {
                    hdfeosDomain2 = null;
                    hdfeosDomain = new HdfeosDomain((EosStruct)eosSwath, dimensionSet2);
                    hdfeosFlatField = new HdfeosFlatField(hdfeosDomain, variableArray);
                    vector.addElement(hdfeosFlatField);
                } else if (n == 2) {
                    hdfeosDomain2 = new HdfeosDomain((EosStruct)eosSwath, variableArray, dimensionSet2.getElements());
                } else if (n > 2) {
                    hdfeosDomain2 = null;
                    hdfeosDomain = new HdfeosDomain((EosStruct)eosSwath, dimensionSet2);
                    hdfeosFlatField = new HdfeosFlatField(hdfeosDomain, variableArray);
                    vector.addElement(hdfeosFlatField);
                }
            } else {
                hdfeosDomain2 = null;
                hdfeosDomain = new HdfeosDomain((EosStruct)eosSwath, variable.getDimSet());
                hdfeosFlatField = new HdfeosFlatField(hdfeosDomain, variable);
                vector.addElement(hdfeosFlatField);
                hdfeosDomain = new HdfeosDomain((EosStruct)eosSwath, variable2.getDimSet());
                hdfeosFlatField = new HdfeosFlatField(hdfeosDomain, variable2);
                vector.addElement(hdfeosFlatField);
            }
        }
        if (variable3 != null) {
            hdfeosDomain = new HdfeosDomain((EosStruct)eosSwath, variable3.getDimSet());
            hdfeosFlatField = new HdfeosFlatField(hdfeosDomain, variable3);
            vector.addElement(hdfeosFlatField);
        }
        variableArray = shapeSet.getEnum();
        while (variableArray.hasMoreElements()) {
            shape = (Shape)variableArray.nextElement();
            DimensionSet dimensionSet3 = shape.getShape();
            int n = dimensionSet3.getSize();
            VariableSet variableSet = shape.getVariables();
            if (hdfeosDomain2 == null) {
                hdfeosDomain = new HdfeosDomain((EosStruct)eosSwath, dimensionSet3);
                hdfeosFlatField = new HdfeosFlatField(hdfeosDomain, variableSet);
                vector.addElement(hdfeosFlatField);
                continue;
            }
            DimensionSet dimensionSet4 = new DimensionSet();
            DimensionSet dimensionSet5 = new DimensionSet();
            int n2 = 0;
            while (n2 < n) {
                NamedDimension namedDimension = dimensionSet3.getElement(n2);
                if (namedDimension.isGeoMapDefined() || shapeSet2.isMemberOf(namedDimension)) {
                    dimensionSet4.add(namedDimension);
                } else {
                    dimensionSet5.add(namedDimension);
                }
                ++n2;
            }
            n2 = dimensionSet4.getSize();
            if (n2 == 0 || n2 == 1) {
                hdfeosDomain = new HdfeosDomain((EosStruct)eosSwath, dimensionSet3);
                hdfeosFlatField = new HdfeosFlatField(hdfeosDomain, variableSet);
                vector.addElement(hdfeosFlatField);
                continue;
            }
            if (n2 == 2) {
                dimensionSet = dimensionSet5;
                HdfeosDomain hdfeosDomain3 = new HdfeosDomain((EosStruct)eosSwath, dimensionSet4, hdfeosDomain2);
                hdfeosFlatField = new HdfeosFlatField(hdfeosDomain3, variableSet);
                if (dimensionSet.getSize() == 0) {
                    vector.add(hdfeosFlatField);
                    continue;
                }
                int n3 = dimensionSet.getSize();
                boolean bl = false;
                int n4 = 0;
                while (n4 < n3) {
                    if (dimensionSet3.getIndexOf(dimensionSet.getElement(n4)) > dimensionSet3.getIndexOf(dimensionSet4.getElement(1))) {
                        bl = true;
                    }
                    ++n4;
                }
                if (bl) {
                    hdfeosDomain = new HdfeosDomain((EosStruct)eosSwath, dimensionSet3);
                    hdfeosFlatField = new HdfeosFlatField(hdfeosDomain, variableSet);
                    vector.addElement(hdfeosFlatField);
                    continue;
                }
                hdfeosField = this.makeField(eosSwath, dimensionSet, hdfeosFlatField);
                vector.add(hdfeosField);
                continue;
            }
            if (n2 < 3) continue;
            hdfeosDomain = new HdfeosDomain((EosStruct)eosSwath, dimensionSet3);
            hdfeosFlatField = new HdfeosFlatField(hdfeosDomain, variableSet);
            vector.addElement(hdfeosFlatField);
        }
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return (HdfeosData)vector.elementAt(0);
        }
        HdfeosData[] hdfeosDataArray = new HdfeosData[n];
        int n5 = 0;
        while (n5 < n) {
            hdfeosDataArray[n5] = (HdfeosData)vector.elementAt(n5);
            ++n5;
        }
        return new HdfeosTuple(hdfeosDataArray);
    }

    HdfeosField makeField(EosStruct eosStruct, DimensionSet dimensionSet, HdfeosData hdfeosData) throws VisADException, RemoteException, HdfeosException {
        HdfeosData hdfeosData2 = hdfeosData;
        HdfeosDomain hdfeosDomain = null;
        HdfeosField hdfeosField = null;
        int n = dimensionSet.getSize() - 1;
        while (n >= 0) {
            hdfeosDomain = new HdfeosDomain(eosStruct, dimensionSet.getElement(n));
            hdfeosField = new HdfeosField(hdfeosDomain, hdfeosData2);
            hdfeosData2 = hdfeosField;
            --n;
        }
        return hdfeosField;
    }

    public HdfeosForm() {
        super("Default");
    }

    HdfeosForm(String string) {
        super(string);
    }
}

