/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import java.rmi.RemoteException;
import visad.DataImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.FileFlatField;
import visad.data.hdfeos.Calibration;
import visad.data.hdfeos.DimensionSet;
import visad.data.hdfeos.EosGrid;
import visad.data.hdfeos.EosStruct;
import visad.data.hdfeos.EosSwath;
import visad.data.hdfeos.HdfeosAccessor;
import visad.data.hdfeos.HdfeosData;
import visad.data.hdfeos.HdfeosDomain;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.HdfeosForm;
import visad.data.hdfeos.NamedDimension;
import visad.data.hdfeos.Variable;
import visad.data.hdfeos.VariableSet;

public class HdfeosFlatField
extends HdfeosData {
    HdfeosDomain domain;
    Variable[] range_s;
    int n_fields;
    int r_rank;
    int d_rank;
    String[] name_s;
    int[] num_type;
    Calibration[] cal;
    FunctionType mathtype;
    EosStruct struct;
    boolean pointStruct = false;
    int[] start = null;
    int[] inv_start = null;
    int[] stride = null;
    int[] inv_stride = null;
    int[] edge = null;
    int[] inv_edge = null;
    DimensionSet rangeDimSet = null;
    DimensionSet domainDimSet = null;
    FlatField data = null;

    private void initialize(HdfeosDomain hdfeosDomain, Variable[] variableArray) throws VisADException, UnimplementedException, HdfeosException {
        this.domain = hdfeosDomain;
        this.struct = hdfeosDomain.getStruct();
        this.n_fields = variableArray.length;
        this.name_s = new String[this.n_fields];
        this.num_type = new int[this.n_fields];
        this.cal = new Calibration[this.n_fields];
        int n = 0;
        while (n < this.n_fields) {
            this.name_s[n] = variableArray[n].getName();
            this.num_type[n] = variableArray[n].getNumberType();
            this.cal[n] = variableArray[n].getCalibration();
            ++n;
        }
        this.mathtype = this.makeType();
        if (this.struct instanceof EosSwath || this.struct instanceof EosGrid) {
            this.rangeDimSet = variableArray[0].getDimSet();
            this.r_rank = this.rangeDimSet.getSize();
            this.domainDimSet = hdfeosDomain.getDimSet();
            this.d_rank = this.domainDimSet.getSize();
            if (this.d_rank > this.r_rank) {
                throw new HdfeosException("d_rank > r_rank");
            }
            this.start = new int[this.r_rank];
            this.inv_start = new int[this.r_rank];
            this.edge = new int[this.r_rank];
            this.inv_edge = new int[this.r_rank];
            this.stride = new int[this.r_rank];
            this.inv_stride = new int[this.r_rank];
            n = 0;
            while (n < this.r_rank) {
                NamedDimension namedDimension = this.rangeDimSet.getElement(n);
                this.start[n] = 0;
                this.edge[n] = namedDimension.getLength();
                this.stride[n] = 1;
                ++n;
            }
        } else {
            this.pointStruct = true;
            throw new UnimplementedException("ECS structmetadata: POINT");
        }
    }

    public MathType getType() throws VisADException {
        return this.mathtype;
    }

    public DataImpl getData() throws VisADException, RemoteException {
        return this.getData(null);
    }

    public DataImpl getAdaptedData() throws VisADException, RemoteException {
        HdfeosAccessor hdfeosAccessor = new HdfeosAccessor(this, null);
        FileFlatField fileFlatField = new FileFlatField(hdfeosAccessor, HdfeosForm.c_strategy);
        return fileFlatField;
    }

    public DataImpl getData(int[] nArray) throws VisADException, RemoteException {
        Set set = null;
        if (!this.pointStruct) {
            int n;
            int n2;
            if (nArray == null) {
                if (this.data != null) {
                    return this.data;
                }
                set = this.domain.getData();
            } else {
                if (this.d_rank == this.r_rank) {
                    set = this.domain.getData(nArray);
                } else if (this.d_rank < this.r_rank) {
                    set = this.domain.getData();
                }
                n2 = 0;
                n = 0;
                while (n < nArray.length) {
                    this.start[n2] = nArray[n];
                    this.edge[n2] = 1;
                    ++n2;
                    ++n;
                }
            }
            if (this.struct instanceof EosSwath) {
                n2 = 0;
                while (n2 < this.r_rank) {
                    this.inv_start[n2] = this.start[this.r_rank - 1 - n2];
                    this.inv_edge[n2] = this.edge[this.r_rank - 1 - n2];
                    this.inv_stride[n2] = this.stride[this.r_rank - 1 - n2];
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < this.r_rank) {
                    this.inv_start[n2] = this.start[n2];
                    this.inv_edge[n2] = this.edge[n2];
                    this.inv_stride[n2] = this.stride[n2];
                    ++n2;
                }
            }
            FlatField flatField = new FlatField(this.mathtype, set);
            n = set.getLength();
            float[][] fArray = new float[this.n_fields][n];
            int n3 = 0;
            while (n3 < this.n_fields) {
                this.struct.readData(this.name_s[n3], this.inv_start, this.inv_stride, this.inv_edge, this.num_type[n3], this.cal[n3], fArray[n3]);
                ++n3;
            }
            flatField.setSamples(fArray);
            this.data = flatField;
            return this.data;
        }
        return null;
    }

    public DataImpl getAdaptedData(int[] nArray) throws VisADException {
        HdfeosAccessor hdfeosAccessor = new HdfeosAccessor(this, nArray);
        FileFlatField fileFlatField = new FileFlatField(hdfeosAccessor, HdfeosForm.c_strategy);
        return fileFlatField;
    }

    private FunctionType makeType() throws VisADException {
        MathType mathType = this.domain.getType();
        RealType[] realTypeArray = new RealType[this.n_fields];
        int n = 0;
        while (n < this.n_fields) {
            realTypeArray[n] = RealType.getRealType(this.name_s[n], null, null);
            ++n;
        }
        MathType mathType2 = this.n_fields == 1 ? realTypeArray[0] : new RealTupleType(realTypeArray);
        FunctionType functionType = new FunctionType(mathType, mathType2);
        return functionType;
    }

    public HdfeosFlatField(HdfeosDomain hdfeosDomain, Variable[] variableArray) throws VisADException, UnimplementedException, HdfeosException {
        this.initialize(hdfeosDomain, variableArray);
    }

    public HdfeosFlatField(HdfeosDomain hdfeosDomain, Variable variable) throws VisADException, UnimplementedException, HdfeosException {
        Variable[] variableArray = new Variable[]{variable};
        this.initialize(hdfeosDomain, variableArray);
    }

    public HdfeosFlatField(HdfeosDomain hdfeosDomain, VariableSet variableSet) throws VisADException, UnimplementedException, HdfeosException {
        this.initialize(hdfeosDomain, variableSet.getElements());
    }
}

