/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.CoordinateSystem;
import visad.GridCoordinateSystem;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.IntegerNDSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.ProductSet;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.Calibration;
import visad.data.hdfeos.DimensionSet;
import visad.data.hdfeos.EosStruct;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.NamedDimension;
import visad.data.hdfeos.Variable;
import visad.data.hdfeos.VariableSet;

class HdfeosDomain {
    static final int INTEGER = 0;
    static final int HYBRID = 1;
    static final int FACTORED = 2;
    static final int FACTORED_ARITH = 3;
    static final int UNFACTORED = 4;
    static final int LINEAR = 5;
    static final int SINGLE = 6;
    private EosStruct struct;
    private int op;
    private NamedDimension[] domDims;
    private DimensionSet domDimSet = null;
    private Variable[] domVars;
    private int domainDim;
    private int manifoldDim;
    private int[] lengths = null;
    private int[] inv_lengths = null;
    private int[] num_type = null;
    private Calibration[] cal = null;
    private int n_samples;
    private float[][] samples;
    private String[] name_s = null;
    MathType mathtype = null;
    private CoordinateSystem coord_sys = null;
    private Unit[] units = null;
    private Set domainSet = null;
    private HdfeosDomain gridCoordSys = null;
    private boolean subRank;
    private int[] start = null;
    private int[] edge = null;
    private int[] stride = null;

    public static GridCoordinateSystem getNullGridCoordinateSystem(HdfeosDomain hdfeosDomain) throws VisADException {
        RealTupleType realTupleType = (RealTupleType)hdfeosDomain.getType();
        int n = realTupleType.getDimension();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 2;
            ++n2;
        }
        IntegerNDSet integerNDSet = new IntegerNDSet((MathType)realTupleType, nArray);
        GridCoordinateSystem gridCoordinateSystem = new GridCoordinateSystem(integerNDSet);
        return gridCoordinateSystem;
    }

    private void initializeNoVars(EosStruct eosStruct, NamedDimension[] namedDimensionArray) throws VisADException {
        this.struct = eosStruct;
        this.domDims = namedDimensionArray;
        this.domainDim = namedDimensionArray.length;
        this.lengths = new int[this.domainDim];
        this.inv_lengths = new int[this.domainDim];
        this.manifoldDim = this.domainDim;
        this.name_s = new String[this.domainDim];
        this.domDimSet = new DimensionSet(namedDimensionArray);
        if (this.units == null) {
            this.units = new Unit[this.domainDim];
        }
        this.start = new int[this.manifoldDim];
        this.stride = new int[this.manifoldDim];
        this.edge = new int[this.manifoldDim];
        this.n_samples = 1;
        int n = 0;
        while (n < this.domainDim) {
            this.name_s[n] = this.domDims[n].getName();
            this.lengths[n] = this.domDims[n].getLength();
            this.n_samples *= this.lengths[n];
            this.start[n] = 0;
            this.edge[n] = this.lengths[n];
            this.stride[n] = 1;
            ++n;
        }
        n = 0;
        while (n < this.domainDim) {
            this.inv_lengths[n] = this.lengths[this.domainDim - 1 - n];
            ++n;
        }
        this.op = 5;
        this.subRank = false;
        this.mathtype = this.makeType(null);
    }

    private void initialize(EosStruct eosStruct, Variable[] variableArray, NamedDimension[] namedDimensionArray) throws VisADException {
        int n;
        this.struct = eosStruct;
        this.domVars = variableArray;
        int n2 = variableArray.length;
        this.num_type = new int[n2];
        this.cal = new Calibration[n2];
        this.domDims = namedDimensionArray;
        int n3 = namedDimensionArray.length;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        this.domainDim = variableArray.length;
        this.manifoldDim = namedDimensionArray.length;
        if (this.domDimSet == null) {
            this.domDimSet = new DimensionSet(namedDimensionArray);
        }
        this.name_s = new String[this.domainDim];
        if (this.units == null) {
            this.units = new Unit[this.domainDim];
        }
        if (this.domainDim == 1) {
            this.op = 6;
            this.subRank = false;
            this.start = new int[1];
            this.edge = new int[1];
            this.stride = new int[1];
            this.name_s[0] = this.domVars[0].getName();
            this.num_type[0] = this.domVars[0].getNumberType();
            this.cal[0] = this.domVars[0].getCalibration();
        } else {
            n = 1;
            int n4 = this.domVars[0].getRank();
            int n5 = 0;
            while (n5 < n2) {
                n = this.domVars[n5].getRank();
                if (n3 != 1) {
                    bl = false;
                    if (n != n4) {
                        bl3 = false;
                    }
                } else {
                    bl2 = true;
                }
                this.name_s[n5] = this.domVars[n5].getName();
                this.num_type[n5] = this.domVars[n5].getNumberType();
                this.cal[n5] = this.domVars[n5].getCalibration();
                ++n5;
            }
            if (bl) {
                this.op = 2;
                this.subRank = false;
                this.start = new int[1];
                this.edge = new int[1];
                this.stride = new int[1];
            } else if (bl3) {
                if (n > this.manifoldDim) {
                    this.subRank = true;
                } else if (n == this.manifoldDim) {
                    this.subRank = false;
                } else {
                    throw new HdfeosException("variables rank cannot be greater than manifoldDim");
                }
                this.op = 4;
                this.start = new int[n];
                this.stride = new int[n];
                this.edge = new int[n];
            } else {
                throw new HdfeosException("undefined domain case");
            }
        }
        this.lengths = new int[this.manifoldDim];
        this.inv_lengths = new int[this.manifoldDim];
        this.n_samples = 1;
        n = 0;
        while (n < this.manifoldDim) {
            this.lengths[n] = this.domDims[n].getLength();
            this.n_samples *= this.lengths[n];
            ++n;
        }
        n = 0;
        while (n < this.manifoldDim) {
            this.inv_lengths[n] = this.lengths[this.manifoldDim - 1 - n];
            ++n;
        }
        this.samples = new float[this.domainDim][this.n_samples];
        this.mathtype = this.makeType(null);
    }

    public DimensionSet getDimSet() {
        return this.domDimSet;
    }

    MathType makeType(CoordinateSystem coordinateSystem) throws VisADException {
        RealType[] realTypeArray = new RealType[this.domainDim];
        int n = 0;
        while (n < this.domainDim) {
            int n2 = this.domainDim - 1 - n;
            realTypeArray[n] = RealType.getRealType(this.name_s[n2], this.units[n2], null);
            ++n;
        }
        if (realTypeArray.length == 1) {
            return realTypeArray[0];
        }
        if (coordinateSystem == null) {
            return new RealTupleType(realTypeArray, this.coord_sys, null);
        }
        return new RealTupleType(realTypeArray, coordinateSystem, null);
    }

    public MathType getType() throws VisADException {
        return this.mathtype;
    }

    public Set getData() throws VisADException {
        if (!this.subRank) {
            return this.getData(null);
        }
        throw new HdfeosException("getData(int[] indexes) must be used");
    }

    public Set getData(int[] nArray) throws VisADException {
        int n = 0;
        if (nArray == null) {
            if (this.subRank) {
                throw new HdfeosException("indexes cannot be null");
            }
            if (this.domainSet != null) {
                return this.domainSet;
            }
        } else {
            if (!this.subRank) {
                throw new HdfeosException("getData() must be used");
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                this.start[n] = nArray[n2];
                this.edge[n] = 1;
                ++n;
                ++n2;
            }
        }
        SampledSet sampledSet = null;
        switch (this.op) {
            case 4: {
                int n3 = 0;
                while (n3 < this.domainDim) {
                    int n4 = 0;
                    while (n4 < this.manifoldDim) {
                        this.start[n + n4] = 0;
                        this.edge[n + n4] = this.lengths[n4];
                        this.stride[n + n4] = 1;
                        ++n4;
                    }
                    this.struct.readData(this.name_s[n3], this.start, this.stride, this.edge, this.num_type[n3], this.cal[n3], this.samples[n3]);
                    ++n3;
                }
                sampledSet = GriddedSet.create(this.mathtype, this.samples, this.inv_lengths);
                break;
            }
            case 6: {
                this.struct.readData(this.name_s[0], this.start, this.stride, this.edge, this.num_type[0], this.cal[0], this.samples[0]);
                sampledSet = new Gridded1DSet(this.mathtype, this.samples, this.lengths[0]);
                break;
            }
            case 5: {
                GriddedSet griddedSet;
                if (this.gridCoordSys == null) {
                    sampledSet = new IntegerNDSet(this.mathtype, this.lengths, null, null, null);
                    break;
                }
                try {
                    griddedSet = (GriddedSet)this.gridCoordSys.getData(nArray);
                }
                catch (SetException setException) {
                    System.out.println(this.gridCoordSys.getType().toString() + " " + setException.getMessage());
                    sampledSet = new IntegerNDSet(this.mathtype, this.lengths, null, null, null);
                    break;
                }
                int[] nArray2 = griddedSet.getLengths();
                double[] dArray = new double[this.domainDim];
                double[] dArray2 = new double[this.domainDim];
                int n5 = 0;
                while (n5 < this.domainDim) {
                    dArray[n5] = 0.0;
                    dArray2[n5] = nArray2[n5];
                    ++n5;
                }
                GridCoordinateSystem gridCoordinateSystem = new GridCoordinateSystem(griddedSet);
                sampledSet = new LinearNDSet(this.mathtype, dArray, dArray2, this.lengths, gridCoordinateSystem, null, null);
                break;
            }
            case 2: {
                SampledSet[] sampledSetArray = new SampledSet[this.domainDim];
                int n6 = 0;
                while (n6 < this.domainDim) {
                    this.start[0] = 0;
                    this.edge[0] = this.lengths[n6];
                    this.stride[0] = 1;
                    this.struct.readData(this.name_s[n6], this.start, this.stride, this.edge, this.num_type[n6], this.cal[n6], this.samples[n6]);
                    sampledSetArray[n6] = new Gridded1DSet(this.mathtype, this.samples, this.lengths[n6]);
                    ++n6;
                }
                sampledSet = new ProductSet(this.mathtype, sampledSetArray);
                break;
            }
        }
        if (!this.subRank) {
            this.domainSet = sampledSet;
        }
        return sampledSet;
    }

    public EosStruct getStruct() {
        return this.struct;
    }

    public HdfeosDomain(EosStruct eosStruct, DimensionSet dimensionSet) throws VisADException {
        this(eosStruct, dimensionSet.getElements(), null, null);
    }

    public HdfeosDomain(EosStruct eosStruct, DimensionSet dimensionSet, CoordinateSystem coordinateSystem) throws VisADException {
        this(eosStruct, dimensionSet.getElements(), coordinateSystem, null);
    }

    public HdfeosDomain(EosStruct eosStruct, DimensionSet dimensionSet, CoordinateSystem coordinateSystem, Unit[] unitArray) throws VisADException {
        this(eosStruct, dimensionSet.getElements(), coordinateSystem, unitArray);
    }

    public HdfeosDomain(EosStruct eosStruct, NamedDimension namedDimension) throws VisADException {
        NamedDimension[] namedDimensionArray = new NamedDimension[]{namedDimension};
        this.initializeNoVars(eosStruct, namedDimensionArray);
    }

    public HdfeosDomain(EosStruct eosStruct, NamedDimension[] namedDimensionArray, CoordinateSystem coordinateSystem, Unit[] unitArray) throws VisADException {
        this.coord_sys = coordinateSystem;
        this.units = unitArray;
        this.initializeNoVars(eosStruct, namedDimensionArray);
    }

    public HdfeosDomain(EosStruct eosStruct, DimensionSet dimensionSet, HdfeosDomain hdfeosDomain) throws VisADException {
        this.coord_sys = HdfeosDomain.getNullGridCoordinateSystem(hdfeosDomain);
        this.gridCoordSys = hdfeosDomain;
        this.initializeNoVars(eosStruct, dimensionSet.getElements());
    }

    public HdfeosDomain(EosStruct eosStruct, Variable[] variableArray, NamedDimension[] namedDimensionArray) throws VisADException {
        this.initialize(eosStruct, variableArray, namedDimensionArray);
    }

    public HdfeosDomain(EosStruct eosStruct, VariableSet variableSet, DimensionSet dimensionSet) throws VisADException {
        this.domDimSet = dimensionSet;
        this.initialize(eosStruct, variableSet.getElements(), dimensionSet.getElements());
    }

    public HdfeosDomain(EosStruct eosStruct, Variable variable) throws VisADException {
        Variable[] variableArray = new Variable[1];
        NamedDimension[] namedDimensionArray = new NamedDimension[1];
        variableArray[0] = variable;
        namedDimensionArray[0] = variable.getDim(0);
        this.initialize(eosStruct, variableArray, namedDimensionArray);
    }
}

