/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Linear2DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.GctpFunction;
import visad.data.hdfeos.LambertAzimuthalEqualArea;
import visad.data.hdfeos.LambertConformalConic;
import visad.data.hdfeos.PolarStereographic;

public class GctpMap {
    double[] projparms;
    public int projcode;
    Unit[] setUnits = null;
    int zonecode;
    int sphrcode;
    int xdimsize;
    int ydimsize;
    double[] uprLeft;
    double[] lwrRight;

    public CoordinateSystem getVisADCoordinateSystem() throws VisADException {
        CoordinateSystem coordinateSystem = null;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        double d = this.projparms[6];
        double d2 = this.projparms[7];
        RealType realType = RealType.Latitude;
        RealType realType2 = RealType.Longitude;
        RealType[] realTypeArray = new RealType[]{realType2, realType};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        GctpFunction.sphdz(this.sphrcode, this.projparms, dArray, dArray2, dArray3);
        switch (this.projcode) {
            case 11: {
                int n = GctpFunction.paksz(this.projparms[4], dArray4);
                if (n != 0) {
                    // empty if block
                }
                if ((n = GctpFunction.paksz(this.projparms[5], dArray5)) != 0) {
                    // empty if block
                }
                coordinateSystem = new LambertAzimuthalEqualArea(realTupleType, dArray3[0], dArray4[0], dArray5[0], d, d2);
                break;
            }
            case 6: {
                int n = GctpFunction.paksz(this.projparms[4], dArray4);
                if (n != 0) {
                    // empty if block
                }
                if ((n = GctpFunction.paksz(this.projparms[5], dArray6)) != 0) {
                    // empty if block
                }
                coordinateSystem = new PolarStereographic(realTupleType, dArray[0], dArray2[0], dArray4[0], dArray6[0], d, d2);
                break;
            }
            case 4: {
                coordinateSystem = new LambertConformalConic(realTupleType, dArray[0], dArray2[0], dArray6[0], dArray7[0], dArray4[0], dArray5[0], d, d2);
                break;
            }
            case 0: {
                this.uprLeft[0] = this.uprLeft[0] * 1.0E-6;
                this.lwrRight[0] = this.lwrRight[0] * 1.0E-6;
                this.uprLeft[1] = this.uprLeft[1] * 1.0E-6;
                this.lwrRight[1] = this.lwrRight[1] * 1.0E-6;
                this.setUnits = new Unit[2];
                this.setUnits[0] = CommonUnit.degree;
                this.setUnits[1] = CommonUnit.degree;
            }
        }
        return coordinateSystem;
    }

    public Unit[] getUnits() {
        return this.setUnits;
    }

    public Set getVisADSet(MathType mathType) throws VisADException {
        int n = this.xdimsize;
        int n2 = this.ydimsize;
        Linear2DSet linear2DSet = this.projcode == 0 ? new LinearLatLonSet(mathType, this.uprLeft[0], this.lwrRight[0], n, this.lwrRight[1], this.uprLeft[1], n2) : new Linear2DSet(mathType, this.uprLeft[0], this.lwrRight[0], n, this.lwrRight[1], this.uprLeft[1], n2);
        return linear2DSet;
    }

    public GctpMap(int n, int n2, int n3, int n4, int n5, double[] dArray, double[] dArray2, double[] dArray3) {
        this.projcode = n;
        this.projparms = dArray;
        this.zonecode = n2;
        this.sphrcode = n3;
        this.xdimsize = n4;
        this.ydimsize = n5;
        this.uprLeft = dArray2;
        this.lwrRight = dArray3;
    }
}

