/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.data.hdfeos.Calibration;
import visad.data.hdfeos.EosGrid;
import visad.data.hdfeos.EosSwath;
import visad.data.hdfeos.HdfeosException;
import visad.data.hdfeos.hdfeosc.HdfeosLib;

public abstract class EosStruct {
    static String G_TYPE = "Geolocation Fields";
    static String D_TYPE = "Data Fields";
    int struct_id;

    public int getStructId() {
        return this.struct_id;
    }

    public void readData(String string, int[] nArray, int[] nArray2, int[] nArray3, int n, Calibration calibration, float[] fArray) throws HdfeosException {
        int n2 = 0;
        int n3 = fArray.length;
        if (n == 5) {
            if (this instanceof EosGrid) {
                n2 = HdfeosLib.GDreadfield(this.struct_id, string, nArray, nArray2, nArray3, fArray);
            } else if (this instanceof EosSwath) {
                n2 = HdfeosLib.SWreadfield(this.struct_id, string, nArray, nArray2, nArray3, fArray);
            }
        } else if (n == 6) {
            double[] dArray = new double[n3];
            if (this instanceof EosGrid) {
                n2 = HdfeosLib.GDreadfield(this.struct_id, string, nArray, nArray2, nArray3, dArray);
            } else if (this instanceof EosSwath) {
                n2 = HdfeosLib.SWreadfield(this.struct_id, string, nArray, nArray2, nArray3, dArray);
            }
            int n4 = 0;
            while (n4 < n3) {
                fArray[n4] = (float)dArray[n4];
                ++n4;
            }
            dArray = null;
        } else if (n == 24) {
            int[] nArray4 = new int[n3];
            if (this instanceof EosGrid) {
                n2 = HdfeosLib.GDreadfield(this.struct_id, string, nArray, nArray2, nArray3, nArray4);
            } else if (this instanceof EosSwath) {
                n2 = HdfeosLib.SWreadfield(this.struct_id, string, nArray, nArray2, nArray3, nArray4);
            }
            int n5 = 0;
            while (n5 < n3) {
                fArray[n5] = nArray4[n5];
                ++n5;
            }
            nArray4 = null;
        } else if (n == 22 || n == 23) {
            short[] sArray = new short[n3];
            if (this instanceof EosGrid) {
                n2 = HdfeosLib.GDreadfield(this.struct_id, string, nArray, nArray2, nArray3, sArray);
            } else if (this instanceof EosSwath) {
                n2 = HdfeosLib.SWreadfield(this.struct_id, string, nArray, nArray2, nArray3, sArray);
            }
            if (calibration != null) {
                calibration.fromCalibration(sArray, fArray);
            } else {
                int n6 = 0;
                while (n6 < n3) {
                    fArray[n6] = sArray[n6];
                    ++n6;
                }
            }
            sArray = null;
        } else if (n == 20 || n == 21) {
            byte[] byArray = new byte[n3];
            if (this instanceof EosGrid) {
                n2 = HdfeosLib.GDreadfield(this.struct_id, string, nArray, nArray2, nArray3, byArray);
            } else if (this instanceof EosSwath) {
                n2 = HdfeosLib.SWreadfield(this.struct_id, string, nArray, nArray2, nArray3, byArray);
            }
            if (calibration != null) {
                calibration.fromCalibration(byArray, fArray);
            } else {
                int n7 = 0;
                while (n7 < n3) {
                    fArray[n7] = byArray[n7];
                    ++n7;
                }
            }
            byArray = null;
        } else {
            throw new HdfeosException(" number type not implemented: " + n);
        }
    }
}

