/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.data.hdfeos.Calibration;

class CalibrationDefault
extends Calibration {
    private static String scaleFactorName = "scale_factor";
    private static String offsetName = "add_offset";
    private static String fillValueName = "_FillValue";
    private static String validRange = "valid_range";
    private static String[] names = new String[4];
    double scale_factor;
    double offset;
    double fillvalue;
    double v_range_low;
    double v_range_high;

    public static String[] getNames() {
        return names;
    }

    public void fromCalibration(short[] sArray, double[] dArray) {
        int n = 0;
        while (n < sArray.length) {
            double d = sArray[n];
            d = d == this.fillvalue ? Double.NaN : (d < this.v_range_low && d > this.v_range_high ? Double.NaN : ((double)sArray[n] - this.offset) * this.scale_factor);
            dArray[n] = d;
            ++n;
        }
    }

    public void fromCalibration(short[] sArray, float[] fArray) {
        float f = (float)this.offset;
        float f2 = (float)this.scale_factor;
        float f3 = (float)this.v_range_low;
        float f4 = (float)this.v_range_high;
        int n = 0;
        while (n < sArray.length) {
            float f5 = sArray[n];
            f5 = f5 == (float)this.fillvalue ? Float.NaN : (f5 < f3 && f5 > f4 ? Float.NaN : ((float)sArray[n] - f) * f2);
            fArray[n] = f5;
            ++n;
        }
    }

    public void fromCalibration(byte[] byArray, float[] fArray) {
        float f = (float)this.offset;
        float f2 = (float)this.scale_factor;
        float f3 = (float)this.v_range_low;
        float f4 = (float)this.v_range_high;
        int n = 0;
        while (n < byArray.length) {
            float f5 = byArray[n];
            f5 = f5 == (float)this.fillvalue ? Float.NaN : (f5 < f3 && f5 > f4 ? Float.NaN : ((float)byArray[n] - f) * f2);
            fArray[n] = f5;
            ++n;
        }
    }

    CalibrationDefault(double[][] dArray) {
        this.scale_factor = dArray[0][0];
        this.offset = dArray[1][0];
        this.fillvalue = dArray[2][0];
        if (dArray[3][0] < dArray[3][1]) {
            this.v_range_low = dArray[3][0];
            this.v_range_high = dArray[3][1];
        } else {
            this.v_range_low = dArray[3][1];
            this.v_range_high = dArray[3][0];
        }
    }

    static {
        CalibrationDefault.names[0] = scaleFactorName;
        CalibrationDefault.names[1] = offsetName;
        CalibrationDefault.names[2] = fillValueName;
        CalibrationDefault.names[3] = validRange;
    }
}

