/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Group
extends HDF5Object {
    protected Vector members;
    protected HDF5Group parent;

    public void setParent(HDF5Group hDF5Group) {
        this.parent = hDF5Group;
    }

    public boolean contains(Object object) {
        return this.members.contains(object);
    }

    public void addMember(Object object) {
        if (!this.contains(object)) {
            this.members.addElement(object);
        }
    }

    public void removeMemberAt(int n) {
        this.members.removeElementAt(n);
    }

    public boolean removeMember(Object object) {
        return this.members.removeElement(object);
    }

    public Vector getMembers() {
        return this.members;
    }

    public HDF5Group getParent() {
        return this.parent;
    }

    public Object getMemberAt(int n) {
        return this.members.elementAt(n);
    }

    public int getMemberCount() {
        if (this.members == null) {
            return -1;
        }
        return this.members.size();
    }

    public boolean isEmpty() {
        return this.members == null || this.members.size() <= 0;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public synchronized String toString() {
        return this.getClass().getName() + "[name=" + this.name + ",members=" + this.members.toString() + "]";
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            Object var2_1 = null;
            H5.H5Gclose(this.id);
        }
    }

    public HDF5Group() {
        this.type = 1;
        this.members = new Vector();
    }

    public HDF5Group(int n, String string, int n2) {
        super(string);
        this.type = 1;
        this.members = new Vector();
        if (n2 <= 0) {
            n2 = string.length();
        }
        try {
            this.id = H5.H5Gcreate(n, this.name, n2);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Group: " + hDF5Exception);
            this.id = -1;
        }
    }

    public HDF5Group(int n, String string) {
        super(string);
        this.type = 1;
        this.members = new Vector();
        try {
            this.id = H5.H5Gopen(n, string);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Group: " + hDF5Exception);
            this.id = -1;
        }
    }
}

