/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import java.io.File;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.data.hdf5.hdf5objects.HDF5Dataset;
import visad.data.hdf5.hdf5objects.HDF5Datatype;
import visad.data.hdf5.hdf5objects.HDF5Group;
import visad.data.hdf5.hdf5objects.HDF5Object;
import visad.data.hdf5.hdf5objects.HDF5TreeNode;

public class HDF5File
extends HDF5Object {
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            Object var2_1 = null;
            H5.H5Fclose(this.id);
        }
    }

    public HDF5TreeNode loadTree() {
        int n;
        HDF5TreeNode hDF5TreeNode = null;
        try {
            n = H5.H5Fopen(this.name, 1, -2);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("H5Fopen failed " + hDF5Exception);
            return hDF5TreeNode;
        }
        HDF5Group hDF5Group = new HDF5Group(n, "/");
        hDF5Group.setShortName(new File(this.name).getName());
        hDF5TreeNode = new HDF5TreeNode(hDF5Group);
        this.depth_first(n, "/", hDF5TreeNode);
        try {
            int n2 = H5.H5Fclose(n);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("H5Fopen failed " + hDF5Exception);
            return hDF5TreeNode;
        }
        return hDF5TreeNode;
    }

    private boolean depth_first(int n, String string, HDF5TreeNode hDF5TreeNode) {
        int n2 = 0;
        int[] nArray = new int[1];
        String[] stringArray = new String[]{new String(" ")};
        HDF5Group hDF5Group = (HDF5Group)hDF5TreeNode.getUserObject();
        String string2 = hDF5Group.getName();
        if (string2.length() > 1) {
            string2 = string2 + "/";
        }
        n2 = 0;
        try {
            n2 = H5.H5Gn_members(n, string);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5File.depth_first(): H5Gn_members() Failed, " + hDF5Exception);
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            try {
                n4 = H5.H5Gget_obj_info_idx(n, string, n3, stringArray, nArray);
            }
            catch (HDF5Exception hDF5Exception) {
                System.err.println("HDF5File.depth_first(): H5Gn_members() Failed, " + hDF5Exception);
                return false;
            }
            if (n4 >= 0) {
                switch (nArray[0]) {
                    case 1: {
                        HDF5Group hDF5Group2 = new HDF5Group(n, string2 + stringArray[0]);
                        hDF5Group2.setParent(hDF5Group);
                        hDF5Group.addMember(hDF5Group2);
                        HDF5TreeNode hDF5TreeNode2 = new HDF5TreeNode(hDF5Group2);
                        hDF5TreeNode.add(hDF5TreeNode2);
                        int n5 = -1;
                        try {
                            n5 = H5.H5Gopen(n, string);
                        }
                        catch (HDF5Exception hDF5Exception) {
                            System.err.println("HDF5File.depth_first(): H5Gopen() Failed, " + hDF5Exception);
                            break;
                        }
                        this.depth_first(n5, stringArray[0], hDF5TreeNode2);
                        break;
                    }
                    case 2: {
                        HDF5Dataset hDF5Dataset = new HDF5Dataset(n, string2 + stringArray[0]);
                        hDF5Group.addMember(hDF5Dataset);
                        HDF5TreeNode hDF5TreeNode2 = new HDF5TreeNode(hDF5Dataset);
                        hDF5TreeNode.add(hDF5TreeNode2);
                        break;
                    }
                    case 3: {
                        HDF5Datatype hDF5Datatype = new HDF5Datatype(n, string2 + stringArray[0]);
                        hDF5Group.addMember(hDF5Datatype);
                        HDF5TreeNode hDF5TreeNode2 = new HDF5TreeNode(hDF5Datatype);
                        hDF5TreeNode.add(hDF5TreeNode2);
                        break;
                    }
                    default: {
                        HDF5Object hDF5Object = new HDF5Object(string2 + stringArray[0]);
                        hDF5Group.addMember(hDF5Object);
                        HDF5TreeNode hDF5TreeNode2 = new HDF5TreeNode(hDF5Object);
                        hDF5TreeNode.add(hDF5TreeNode2);
                        break;
                    }
                }
                stringArray[0] = null;
                nArray[0] = -1;
            }
            ++n3;
        }
        return true;
    }

    public HDF5File(String string, int n, int n2, int n3) throws HDF5Exception {
        super(string);
        this.type = 6;
        try {
            this.id = H5.H5Fcreate(string, n, n2, n3);
        }
        catch (HDF5Exception hDF5Exception) {
            this.id = -1;
            throw new HDF5Exception("HDF5File: " + hDF5Exception);
        }
    }

    public HDF5File(String string, int n, int n2) throws HDF5Exception {
        super(string);
        this.type = 6;
        try {
            this.id = H5.H5Fopen(string, n, n2);
        }
        catch (HDF5Exception hDF5Exception) {
            this.id = -1;
            throw new HDF5Exception("HDF5File: " + hDF5Exception);
        }
    }
}

