/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Dataspace
extends HDF5Object {
    private int rank;
    private long[] dims;
    private long[] maxdims;
    private long[] start;
    private long[] stride;
    private long[] count;

    public void init() throws HDF5Exception {
        if (this.id < 0) {
            return;
        }
        this.rank = H5.H5Sget_simple_extent_ndims(this.id);
        this.dims = new long[this.rank];
        this.maxdims = new long[this.rank];
        this.start = new long[this.rank];
        this.stride = new long[this.rank];
        this.count = new long[this.rank];
        int n = 0;
        while (n < this.rank) {
            this.start[n] = 0L;
            this.stride[n] = 1L;
            ++n;
        }
        n = H5.H5Sget_simple_extent_dims(this.id, this.dims, this.maxdims);
        if (n < 0) {
            return;
        }
        int n2 = 0;
        while (n2 < this.rank) {
            this.count[n2] = this.dims[n2];
            ++n2;
        }
    }

    public void select(long[] lArray, long[] lArray2, long[] lArray3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        this.start = lArray;
        this.stride = lArray2;
        this.count = lArray3;
        long[] lArray4 = new long[this.rank];
        int n = 0;
        while (n < this.rank) {
            lArray4[n] = 1L;
            ++n;
        }
        H5.H5Sselect_hyperslab(this.id, 0, lArray, lArray2, lArray3, lArray4);
    }

    public int getRank() {
        return this.rank;
    }

    public long[] getDims() {
        return this.dims;
    }

    public long[] getMaxdims() {
        return this.maxdims;
    }

    public long[] getCount() {
        return this.count;
    }

    public synchronized String toString() {
        String string = "";
        int n = 0;
        while (n < this.rank) {
            string = string + this.dims[n] + "x";
            ++n;
        }
        n = string.length();
        if (n > 1) {
            string = string.substring(0, n - 1);
        }
        return this.getClass().getName() + "[rank=" + this.rank + ",dimensions=" + string + "]";
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            Object var2_1 = null;
            H5.H5Sclose(this.id);
        }
    }

    public HDF5Dataspace() {
        this.type = 4;
    }

    public HDF5Dataspace(int n) {
        this.type = 4;
        try {
            this.id = H5.H5Screate(n);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Dataspace: " + hDF5Exception);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Dataspace.init(): " + hDF5Exception);
        }
    }

    public HDF5Dataspace(int n, long[] lArray, long[] lArray2) {
        this.type = 4;
        try {
            this.id = H5.H5Screate_simple(n, lArray, lArray2);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Dataspace: " + hDF5Exception);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Dataspace.init(): " + hDF5Exception);
        }
    }
}

