/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import java.lang.reflect.Array;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.data.hdf5.hdf5objects.HDF5Dataspace;
import visad.data.hdf5.hdf5objects.HDF5Datatype;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Dataset
extends HDF5Object {
    protected Object data;
    protected HDF5Datatype datatype;
    protected HDF5Dataspace dataspace;
    protected int rank;
    protected long[] dims;
    protected long[] maxdims;
    protected long[] count;
    protected Vector member_names;

    public void init() throws HDF5Exception {
        if (this.id < 0) {
            return;
        }
        this.datatype = new HDF5Datatype();
        this.datatype.setID(H5.H5Dget_type(this.id));
        this.dataspace = new HDF5Dataspace();
        this.dataspace.setID(H5.H5Dget_space(this.id));
        this.rank = this.dataspace.getRank();
        this.dims = this.dataspace.getDims();
        this.maxdims = this.dataspace.getMaxdims();
        this.count = this.dataspace.getCount();
    }

    public Object readData() throws HDF5Exception, NullPointerException {
        int n = -2;
        return this.readData(n, n);
    }

    public Object readData(int n, int n2) throws HDF5Exception, NullPointerException {
        this.data = null;
        System.gc();
        if (H5.H5Tget_class(this.datatype.getID()) == 6) {
            this.data = this.readCompoundData(n, n2);
            return this.data;
        }
        this.data = this.datatype.defineData(this.count);
        if (this.data == null) {
            return null;
        }
        if (this.data.getClass().getName().endsWith("Ljava.lang.String;")) {
            int n3 = Array.getLength(this.data);
            long l = H5.H5Dget_storage_size(this.id);
            int n4 = (int)(l / (long)n3);
            byte[][] byArray = new byte[n3][n4];
            H5.H5Dread(this.id, H5.H5Dget_type(this.id), n, n2, -2, byArray);
            int n5 = 0;
            while (n5 < n3) {
                Array.set(this.data, n5, new String(byArray[n5]));
                ++n5;
            }
        } else {
            H5.H5Dread(this.id, H5.H5Dget_type(this.id), n, n2, -2, this.data);
            boolean bl = false;
            int n6 = this.datatype.getID();
            int n7 = H5.H5Tget_class(n6);
            if (n7 == 0 && H5.H5Tget_sign(n6) == 0) {
                Object object;
                this.data = object = HDF5Dataset.convertUnsignedData(this.data);
            }
        }
        return this.data;
    }

    private Object readCompoundData(int n, int n2) throws HDF5Exception, NullPointerException {
        String string = "";
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -2;
        Object[] objectArray = null;
        int n9 = 0;
        long l = 1L;
        if (this.count == null) {
            return null;
        }
        int n10 = 0;
        while (n10 < this.count.length) {
            l *= this.count[n10];
            ++n10;
        }
        n9 = (int)l;
        n10 = this.datatype.getID();
        int n11 = H5.H5Tget_nmembers(n10);
        Vector<Object> vector = new Vector<Object>();
        this.member_names = new Vector();
        int n12 = 0;
        while (n12 < n11) {
            objectArray = null;
            n7 = -1;
            string = H5.H5Tget_member_name(n10, n12);
            n3 = H5.H5Tget_member_type(n10, n12);
            n5 = H5.H5Tget_class(n3);
            n6 = H5.H5Tget_size(n3);
            n4 = H5.H5Tcreate(6, n6);
            switch (n5) {
                case 0: {
                    Object[] objectArray2;
                    n7 = H5.H5Tget_sign(n3);
                    if (n6 == 1) {
                        objectArray2 = new byte[n9];
                        H5.H5Tinsert(n4, string, 0L, H5.J2C(72));
                        H5.H5Dread(this.id, n4, n, n2, n8, (byte[])objectArray2);
                        objectArray = objectArray2;
                        break;
                    }
                    if (n6 == 2) {
                        objectArray2 = new short[n9];
                        H5.H5Tinsert(n4, string, 0L, H5.J2C(69));
                        H5.H5Dread(this.id, n4, n, n2, n8, objectArray2);
                        objectArray = objectArray2;
                        break;
                    }
                    if (n6 == 4) {
                        objectArray2 = new int[n9];
                        H5.H5Tinsert(n4, string, 0L, H5.J2C(70));
                        H5.H5Dread(this.id, n4, n, n2, n8, objectArray2);
                        objectArray = objectArray2;
                        break;
                    }
                    if (n6 != 8) break;
                    objectArray2 = new long[n9];
                    H5.H5Tinsert(n4, string, 0L, H5.J2C(71));
                    H5.H5Dread(this.id, n4, n, n2, n8, objectArray2);
                    objectArray = objectArray2;
                    break;
                }
                case 1: {
                    Object[] objectArray2;
                    if (n6 == 4) {
                        objectArray2 = new float[n9];
                        H5.H5Tinsert(n4, string, 0L, H5.J2C(55));
                        H5.H5Dread(this.id, n4, n, n2, n8, objectArray2);
                        objectArray = objectArray2;
                        break;
                    }
                    if (n6 != 8) break;
                    objectArray2 = new double[n9];
                    H5.H5Tinsert(n4, string, 0L, H5.J2C(54));
                    H5.H5Dread(this.id, n4, n, n2, n8, objectArray2);
                    objectArray = objectArray2;
                    break;
                }
                default: {
                    objectArray = null;
                    break;
                }
            }
            if (objectArray != null) {
                this.member_names.add(string);
                if (n7 == 0) {
                    vector.add(HDF5Dataset.convertUnsignedData(objectArray));
                } else {
                    vector.add(objectArray);
                }
            }
            ++n12;
        }
        return vector;
    }

    public static Object convertUnsignedData(Object object) throws HDF5Exception {
        Object object2 = null;
        String string = object.getClass().getName();
        char c = string.charAt(string.lastIndexOf("[") + 1);
        int n = Array.getLength(object);
        if (c == 'B') {
            short[] sArray = new short[n];
            short s = 0;
            int n2 = 0;
            while (n2 < n) {
                s = Array.getByte(object, n2);
                if (s < 0) {
                    s = (short)(s + 256);
                }
                sArray[n2] = s;
                ++n2;
            }
            object2 = sArray;
            object = null;
        } else if (c == 'S') {
            int[] nArray = new int[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                n3 = Array.getShort(object, n4);
                if (n3 < 0) {
                    n3 += 65536;
                }
                nArray[n4] = n3;
                ++n4;
            }
            object2 = nArray;
            object = null;
        } else if (c == 'I') {
            long[] lArray = new long[n];
            long l = 0L;
            int n5 = 0;
            while (n5 < n) {
                l = Array.getInt(object, n5);
                if (l < 0L) {
                    l += 0x100000000L;
                }
                lArray[n5] = l;
                ++n5;
            }
            object2 = lArray;
            object = null;
        } else {
            object2 = object;
        }
        return object2;
    }

    public void writeData(Object object) throws HDF5Exception, NullPointerException {
        int n = -2;
        this.writeData(n, n, object);
    }

    public void writeData(int n, int n2, Object object) throws HDF5Exception, NullPointerException {
        int n3 = -1;
        int n4 = -2;
        String string = object.getClass().getName();
        char c = string.charAt(string.lastIndexOf("[") + 1);
        n3 = c == 'B' ? H5.J2C(72) : (c == 'C' ? H5.J2C(53) : (c == 'D' ? H5.J2C(54) : (c == 'F' ? H5.J2C(55) : (c == 'I' ? H5.J2C(70) : (c == 'J' ? H5.J2C(71) : (c == 'S' ? H5.J2C(69) : (c == 'Z' ? H5.J2C(56) : H5.H5Dget_type(this.id))))))));
        int n5 = H5.H5Dwrite(this.id, n3, n, n2, n4, object);
    }

    public Object getData() {
        return this.data;
    }

    public HDF5Datatype getDatatype() {
        return this.datatype;
    }

    public HDF5Dataspace getDataspace() {
        return this.dataspace;
    }

    public int getRank() {
        return this.rank;
    }

    public long[] getDims() {
        return this.dims;
    }

    public long[] getMaxdims() {
        return this.maxdims;
    }

    public long[] getCount() {
        return this.count;
    }

    public String toString() {
        if (this.datatype == null || this.dataspace == null) {
            return super.toString();
        }
        String string = "";
        int n = 0;
        while (n < this.rank) {
            string = string + this.dims[n] + "x";
            ++n;
        }
        n = string.length();
        if (n > 1) {
            string = string.substring(0, n - 1);
        }
        return this.getClass().getName() + "[name=" + this.name + ",type=" + this.datatype + ",dimensions=" + string + "]";
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            Object var2_1 = null;
            H5.H5Dclose(this.id);
        }
    }

    public HDF5Dataset() {
        this.type = 2;
    }

    public HDF5Dataset(String string) {
        super(string);
        this.type = 2;
    }

    public HDF5Dataset(int n, String string, int n2, int n3, int n4) {
        super(string);
        this.type = 2;
        try {
            this.id = H5.H5Dcreate(n, string, n2, n3, n4);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Dataset: " + hDF5Exception);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Dataset: " + hDF5Exception);
        }
    }

    public HDF5Dataset(int n, String string) {
        super(string);
        this.type = 2;
        try {
            this.id = H5.H5Dopen(n, string);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Dataset: " + hDF5Exception);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Dataset.init(): " + hDF5Exception);
        }
    }
}

