/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.data.hdf5.hdf5objects.HDF5Dataset;
import visad.data.hdf5.hdf5objects.HDF5Dataspace;
import visad.data.hdf5.hdf5objects.HDF5Datatype;

public class HDF5Attribute
extends HDF5Dataset {
    public void init() throws HDF5Exception {
        if (this.id < 0) {
            return;
        }
        this.datatype = new HDF5Datatype();
        this.datatype.setID(H5.H5Aget_type(this.id));
        this.datatype.init();
        this.dataspace = new HDF5Dataspace();
        this.dataspace.setID(H5.H5Aget_space(this.id));
        this.dataspace.init();
        this.rank = this.dataspace.getRank();
        this.dims = this.dataspace.getDims();
        this.maxdims = this.dataspace.getMaxdims();
        this.count = this.dataspace.getCount();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            Object var2_1 = null;
            H5.H5Aclose(this.id);
        }
    }

    public HDF5Attribute() {
        this.type = 5;
    }

    public HDF5Attribute(int n, String string, int n2, int n3, int n4) {
        super(string);
        this.type = 5;
        try {
            this.id = H5.H5Acreate(n, string, n2, n3, n4);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Attribute: " + hDF5Exception);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Attribute.init(): " + hDF5Exception);
        }
    }

    public HDF5Attribute(int n, String string) {
        super(string);
        this.type = 5;
        try {
            this.id = H5.H5Aopen_name(n, string);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Attribute: " + hDF5Exception);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Attribute.init(): " + hDF5Exception);
        }
    }

    public HDF5Attribute(int n, int n2) {
        this.type = 5;
        try {
            this.id = H5.H5Aopen_idx(n, n2);
            String[] stringArray = new String[]{""};
            H5.H5Aget_name(this.id, 80L, stringArray);
            this.name = stringArray[0];
        }
        catch (Exception exception) {
            System.err.println("HDF5Attribute: " + exception);
            this.id = -1;
            this.name = null;
        }
        try {
            this.init();
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println("HDF5Attribute.init(): " + hDF5Exception);
        }
    }
}

