/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5;

import java.net.URL;
import java.rmi.RemoteException;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.Data;
import visad.DataImpl;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.Set;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.hdf5.HDF5AdapterException;
import visad.data.hdf5.HDF5DataAdaptable;
import visad.data.hdf5.HDF5DatasetAdapted;
import visad.data.hdf5.HDF5FileAdapted;
import visad.data.hdf5.HDF5GroupAdapted;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Form
extends Form
implements FormFileInformer {
    public boolean isThisType(String string) {
        boolean bl = false;
        try {
            bl = H5.H5Fis_hdf5(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isThisType(byte[] byArray) {
        int n = new Byte(byArray[0]).intValue();
        if (n != 137) {
            return false;
        }
        String string = new String(byArray, 1, 4);
        return string.startsWith("HDF");
    }

    public String[] getDefaultSuffixes() {
        String[] stringArray = new String[]{"hdf", "h5"};
        return stringArray;
    }

    public FormNode getForms(Data data) {
        return this;
    }

    public DataImpl open(String string) throws VisADException, RemoteException {
        HDF5FileAdapted hDF5FileAdapted = null;
        try {
            hDF5FileAdapted = new HDF5FileAdapted(string, 0, -2);
        }
        catch (HDF5Exception hDF5Exception) {
            System.err.println(hDF5Exception);
        }
        return this.getFileData(hDF5FileAdapted);
    }

    public DataImpl open(URL uRL) throws VisADException {
        throw new UnimplementedException("HDF5Form.open( URL )");
    }

    public void add(String string, Data data, boolean bl) throws BadFormException {
        throw new BadFormException("HDF5Form.add( String, Data, boolean )");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(String string, Data data, boolean bl) throws BadFormException, RemoteException, VisADException {
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            n = H5.H5Fcreate(string, 2, -2, -2);
        }
        catch (HDF5Exception hDF5Exception) {
            throw new HDF5AdapterException("HDF5Form.save() failed: cannot create file " + string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new HDF5AdapterException("HDF5Form.save() failed: cannot create file " + string);
        }
        try {
            try {
                this.save(n, data, 0, 0);
            }
            catch (BadFormException badFormException) {
                throw badFormException;
            }
            catch (RemoteException remoteException) {
                throw remoteException;
            }
            catch (VisADException visADException) {
                throw visADException;
            }
            catch (HDF5Exception hDF5Exception) {
                throw new HDF5AdapterException(hDF5Exception.toString());
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                H5.H5Fclose(n);
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        H5.H5Fclose(n);
        return;
    }

    private void save(int n, Data data, int n2, int n3) throws BadFormException, RemoteException, VisADException, HDF5Exception {
        if (data instanceof Tuple) {
            int n4 = 0;
            int n5 = 0;
            Data data2 = null;
            Tuple tuple = (Tuple)data;
            String string = "Group" + n3 + "at" + n2;
            if (n2 == 0) {
                n5 = n;
                n4 = -1;
            } else {
                n5 = H5.H5Gcreate(n, string, -1);
            }
            int n6 = tuple.getDimension();
            int n7 = 0;
            while (n7 < n6) {
                data2 = tuple.getComponent(n7);
                this.save(n5, data2, n2 + 1, n4++);
                ++n7;
            }
        } else if (data instanceof Field) {
            Field field = (Field)data;
            RealType[] realTypeArray = ((FunctionType)field.getType()).getRealComponents();
            Set set = field.getDomainSet();
            if (!(set instanceof GriddedSet) || realTypeArray == null) {
                return;
            }
            GriddedSet griddedSet = (GriddedSet)set;
            RealType realType = realTypeArray[0];
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = griddedSet.getLength();
            int[] nArray = griddedSet.getLengths();
            int n12 = nArray.length;
            long[] lArray = new long[n12];
            int n13 = 0;
            while (n13 < n12) {
                lArray[n13] = nArray[n13];
                ++n13;
            }
            n8 = H5.H5Screate_simple(n12, lArray, null);
            n13 = 1;
            n13 = field.isFlatField() ? ((FlatField)field).getRangeDimension() : field.getDefaultRangeUnits().length;
            float[] fArray = new float[n11];
            float[][] fArray2 = field.getFloats(false);
            if (n13 == 1) {
                int n14 = 0;
                while (n14 < n11) {
                    fArray[n14] = fArray2[0][n14];
                    ++n14;
                }
                try {
                    n9 = H5.H5Dcreate(n, realType.getName(), H5.J2C(55), n8, -2);
                    H5.H5Dwrite(n9, H5.J2C(55), -2, -2, -2, fArray);
                }
                finally {
                    Object var21_40 = null;
                    H5.H5Dclose(n9);
                    H5.H5Sclose(n8);
                }
            } else {
                float[][] fArray3 = new float[n11][n13];
                int n15 = 0;
                while (n15 < n11) {
                    int n16 = 0;
                    while (n16 < n13) {
                        fArray3[n15][n16] = fArray2[n16][n15];
                        ++n16;
                    }
                    ++n15;
                }
                try {
                    n10 = H5.H5Tcreate(6, n13 * 4);
                    int n17 = 0;
                    while (n17 < n13) {
                        realType = realTypeArray[n17];
                        H5.H5Tinsert(n10, realType.getName(), n17 * 4, H5.J2C(55));
                        ++n17;
                    }
                    String string = "Compound" + n3 + "at" + n2;
                    n9 = H5.H5Dcreate(n, string, n10, n8, -2);
                    H5.H5Dwrite(n9, n10, n8, -2, -2, fArray3);
                }
                finally {
                    Object var22_45 = null;
                    H5.H5Tclose(n10);
                    H5.H5Dclose(n9);
                    H5.H5Sclose(n8);
                }
            }
        } else if (data instanceof Text) {
            Text text = (Text)data;
            String string = text.getValue();
            TextType textType = (TextType)text.getType();
            String string2 = textType.getName();
            int n18 = string.length();
            long[] lArray = new long[]{1L};
            int n19 = H5.H5Screate_simple(1, lArray, null);
            int n20 = H5.H5Tcopy(H5.J2C(15));
            H5.H5Tset_size(n20, n18);
            H5.H5Tset_strpad(n20, 1);
            int n21 = H5.H5Dcreate(n, string2, n20, n19, -2);
            byte[][] byArray = new byte[1][n18];
            byArray[0] = string.getBytes();
            H5.H5Dwrite(n21, n20, -2, -2, -2, byArray);
            H5.H5Dclose(n21);
            byArray = null;
        }
    }

    public MathType getMathType(HDF5FileAdapted hDF5FileAdapted) throws VisADException, RemoteException {
        MathType mathType = null;
        HDF5Object hDF5Object = null;
        int n = hDF5FileAdapted.getObjectCount();
        if (n <= 0) {
            throw new HDF5AdapterException("no data object in file: " + hDF5FileAdapted.getName());
        }
        MathType[] mathTypeArray = new MathType[n];
        int n2 = 0;
        while (n2 < n) {
            Object object = hDF5FileAdapted.getDataObject(n2);
            if (object instanceof HDF5GroupAdapted) {
                hDF5Object = (HDF5GroupAdapted)object;
            } else if (object instanceof HDF5DatasetAdapted) {
                hDF5Object = (HDF5DatasetAdapted)object;
            }
            mathTypeArray[n2] = mathType = hDF5Object.getMathType();
            ++n2;
        }
        TupleType tupleType = new TupleType(mathTypeArray);
        return tupleType;
    }

    public DataImpl getFileData(HDF5FileAdapted hDF5FileAdapted) throws VisADException, RemoteException {
        Object var2_2 = null;
        Object var3_3 = null;
        int n = hDF5FileAdapted.getObjectCount();
        if (n <= 0) {
            throw new HDF5AdapterException("no data object in file: " + hDF5FileAdapted.getName());
        }
        HDF5DataAdaptable[] hDF5DataAdaptableArray = new HDF5DataAdaptable[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Object object = hDF5FileAdapted.getDataObject(n3);
            if (object instanceof HDF5GroupAdapted) {
                hDF5DataAdaptableArray[n2++] = (HDF5GroupAdapted)object;
            } else if (object instanceof HDF5DatasetAdapted) {
                hDF5DataAdaptableArray[n2++] = (HDF5DatasetAdapted)object;
            }
            ++n3;
        }
        return this.assembleStructs(hDF5DataAdaptableArray);
    }

    private DataImpl assembleStructs(HDF5DataAdaptable[] hDF5DataAdaptableArray) throws VisADException, RemoteException {
        DataImpl dataImpl = null;
        int n = hDF5DataAdaptableArray.length;
        if (n == 1) {
            return this.getVisADDataObject(hDF5DataAdaptableArray[0]);
        }
        boolean bl = true;
        MathType mathType = null;
        MathType[] mathTypeArray = new MathType[n];
        Data[] dataArray = new DataImpl[n];
        dataArray[0] = this.getVisADDataObject(hDF5DataAdaptableArray[0]);
        mathTypeArray[0] = dataArray[0].getType();
        mathType = mathTypeArray[0];
        int n2 = 1;
        while (n2 < n) {
            dataArray[n2] = this.getVisADDataObject(hDF5DataAdaptableArray[n2]);
            mathTypeArray[n2] = ((DataImpl)dataArray[n2]).getType();
            bl = mathTypeArray[n2].equals(mathType);
            ++n2;
        }
        if (bl) {
            RealType realType = new RealType("struct_id", null, null);
            Integer1DSet integer1DSet = new Integer1DSet((MathType)realType, n);
            FunctionType functionType = new FunctionType(realType, mathType);
            FieldImpl fieldImpl = new FieldImpl(functionType, integer1DSet);
            int n3 = 0;
            while (n3 < n) {
                fieldImpl.setSample(n3, dataArray[n3]);
                ++n3;
            }
            dataImpl = fieldImpl;
        } else {
            TupleType tupleType = new TupleType(mathTypeArray);
            dataImpl = new Tuple(tupleType, dataArray, false);
        }
        return dataImpl;
    }

    public DataImpl getVisADDataObject(HDF5DataAdaptable hDF5DataAdaptable) throws VisADException, RemoteException {
        return hDF5DataAdaptable.getAdaptedData();
    }

    public HDF5Form() {
        this("HDF5 Data");
    }

    public HDF5Form(String string) {
        super(string);
    }
}

