/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5;

import java.awt.image.IndexColorModel;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.IntegerNDSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarType;
import visad.Text;
import visad.TextType;
import visad.TypeException;
import visad.VisADException;
import visad.data.hdf5.HDF5AdapterException;
import visad.data.hdf5.HDF5DataAdaptable;
import visad.data.hdf5.hdf5objects.HDF5Dataset;
import visad.data.hdf5.hdf5objects.HDF5Dataspace;
import visad.data.hdf5.hdf5objects.HDF5Datatype;

public class HDF5DatasetAdapted
extends HDF5Dataset
implements HDF5DataAdaptable {
    MathType field_type;
    RealTupleType domain;
    RealTupleType range;
    DataImpl dataField;

    public void init() throws HDF5Exception {
        super.init();
        if (this.rank <= 0) {
            return;
        }
        if (this.data == null) {
            try {
                this.data = this.readData();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        boolean bl = false;
        try {
            int n = H5.H5Aopen_name(this.id, "PALETTE");
            int n2 = H5.H5Aget_type(n);
            int n3 = H5.H5Tget_class(n2);
            if (n3 == 7) {
                bl = true;
            }
            H5.H5Tclose(n2);
            H5.H5Aclose(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.data.getClass().getName().endsWith("Ljava.lang.String;")) {
            this.mapToText();
        } else if (bl) {
            try {
                this.mapToImage();
            }
            catch (Exception exception) {
                throw new HDF5Exception(exception.toString());
            }
        } else {
            this.mapToFlatField();
        }
    }

    private void mapToImage() throws HDF5Exception, VisADException {
        int n = (int)this.dims[0];
        int n2 = (int)this.dims[1];
        int n3 = H5.H5Aopen_name(this.id, "PALETTE");
        byte[] byArray = new byte[8];
        int n4 = H5.H5Aget_type(n3);
        H5.H5Aread(n3, n4, byArray);
        H5.H5Tclose(n4);
        int n5 = H5.H5Rdereference(this.id, 0, byArray);
        HDF5Datatype hDF5Datatype = new HDF5Datatype();
        hDF5Datatype.setID(H5.H5Dget_type(n5));
        HDF5Dataspace hDF5Dataspace = new HDF5Dataspace();
        hDF5Dataspace.setID(H5.H5Dget_space(n5));
        byte[] byArray2 = new byte[768];
        H5.H5Dread(n5, H5.H5Dget_type(n5), -2, -2, -2, byArray2);
        byte[] byArray3 = new byte[256];
        byte[] byArray4 = new byte[256];
        byte[] byArray5 = new byte[256];
        int n6 = 0;
        while (n6 < 256) {
            byArray3[n6] = byArray2[3 * n6];
            byArray4[n6] = byArray2[3 * n6 + 1];
            byArray5[n6] = byArray2[3 * n6 + 2];
            ++n6;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, byArray3, byArray4, byArray5, 0);
        int n7 = n * n2;
        int n8 = -1;
        float[][] fArray = new float[3][n7];
        int n9 = 0;
        while (n9 < n7) {
            n8 = Integer.parseInt(Array.get(this.data, n9).toString());
            fArray[0][n9] = indexColorModel.getRed(n8);
            fArray[1][n9] = indexColorModel.getGreen(n8);
            fArray[2][n9] = indexColorModel.getBlue(n8);
            ++n9;
        }
        RealType realType = RealType.getRealType("ImageLine");
        RealType realType2 = RealType.getRealType("ImageElement");
        RealType realType3 = RealType.getRealType("Red");
        RealType realType4 = RealType.getRealType("Green");
        RealType realType5 = RealType.getRealType("Blue");
        RealType[] realTypeArray = new RealType[]{realType3, realType4, realType5};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        RealType[] realTypeArray2 = new RealType[]{realType2, realType};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        Linear2DSet linear2DSet = new Linear2DSet((MathType)realTupleType2, 0.0, (float)((double)n - 1.0), n, (float)((double)n2 - 1.0), 0.0, n2);
        FunctionType functionType = new FunctionType(realTupleType2, realTupleType);
        FlatField flatField = new FlatField(functionType, linear2DSet);
        try {
            flatField.setSamples(fArray, false);
        }
        catch (RemoteException remoteException) {
            throw new HDF5Exception("setSamples for image failed.");
        }
        this.field_type = functionType;
        this.domain = realTupleType2;
        this.range = realTupleType;
        this.dataField = flatField;
        H5.H5Aclose(n3);
    }

    private void mapToText() throws HDF5Exception {
        String string = "";
        if (this.data.getClass().isArray()) {
            int n = Array.getLength(this.data);
            int n2 = 0;
            while (n2 < n) {
                string = string + "\n" + Array.get(this.data, n2).toString();
                ++n2;
            }
        } else {
            string = this.data.toString();
        }
        TextType textType = null;
        String string2 = new String(this.shortName).replace('-', '_');
        try {
            textType = new TextType(string2);
        }
        catch (TypeException typeException) {
            textType = (TextType)ScalarType.getScalarTypeByName(string2);
        }
        catch (VisADException visADException) {
            throw new HDF5Exception(visADException.toString());
        }
        try {
            this.dataField = new Text(textType, string);
            this.field_type = this.dataField.getType();
        }
        catch (VisADException visADException) {
            throw new HDF5Exception(visADException.toString());
        }
    }

    private void mapToFlatField() throws HDF5Exception {
        int n;
        String string;
        RealType[] realTypeArray;
        try {
            realTypeArray = new RealType[this.rank];
            string = "";
            n = 0;
            while (n < this.rank) {
                string = "dim" + String.valueOf(n);
                realTypeArray[n] = RealType.getRealType(string);
                ++n;
            }
            this.domain = new RealTupleType(realTypeArray);
        }
        catch (VisADException visADException) {
            throw new HDF5Exception("Constructing the domain of HDF5DatasetAdapted failed. " + visADException);
        }
        try {
            realTypeArray = null;
            string = "";
            if (this.data instanceof Vector) {
                n = this.member_names.size();
                realTypeArray = new RealType[n];
                int n2 = 0;
                while (n2 < n) {
                    string = (String)this.member_names.elementAt(n2);
                    realTypeArray[n2] = RealType.getRealType(string);
                    ++n2;
                }
            } else {
                realTypeArray = new RealType[1];
                string = new String(this.shortName).replace('-', '_');
                realTypeArray[0] = RealType.getRealType(string);
            }
            this.range = new RealTupleType(realTypeArray);
        }
        catch (VisADException visADException) {
            throw new HDF5Exception("Constructing the range of HDF5DatasetAdapted failed. " + visADException);
        }
        try {
            this.field_type = new FunctionType(this.domain, this.range);
        }
        catch (VisADException visADException) {
            throw new HDF5Exception("Constructing the field_type of HDF5DatasetAdapted failed. " + visADException);
        }
        try {
            this.dataField = this.defineDataField();
        }
        catch (Exception exception) {
            throw new HDF5Exception("Constructing the data field of HDF5DatasetAdapted failed. " + exception);
        }
    }

    private FieldImpl defineDataField() throws HDF5Exception, VisADException, RemoteException {
        int n;
        int[] nArray;
        FlatField flatField = null;
        boolean bl = false;
        IntegerNDSet integerNDSet = null;
        int n2 = this.datatype.get_class();
        boolean bl2 = bl = n2 == 0 || n2 == 1 || n2 == 6 && this.member_names.size() > 0;
        if (bl) {
            nArray = new int[this.rank];
            n = 0;
            while (n < this.rank) {
                nArray[n] = (int)this.dims[n];
                ++n;
            }
        } else {
            throw new HDF5AdapterException("constructing data field.");
        }
        integerNDSet = new IntegerNDSet((MathType)this.domain, nArray);
        flatField = new FlatField((FunctionType)this.field_type, integerNDSet);
        if (this.data != null) {
            Object object;
            int n3 = 0;
            n = 0;
            if (n2 == 6) {
                object = (Vector)this.data;
                n3 = this.member_names.size();
                n = Array.getLength(((Vector)object).elementAt(0));
            } else {
                n3 = 1;
                n = Array.getLength(this.data);
            }
            object = new float[n3][n];
            Object var8_9 = null;
            int n4 = 0;
            while (n4 < n) {
                if (n2 == 6) {
                    Vector vector = (Vector)this.data;
                    int n5 = 0;
                    while (n5 < n3) {
                        var8_9 = vector.elementAt(n5);
                        object[n5][n4] = Float.parseFloat(Array.get(var8_9, n4).toString());
                        ++n5;
                    }
                } else {
                    object[0][n4] = Float.parseFloat(Array.get(this.data, n4).toString());
                }
                ++n4;
            }
            flatField.setSamples((float[][])object, false);
        }
        return flatField;
    }

    public MathType getMathType() throws VisADException {
        return this.field_type;
    }

    public DataImpl getAdaptedData() throws VisADException, RemoteException {
        return this.dataField;
    }

    public DataImpl getAdaptedData(int[] nArray) throws VisADException, RemoteException {
        return this.dataField;
    }

    public HDF5DatasetAdapted() {
    }

    public HDF5DatasetAdapted(int n, String string, int n2, int n3, int n4) {
        super(n, string, n2, n3, n4);
    }

    public HDF5DatasetAdapted(int n, String string) {
        super(n, string);
    }
}

