/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import java.rmi.RemoteException;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Column;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.PrimaryHDU;
import nom.tam.util.ArrayFuncs;
import visad.FieldImpl;
import visad.FlatField;
import visad.Function;
import visad.FunctionType;
import visad.GriddedSet;
import visad.MathType;
import visad.RealTupleType;
import visad.Scalar;
import visad.ScalarType;
import visad.Set;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.fits.ConvertDoubleArray;
import visad.data.fits.Tourist;

public class TourWriter
extends Tourist {
    private Fits fits;

    private String[] getNames(RealTupleType realTupleType) throws VisADException {
        int n = realTupleType.getDimension();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            MathType mathType = realTupleType.getComponent(n2);
            if (!(mathType instanceof ScalarType)) {
                throw new VisADException("Expected a ScalarType name, got " + mathType.getClass().getName());
            }
            stringArray[n2] = ((ScalarType)mathType).getName();
            ++n2;
        }
        return stringArray;
    }

    private String[] getNames(ScalarType scalarType) throws VisADException {
        String[] stringArray = new String[]{scalarType.getName()};
        return stringArray;
    }

    private String[] getNames(MathType mathType) throws VisADException {
        if (mathType instanceof RealTupleType) {
            return this.getNames((RealTupleType)mathType);
        }
        if (mathType instanceof ScalarType) {
            return this.getNames((ScalarType)mathType);
        }
        throw new VisADException("Couldn't get list of names from " + mathType.getClass().getName());
    }

    private void saveBinaryTable(FlatField flatField, int n, int n2) throws VisADException {
        BinaryTableHDU binaryTableHDU;
        System.err.println("TourWriter.saveBinaryTable(" + n + ", " + n2 + "):");
        FunctionType functionType = (FunctionType)flatField.getType();
        String[] stringArray = this.getNames(functionType.getRange());
        try {
            binaryTableHDU = new BinaryTableHDU();
        }
        catch (FitsException fitsException) {
            throw new VisADException("Couldn't create BinaryTableHDU: " + fitsException.getMessage());
        }
        double[][] dArray = flatField.getValues();
        System.err.println("\tvalues: " + dArray.length + "x" + dArray[0].length);
        double[][] dArray2 = new double[1][];
        int[] nArray = new int[2];
        Object[][] objectArray = new Object[dArray.length][];
        nArray[0] = 1;
        int n3 = 0;
        while (n3 < objectArray.length) {
            dArray2[0] = dArray[n3];
            nArray[1] = dArray2[0].length;
            ConvertDoubleArray convertDoubleArray = new ConvertDoubleArray(nArray, dArray2);
            Object object = convertDoubleArray.getConverter().getRowMajor(dArray2);
            if (object == null) {
                throw new VisADException("Couldn't extract array from column #" + n3);
            }
            try {
                Column column = new Column();
                column.setData((Object[])object);
                String string = "" + n3;
                StringBuffer stringBuffer = new StringBuffer(8);
                if (stringArray != null) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("TTYPE");
                    stringBuffer.append(string);
                    stringBuffer.append("        ");
                    stringBuffer.setLength(8);
                    stringBuffer.append("= '");
                    stringBuffer.append(stringArray[n3]);
                    stringBuffer.append("'");
                    column.addKey(stringBuffer.toString());
                }
                binaryTableHDU.addColumn(column);
            }
            catch (FitsException fitsException) {
                System.err.println("Couldn't add binary table column #" + n3 + ": " + fitsException.getMessage());
            }
            ++n3;
        }
        try {
            this.fits.addHDU(binaryTableHDU);
        }
        catch (FitsException fitsException) {
            throw new VisADException("Couldn't add FITS binary table HDU : " + fitsException.getMessage());
        }
    }

    private void saveImage(FlatField flatField, int n, int n2) throws VisADException {
        int n3;
        Set set = flatField.getDomainSet();
        if (!(set instanceof GriddedSet)) {
            throw new VisADException("Cannot build FITS Image from non-Gridded domain");
        }
        try {
            n3 = this.fits.size();
        }
        catch (FitsException fitsException) {
            System.err.println("TourWriter.saveImage: Yikes!  Fits.size() threw");
            fitsException.printStackTrace(System.err);
            throw new VisADException("Couldn't get size of FITS file");
        }
        int[] nArray = ((GriddedSet)set).getLengths();
        if (nArray.length != 2) {
            throw new VisADException("Don't know how to decipher " + nArray.length + "-dimension FlatField!");
        }
        double[][] dArray = flatField.getValues();
        if (dArray[0].length != nArray[0] * nArray[1]) {
            throw new VisADException("Mismatch between FlatField length array and value array length");
        }
        if (dArray.length != 1 && dArray.length != 3) {
            throw new VisADException("Don't know how to decipher " + dArray.length + "-dimension FlatField values!");
        }
        int n4 = dArray[0].length;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        int n6 = nArray[1] - 1;
        while (n6 >= 0) {
            int n7 = n6 * nArray[0];
            int n8 = 0;
            while (n8 < nArray[0]) {
                int n9 = dArray.length == 3 ? (int)(0.299 * dArray[0][n5] + 0.587 * dArray[1][n5] + 0.114 * dArray[2][n5]) : (int)dArray[0][n5];
                byArray[n7 + n8] = (byte)n9;
                ++n5;
                ++n8;
            }
            --n6;
        }
        byte[][] byArray2 = (byte[][])ArrayFuncs.curl(byArray, nArray);
        try {
            BasicHDU basicHDU = n3 == 0 ? new PrimaryHDU(byArray2) : new ImageHDU(byArray2);
            this.fits.addHDU(basicHDU);
        }
        catch (FitsException fitsException) {
            throw new VisADException("Couldn't build " + (n3 == 0 ? "primary" : "image") + " FITS HDU : " + fitsException.getMessage());
        }
    }

    private void save(FlatField flatField) throws RemoteException, VisADException {
        MathType mathType = flatField.getType();
        if (!(mathType instanceof FunctionType)) {
            throw new VisADException("Confused Data object (FlatField with non-FunctionType)");
        }
        int n = flatField.getDomainSet().getDimension();
        if (n > 2) {
            throw new VisADException("Can't write FITS file with domain dimension of " + n);
        }
        int n2 = flatField.getRangeDimension();
        if (n2 != 1 && n2 != 3) {
            throw new VisADException("Can't write FITS file with range dimension of " + n2);
        }
        if (n != 2) {
            this.saveBinaryTable(flatField, n, n2);
        } else {
            this.saveImage(flatField, n, n2);
        }
    }

    private void save(FieldImpl fieldImpl) throws RemoteException, VisADException {
        if (fieldImpl instanceof FlatField) {
            this.save((FlatField)fieldImpl);
            return;
        }
        throw new UnimplementedException("Can only save FlatField data");
    }

    public boolean visit(Function function, int n) throws RemoteException, VisADException {
        if (!(function instanceof FieldImpl)) {
            throw new UnimplementedException("Can only save FieldImpl data");
        }
        this.save((FieldImpl)function);
        return true;
    }

    public boolean visit(Scalar scalar, int n) throws VisADException {
        return false;
    }

    public boolean visit(Set set, int n) throws VisADException {
        throw new UnimplementedException("Cannot write Set data to FITS files yet");
    }

    public TourWriter(boolean bl, Fits fits) {
        super(bl);
        this.fits = fits;
    }
}

