/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.Tuple;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.fits.ExceptionStack;
import visad.data.fits.FitsAdapter;

public class FitsForm
extends Form
implements FormFileInformer {
    public boolean isThisType(String string) {
        return string.endsWith(".fits");
    }

    public boolean isThisType(byte[] byArray) {
        String string = new String(byArray, 0, 9);
        if (!string.startsWith("SIMPLE  =")) {
            return false;
        }
        String string2 = new String(byArray, 9, 71);
        return (string2 = string2.trim()).length() == 1 && string2.charAt(0) == 'T';
    }

    public String[] getDefaultSuffixes() {
        String[] stringArray = new String[]{"fits"};
        return stringArray;
    }

    public synchronized void save(String string, Data data, boolean bl) throws BadFormException, IOException, RemoteException, VisADException {
        new FitsAdapter().save(string, data, bl);
    }

    public synchronized void add(String string, Data data, boolean bl) throws BadFormException {
        throw new RuntimeException("Can't yet add FITS objects");
    }

    private DataImpl extractData(FitsAdapter fitsAdapter) throws RemoteException, VisADException {
        Data[] dataArray;
        ExceptionStack exceptionStack = null;
        try {
            dataArray = fitsAdapter.getData();
        }
        catch (ExceptionStack exceptionStack2) {
            exceptionStack = exceptionStack2;
            fitsAdapter.clearExceptionStack();
            dataArray = fitsAdapter.getData();
        }
        fitsAdapter = null;
        if (dataArray == null || dataArray.length == 0) {
            if (exceptionStack != null) {
                throw exceptionStack;
            }
            return null;
        }
        DataImpl dataImpl = dataArray.length == 1 ? (DataImpl)dataArray[0] : new Tuple(dataArray);
        dataArray = null;
        return dataImpl;
    }

    public synchronized DataImpl open(String string) throws BadFormException, RemoteException, VisADException {
        return this.extractData(new FitsAdapter(string));
    }

    public synchronized DataImpl open(URL uRL) throws BadFormException, VisADException, IOException {
        return this.extractData(new FitsAdapter(uRL));
    }

    public synchronized FormNode getForms(Data data) {
        throw new RuntimeException("Can't yet get FITS forms");
    }

    public FitsForm() {
        super("FitsForm");
    }
}

