/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.PrimaryHDU;
import visad.Data;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.IntegerNDSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.VisADException;
import visad.data.fits.ExceptionStack;
import visad.data.fits.FitsTourGuide;
import visad.data.fits.TourInspector;
import visad.data.fits.TourWriter;

public class FitsAdapter {
    Fits fits = null;
    Data[] data = null;
    ExceptionStack stack = null;

    private int get1DLength(Object object) throws VisADException {
        if (!object.getClass().isArray()) {
            return 1;
        }
        int n = Array.getLength(object);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += this.get1DLength(Array.get(object, n3));
            ++n3;
        }
        return n2;
    }

    private int copyArray(Object object, double[] dArray, int n) throws VisADException {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = byArray[n2] >= 0 ? byArray[n2] : 256 + byArray[n2];
                dArray[n++] = n3;
                ++n2;
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            int n4 = 0;
            while (n4 < sArray.length) {
                int n5 = sArray[n4] >= 0 ? sArray[n4] : 65536 - sArray[n4];
                dArray[n++] = n5;
                ++n4;
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            int n6 = 0;
            while (n6 < nArray.length) {
                dArray[n++] = nArray[n6];
                ++n6;
            }
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            int n7 = 0;
            while (n7 < lArray.length) {
                dArray[n++] = lArray[n7];
                ++n7;
            }
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            int n8 = 0;
            while (n8 < fArray.length) {
                dArray[n++] = fArray[n8];
                ++n8;
            }
        } else if (object instanceof double[]) {
            double[] dArray2 = (double[])object;
            int n9 = 0;
            while (n9 < dArray2.length) {
                dArray[n++] = dArray2[n9];
                ++n9;
            }
        } else {
            throw new VisADException("type '" + object.getClass().getName() + "' not handled");
        }
        return n;
    }

    private int decompose(Object object, double[] dArray, int n) throws VisADException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == null) {
            return n;
        }
        if (!clazz.isArray()) {
            return this.copyArray(object, dArray, n);
        }
        int n2 = Array.getLength(object);
        int n3 = n2 - 1;
        while (n3 >= 0) {
            n = this.decompose(Array.get(object, n3), dArray, n);
            --n3;
        }
        return n;
    }

    private double[][] buildRange(Object object) throws VisADException {
        int n = this.get1DLength(object);
        double[] dArray = new double[n];
        int n2 = this.decompose(object, dArray, 0);
        while (n2 < n) {
            dArray[n2++] = Double.NaN;
        }
        double[][] dArray2 = new double[][]{dArray};
        return dArray2;
    }

    private Data addPrimary(PrimaryHDU primaryHDU) throws FitsException, VisADException, RemoteException {
        Object object;
        int n;
        int[] nArray = primaryHDU.getAxes();
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < nArray.length / 2) {
            int n3 = nArray.length - (n2 + 1);
            n = nArray[n3];
            nArray[n3] = nArray[n2];
            nArray[n2] = n;
            ++n2;
        }
        Object object2 = primaryHDU.getData().getData();
        if (object2 == null) {
            throw new VisADException("No HDU Data");
        }
        if (!object2.getClass().isArray()) {
            throw new VisADException("Unknown HDU Data type: " + object2.getClass().getName());
        }
        RealType[] realTypeArray = new RealType[nArray.length];
        n = 0;
        while (n < realTypeArray.length) {
            object = "NAxis" + (n + 1);
            realTypeArray[n] = RealType.getRealType((String)object, null, null);
            ++n;
        }
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        object = RealType.getRealType("value", null, null);
        FunctionType functionType = new FunctionType(realTupleType, (MathType)object);
        IntegerNDSet integerNDSet = new IntegerNDSet((MathType)realTupleType, nArray);
        FlatField flatField = new FlatField(functionType, integerNDSet);
        flatField.setSamples(this.buildRange(object2));
        return flatField;
    }

    private Data addImage(ImageHDU imageHDU) throws VisADException, RemoteException {
        int[] nArray;
        try {
            nArray = imageHDU.getAxes();
        }
        catch (FitsException fitsException) {
            nArray = null;
        }
        if (nArray == null) {
            throw new VisADException("Couldn't get image axes");
        }
        if (nArray.length != 2) {
            throw new VisADException("Expected two-dimensional image, not " + nArray.length + " dimensions");
        }
        Object object = imageHDU.getData().getData();
        if (object == null) {
            throw new VisADException("No HDU Data");
        }
        if (!object.getClass().isArray()) {
            throw new VisADException("Unknown HDU Data type: " + object.getClass().getName());
        }
        RealTupleType realTupleType = RealTupleType.SpatialCartesian2DTuple;
        RealType realType = RealType.getRealType("pixel", null, null);
        FunctionType functionType = new FunctionType(realTupleType, realType);
        Integer2DSet integer2DSet = new Integer2DSet((MathType)realTupleType, nArray[0], nArray[1]);
        FlatField flatField = new FlatField(functionType, integer2DSet);
        flatField.setSamples(this.buildRange(object));
        return flatField;
    }

    private int copyColumn(Object object, double[] dArray, int n) throws VisADException {
        Object[] objectArray = (Object[])object;
        if (objectArray.length != 1 && !(objectArray[0] instanceof byte[])) {
            System.err.println("FitsAdapter.copyColumn: Punting on wide column (" + objectArray[0].getClass().getName() + ")");
            return n;
        }
        if (objectArray[0] instanceof byte[]) {
            if (objectArray.length != 1) {
                System.err.println("Ignoring assumed " + objectArray.length + "-char String column");
                return n;
            }
            byte[] byArray = (byte[])objectArray[0];
            int n2 = 0;
            while (n2 < byArray.length) {
                dArray[n++] = byArray[n2++];
            }
        } else if (objectArray[0] instanceof short[]) {
            short[] sArray = (short[])objectArray[0];
            int n3 = 0;
            while (n3 < sArray.length) {
                dArray[n++] = sArray[n3++];
            }
        } else if (objectArray[0] instanceof int[]) {
            int[] nArray = (int[])objectArray[0];
            int n4 = 0;
            while (n4 < nArray.length) {
                dArray[n++] = nArray[n4++];
            }
        } else if (objectArray[0] instanceof long[]) {
            long[] lArray = (long[])objectArray[0];
            int n5 = 0;
            while (n5 < lArray.length) {
                dArray[n++] = lArray[n5++];
            }
        } else if (objectArray[0] instanceof float[]) {
            float[] fArray = (float[])objectArray[0];
            int n6 = 0;
            while (n6 < fArray.length) {
                dArray[n++] = fArray[n6++];
            }
        } else if (objectArray[0] instanceof double[]) {
            double[] dArray2 = (double[])objectArray[0];
            int n7 = 0;
            while (n7 < dArray2.length) {
                dArray[n++] = dArray2[n7++];
            }
        } else {
            throw new VisADException("type '" + objectArray[0].getClass().getName() + "' not handled");
        }
        return n;
    }

    private double[][] buildBTRange(BinaryTableHDU binaryTableHDU) throws VisADException {
        int n = binaryTableHDU.getNumRows();
        int n2 = binaryTableHDU.getNumColumns();
        double[][] dArray = new double[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            Object[] objectArray;
            try {
                objectArray = binaryTableHDU.getColumn(n3).getData();
            }
            catch (FitsException fitsException) {
                throw new VisADException("Failed to get column " + n3 + " type: " + fitsException.getMessage());
            }
            if (objectArray instanceof byte[][]) {
                n4 = this.copyColumn((byte[][])objectArray, dArray[n3], 0);
            } else if (objectArray instanceof short[][]) {
                n4 = this.copyColumn((short[][])objectArray, dArray[n3], 0);
            } else if (objectArray instanceof int[][]) {
                n4 = this.copyColumn((int[][])objectArray, dArray[n3], 0);
            } else if (objectArray instanceof long[][]) {
                n4 = this.copyColumn((long[][])objectArray, dArray[n3], 0);
            } else if (objectArray instanceof float[][]) {
                n4 = this.copyColumn((float[][])objectArray, dArray[n3], 0);
            } else if (objectArray instanceof double[][]) {
                n4 = this.copyColumn((double[][])objectArray, dArray[n3], 0);
            } else {
                String string;
                try {
                    string = binaryTableHDU.getColumnFITSType(n3);
                }
                catch (FitsException fitsException) {
                    string = "?Unknown FITS type?";
                }
                System.err.println("FitsAdapter.buildBTRange: Faking values for column #" + n3 + " (" + string + "=>" + objectArray.getClass().getName() + ")");
                int n5 = n3;
                n4 = 0;
                while (n4 < n) {
                    dArray[n5][n4] = Double.NaN;
                    ++n4;
                }
            }
            if (n4 < n) {
                int n6 = n3;
                System.err.println("FitsAdapter.buildBTRange: Column " + n3 + " was short " + (n - n4) + " of " + n + " rows");
                while (n4 < n) {
                    dArray[n6][n4++] = Double.NaN;
                }
            }
            ++n3;
        }
        return dArray;
    }

    private Data addBinaryTable(BinaryTableHDU binaryTableHDU) throws FitsException, VisADException, RemoteException {
        Object object;
        Object object2;
        int[] nArray = binaryTableHDU.getAxes();
        if (nArray == null) {
            throw new FitsException("Couldn't get binary table axes");
        }
        if (nArray.length != 2) {
            throw new FitsException("Not a two-dimensional binary table");
        }
        int n = binaryTableHDU.getNumColumns();
        RealType realType = RealType.getRealType("index", null, null);
        boolean bl = false;
        RealType[] realTypeArray = new RealType[n];
        int n2 = 0;
        while (n2 < n) {
            object2 = binaryTableHDU.getColumnName(n2);
            if (object2 == null) {
                object2 = "Column" + n2;
            }
            if (((String)(object = binaryTableHDU.getColumnFITSType(n2))).startsWith("A") || ((String)object).endsWith("A")) {
                bl = true;
            }
            realTypeArray[n2] = RealType.getRealType((String)object2, null, null);
            ++n2;
        }
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        object2 = new FunctionType(realType, realTupleType);
        object = new Integer1DSet(binaryTableHDU.getNumRows());
        FlatField flatField = new FlatField((FunctionType)object2, (Set)object);
        flatField.setSamples(this.buildBTRange(binaryTableHDU));
        return flatField;
    }

    private Data convertHDU(BasicHDU basicHDU) throws FitsException, VisADException, RemoteException {
        if (basicHDU instanceof ImageHDU) {
            return this.addImage((ImageHDU)basicHDU);
        }
        if (basicHDU instanceof PrimaryHDU) {
            return this.addPrimary((PrimaryHDU)basicHDU);
        }
        if (basicHDU instanceof BinaryTableHDU) {
            return this.addBinaryTable((BinaryTableHDU)basicHDU);
        }
        return null;
    }

    public void buildData() {
        Vector<Data> vector = new Vector<Data>();
        int n = this.stack == null ? 0 : this.stack.depth();
        int n2 = 0;
        while (true) {
            try {
                BasicHDU basicHDU = this.fits.getHDU(n2);
                if (basicHDU == null) break;
                Data data = this.convertHDU(basicHDU);
                if (data != null) {
                    vector.addElement(data);
                }
            }
            catch (Exception exception) {
                if (this.stack == null) {
                    this.stack = new ExceptionStack(exception);
                }
                this.stack.addException(exception);
                if (this.stack.depth() > n + 10) break;
            }
            ++n2;
        }
        if (vector.size() == 0) {
            this.data = null;
        } else {
            this.data = new Data[vector.size()];
            n2 = 0;
            while (n2 < this.data.length) {
                this.data[n2] = (Data)vector.elementAt(n2);
                ++n2;
            }
        }
    }

    public void clearExceptionStack() {
        this.stack = null;
    }

    Data[] getData() throws ExceptionStack, RemoteException, VisADException {
        if (this.data == null) {
            this.buildData();
            if (this.data == null) {
                throw new VisADException("No data");
            }
        }
        if (this.stack != null) {
            throw this.stack;
        }
        return this.data;
    }

    public void save(String string, Data data, boolean bl) throws IOException, RemoteException, VisADException {
        File file = new File(string);
        if (file.exists()) {
            throw new IllegalArgumentException("File \"" + string + "\" exists");
        }
        TourInspector tourInspector = new TourInspector(bl);
        FitsTourGuide fitsTourGuide = new FitsTourGuide(data, tourInspector);
        tourInspector = null;
        Fits fits = new Fits();
        TourWriter tourWriter = new TourWriter(bl, fits);
        fitsTourGuide = new FitsTourGuide(data, tourWriter);
        tourWriter = null;
        fitsTourGuide = null;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        try {
            fits.write(bufferedOutputStream);
        }
        catch (FitsException fitsException) {
            throw new VisADException(fitsException.getClass().getName() + "(" + fitsException.getMessage() + ")");
        }
        bufferedOutputStream.close();
    }

    public FitsAdapter() throws VisADException {
    }

    public FitsAdapter(String string) throws VisADException {
        this();
        try {
            this.fits = new Fits(string);
        }
        catch (FitsException fitsException) {
            throw new VisADException(fitsException.getClass().getName() + "(" + fitsException.getMessage() + ")");
        }
    }

    public FitsAdapter(URL uRL) throws VisADException {
        this();
        try {
            this.fits = new Fits(uRL);
        }
        catch (FitsException fitsException) {
            throw new VisADException(fitsException.getClass().getName() + "(" + fitsException.getMessage() + ")");
        }
    }
}

