/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import nom.tam.fits.BadHeaderException;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.ExtensionHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.PrimaryHDU;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.TruncatedFileException;

public class DumpHeader {
    private static void dumpBasic(PrintStream printStream, String string, BasicHDU basicHDU) {
        double d;
        double d2;
        String string2;
        String string3;
        double d3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        Date date;
        String string9;
        double d4;
        double d5;
        int n;
        int n2;
        Object object;
        try {
            int n3 = basicHDU.getBitPix();
            switch (n3) {
                case 8: {
                    object = "byte";
                    break;
                }
                case 16: {
                    object = "short";
                    break;
                }
                case 32: {
                    object = "int";
                    break;
                }
                case -32: {
                    object = "float";
                    break;
                }
                case -64: {
                    object = "double";
                    break;
                }
                default: {
                    object = "?" + n3 + "?";
                    break;
                }
            }
            printStream.println(string + "bitpix " + (String)object);
        }
        catch (FitsException fitsException) {
            printStream.println(string + "bitpix *** " + fitsException.getMessage());
        }
        try {
            object = basicHDU.getAxes();
        }
        catch (FitsException fitsException) {
            System.err.println("Bad axes: " + fitsException.getMessage());
            object = null;
        }
        if (object != null) {
            printStream.print(string + "axes ");
            int n4 = 0;
            while (n4 < ((Object)object).length) {
                printStream.print((n4 == 0 ? "" : "x") + (int)object[n4]);
                ++n4;
            }
            printStream.println("");
        }
        if ((n2 = basicHDU.getParameterCount()) != 0) {
            printStream.println(string + "paramCount " + n2);
        }
        if ((n = basicHDU.getGroupCount()) != 1) {
            printStream.println(string + "groupCount " + n);
        }
        if ((d5 = basicHDU.getBZero()) != 0.0) {
            printStream.println(string + "bzero " + d5);
        }
        if ((d4 = basicHDU.getBScale()) != 1.0) {
            printStream.println(string + "bscale " + d4);
        }
        if ((string9 = basicHDU.getBUnit()) != null) {
            printStream.println(string + "bunit " + string9);
        }
        try {
            int n5 = basicHDU.getBlankValue();
            printStream.println(string + "blank " + n5);
        }
        catch (FitsException fitsException) {
            // empty catch block
        }
        Date date2 = basicHDU.getCreationDate();
        if (date2 != null) {
            printStream.println(string + "creation date " + date2);
        }
        if ((date = basicHDU.getObservationDate()) != null) {
            printStream.println(string + "observation date " + date);
        }
        if ((string8 = basicHDU.getOrigin()) != null) {
            printStream.println(string + "origin " + string8);
        }
        if ((string7 = basicHDU.getTelescope()) != null) {
            printStream.println(string + "telescope " + string7);
        }
        if ((string6 = basicHDU.getInstrument()) != null) {
            printStream.println(string + "instrument " + string6);
        }
        if ((string5 = basicHDU.getObserver()) != null) {
            printStream.println(string + "observer " + string5);
        }
        if ((string4 = basicHDU.getObject()) != null) {
            printStream.println(string + "object " + string4);
        }
        if ((d3 = basicHDU.getEquinox()) != -1.0) {
            printStream.println(string + "equinox " + d3);
        }
        if ((string3 = basicHDU.getAuthor()) != null) {
            printStream.println(string + "author " + string3);
        }
        if ((string2 = basicHDU.getReference()) != null) {
            printStream.println(string + "reference " + string2);
        }
        if ((d2 = basicHDU.getMaximumValue()) != 0.0) {
            printStream.println(string + "maximum value " + d2);
        }
        if ((d = basicHDU.getMinimumValue()) != 0.0) {
            printStream.println(string + "minimum value " + d);
        }
    }

    private static void dumpPrimary(PrintStream printStream, String string, PrimaryHDU primaryHDU) throws IOException {
        DumpHeader.dumpBasic(printStream, string, primaryHDU);
        Data data = primaryHDU.getData();
    }

    private static void dumpBinaryTable(PrintStream printStream, String string, BinaryTableHDU binaryTableHDU) {
        int n = binaryTableHDU.getNumColumns();
        if (n == 0) {
            printStream.println(string + "No columns");
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            String string2;
            String string3;
            try {
                string3 = binaryTableHDU.getColumnName(n2);
                string2 = binaryTableHDU.getColumnFITSType(n2);
            }
            catch (FitsException fitsException) {
                break;
            }
            printStream.println(string + n2 + ": " + string3 + " = " + string2);
            ++n2;
        }
    }

    private static void dumpExtension(PrintStream printStream, String string, ExtensionHDU extensionHDU) throws IOException {
        Object object;
        int n;
        int n2;
        DumpHeader.dumpBasic(printStream, string, extensionHDU);
        String string2 = extensionHDU.getExtensionName();
        if (string2 != null) {
            printStream.println(string + "name " + string2);
        }
        if ((n2 = extensionHDU.getExtensionVersion()) != 1) {
            printStream.println(string + "version " + n2);
        }
        if ((n = extensionHDU.getExtensionLevel()) != 1) {
            printStream.println(string + "level " + n);
        }
        if (extensionHDU instanceof BinaryTableHDU) {
            printStream.println(string + "Binary Table:");
            DumpHeader.dumpBinaryTable(printStream, string + string, (BinaryTableHDU)extensionHDU);
        } else {
            try {
                object = extensionHDU.getExtensionType();
                if (object == null) {
                    printStream.println(string + "Null extension type");
                } else {
                    printStream.println(string + "type " + (String)object);
                }
            }
            catch (FitsException fitsException) {
                printStream.println(string + string + "Bad extension type: " + fitsException.getMessage());
            }
        }
        object = extensionHDU.getData();
    }

    private static void dumpImage(PrintStream printStream, String string, ImageHDU imageHDU) throws IOException {
        DumpHeader.dumpBasic(printStream, string, imageHDU);
        printStream.println(string + "...");
        Data data = imageHDU.getData();
    }

    private static void dumpRandomGroups(PrintStream printStream, String string, RandomGroupsHDU randomGroupsHDU) throws IOException {
        DumpHeader.dumpBasic(printStream, string, randomGroupsHDU);
        printStream.println(string + "...");
        Data data = randomGroupsHDU.getData();
    }

    public static void dump(PrintStream printStream, String string) throws FitsException, IOException {
        Fits fits;
        try {
            fits = new Fits(string);
        }
        catch (FitsException fitsException) {
            System.err.println("Couldn't open \"" + string + "\": " + fitsException.getMessage());
            return;
        }
        printStream.println(string + ":");
        int n = 0;
        while (true) {
            block19: {
                BasicHDU basicHDU;
                try {
                    basicHDU = fits.readHDU();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    System.err.println("  *** Out of memory for HDU #" + n);
                    outOfMemoryError.printStackTrace(System.err);
                    break;
                }
                catch (TruncatedFileException truncatedFileException) {
                    System.err.println("  *** File truncated at HDU #" + n + " (" + truncatedFileException.getMessage() + ")");
                    break;
                }
                catch (IOException iOException) {
                    System.err.println("  *** I/O error at HDU #" + n + " (" + iOException.getMessage() + ")");
                    break;
                }
                catch (BadHeaderException badHeaderException) {
                    System.err.println("  *** HDU #" + n + " threw " + badHeaderException.getMessage());
                    break block19;
                }
                catch (FitsException fitsException) {
                    System.err.println("  *** HDU #" + n + " threw " + fitsException.getMessage());
                    break block19;
                }
                if (basicHDU == null) break;
                String string2 = "\t";
                if (basicHDU instanceof PrimaryHDU) {
                    if (n == 0) {
                        printStream.println(string2 + "Primary:");
                    } else {
                        printStream.println(string2 + "Primary " + n + ":");
                    }
                    printStream.flush();
                    DumpHeader.dumpPrimary(printStream, string2 + string2, (PrimaryHDU)basicHDU);
                } else if (basicHDU instanceof ExtensionHDU) {
                    printStream.println(string2 + "Extension " + n + ":");
                    printStream.flush();
                    DumpHeader.dumpExtension(printStream, string2 + string2, (ExtensionHDU)basicHDU);
                } else if (basicHDU instanceof ImageHDU) {
                    printStream.println(string2 + "Image " + n + ":");
                    printStream.flush();
                    DumpHeader.dumpImage(printStream, string2 + string2, (ImageHDU)basicHDU);
                } else if (basicHDU instanceof RandomGroupsHDU) {
                    printStream.println(string2 + "RandomGroups " + n + ":");
                    printStream.flush();
                    DumpHeader.dumpRandomGroups(printStream, string2 + string2, (RandomGroupsHDU)basicHDU);
                } else {
                    throw new FitsException("Unknown header found: " + basicHDU);
                }
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            try {
                DumpHeader.dump(System.out, stringArray[n]);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryError.printStackTrace(System.out);
            }
            catch (FitsException fitsException) {
                fitsException.printStackTrace(System.out);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
            ++n;
        }
    }
}

