/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DArray;
import dods.dap.DBoolean;
import dods.dap.DByte;
import dods.dap.DFloat32;
import dods.dap.DFloat64;
import dods.dap.DGrid;
import dods.dap.DInt16;
import dods.dap.DInt32;
import dods.dap.DList;
import dods.dap.DSequence;
import dods.dap.DString;
import dods.dap.DStructure;
import dods.dap.DUInt16;
import dods.dap.DUInt32;
import dods.dap.PrimitiveVector;
import java.rmi.RemoteException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.ArrayVariableAdapter;
import visad.data.dods.BooleanVariableAdapter;
import visad.data.dods.ByteVariableAdapter;
import visad.data.dods.Float32VariableAdapter;
import visad.data.dods.Float64VariableAdapter;
import visad.data.dods.GridVariableAdapter;
import visad.data.dods.GridVariableMapAdapter;
import visad.data.dods.Int16VariableAdapter;
import visad.data.dods.Int32VariableAdapter;
import visad.data.dods.ListVariableAdapter;
import visad.data.dods.SequenceVariableAdapter;
import visad.data.dods.StringVariableAdapter;
import visad.data.dods.StructureVariableAdapter;
import visad.data.dods.UInt16VariableAdapter;
import visad.data.dods.UInt32VariableAdapter;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VectorAdapter;
import visad.data.dods.VectorAdapterFactory;

public class VariableAdapterFactory {
    private static final VariableAdapterFactory instance = new VariableAdapterFactory();
    private static final VectorAdapterFactory vectorAdapterFactory = VectorAdapterFactory.vectorAdapterFactory();

    public static VariableAdapterFactory variableAdapterFactory() {
        return instance;
    }

    public VariableAdapter variableAdapter(BaseType baseType, DAS dAS) throws BadFormException, VisADException, RemoteException {
        VariableAdapter variableAdapter;
        if (baseType instanceof DString) {
            variableAdapter = this.stringVariableAdapter((DString)baseType, dAS);
        } else if (baseType instanceof DBoolean) {
            variableAdapter = this.booleanVariableAdapter((DBoolean)baseType, dAS);
        } else if (baseType instanceof DByte) {
            variableAdapter = this.byteVariableAdapter((DByte)baseType, dAS);
        } else if (baseType instanceof DUInt16) {
            variableAdapter = this.uInt16VariableAdapter((DUInt16)baseType, dAS);
        } else if (baseType instanceof DInt16) {
            variableAdapter = this.int16VariableAdapter((DInt16)baseType, dAS);
        } else if (baseType instanceof DUInt32) {
            variableAdapter = this.uInt32VariableAdapter((DUInt32)baseType, dAS);
        } else if (baseType instanceof DInt32) {
            variableAdapter = this.int32VariableAdapter((DInt32)baseType, dAS);
        } else if (baseType instanceof DFloat32) {
            variableAdapter = this.float32VariableAdapter((DFloat32)baseType, dAS);
        } else if (baseType instanceof DFloat64) {
            variableAdapter = this.float64VariableAdapter((DFloat64)baseType, dAS);
        } else if (baseType instanceof DStructure) {
            variableAdapter = this.structureVariableAdapter((DStructure)baseType, dAS);
        } else if (baseType instanceof DList) {
            variableAdapter = this.listVariableAdapter((DList)baseType, dAS);
        } else if (baseType instanceof DSequence) {
            variableAdapter = this.sequenceVariableAdapter((DSequence)baseType, dAS);
        } else if (baseType instanceof DArray) {
            variableAdapter = this.arrayVariableAdapter((DArray)baseType, dAS);
        } else if (baseType instanceof DGrid) {
            variableAdapter = this.gridVariableAdapter((DGrid)baseType, dAS);
        } else {
            throw new BadFormException(this.getClass().getName() + ".variableAdapter(...): " + "Unknown DODS type: " + baseType.getTypeName());
        }
        return variableAdapter;
    }

    public StringVariableAdapter stringVariableAdapter(DString dString, DAS dAS) throws VisADException, RemoteException {
        return StringVariableAdapter.stringVariableAdapter(dString, dAS);
    }

    public BooleanVariableAdapter booleanVariableAdapter(DBoolean dBoolean, DAS dAS) throws VisADException, RemoteException {
        return BooleanVariableAdapter.booleanVariableAdapter(dBoolean, dAS);
    }

    public ByteVariableAdapter byteVariableAdapter(DByte dByte, DAS dAS) throws VisADException, RemoteException {
        return ByteVariableAdapter.byteVariableAdapter(dByte, dAS);
    }

    public UInt16VariableAdapter uInt16VariableAdapter(DUInt16 dUInt16, DAS dAS) throws VisADException, RemoteException {
        return UInt16VariableAdapter.uInt16VariableAdapter(dUInt16, dAS);
    }

    public Int16VariableAdapter int16VariableAdapter(DInt16 dInt16, DAS dAS) throws VisADException, RemoteException {
        return Int16VariableAdapter.int16VariableAdapter(dInt16, dAS);
    }

    public UInt32VariableAdapter uInt32VariableAdapter(DUInt32 dUInt32, DAS dAS) throws VisADException, RemoteException {
        return UInt32VariableAdapter.uInt32VariableAdapter(dUInt32, dAS);
    }

    public Int32VariableAdapter int32VariableAdapter(DInt32 dInt32, DAS dAS) throws VisADException, RemoteException {
        return Int32VariableAdapter.int32VariableAdapter(dInt32, dAS);
    }

    public Float32VariableAdapter float32VariableAdapter(DFloat32 dFloat32, DAS dAS) throws VisADException, RemoteException {
        return Float32VariableAdapter.float32VariableAdapter(dFloat32, dAS);
    }

    public Float64VariableAdapter float64VariableAdapter(DFloat64 dFloat64, DAS dAS) throws VisADException, RemoteException {
        return Float64VariableAdapter.float64VariableAdapter(dFloat64, dAS);
    }

    public StructureVariableAdapter structureVariableAdapter(DStructure dStructure, DAS dAS) throws VisADException, RemoteException {
        return StructureVariableAdapter.structureVariableAdapter(dStructure, dAS, this);
    }

    public ListVariableAdapter listVariableAdapter(DList dList, DAS dAS) throws VisADException, RemoteException {
        return ListVariableAdapter.listVariableAdapter(dList, dAS, this);
    }

    public SequenceVariableAdapter sequenceVariableAdapter(DSequence dSequence, DAS dAS) throws VisADException, RemoteException {
        return SequenceVariableAdapter.sequenceVariableAdapter(dSequence, dAS, this);
    }

    public ArrayVariableAdapter arrayVariableAdapter(DArray dArray, DAS dAS) throws VisADException, RemoteException {
        return ArrayVariableAdapter.arrayVariableAdapter(dArray, dAS, this);
    }

    public GridVariableAdapter gridVariableAdapter(DGrid dGrid, DAS dAS) throws VisADException, RemoteException {
        return GridVariableAdapter.gridVariableAdapter(dGrid, dAS, this);
    }

    public GridVariableMapAdapter gridVariableMapAdapter(DArray dArray, DAS dAS) throws VisADException, RemoteException {
        return GridVariableMapAdapter.gridVariableMapAdapter(dArray, dAS, this);
    }

    public VectorAdapter vectorAdapter(PrimitiveVector primitiveVector, DAS dAS) throws VisADException, RemoteException {
        return vectorAdapterFactory.vectorAdapter(primitiveVector, dAS, this);
    }

    protected VariableAdapterFactory() {
    }
}

