/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.Attribute;
import dods.dap.AttributeTable;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Real;
import visad.RealType;
import visad.SimpleSet;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.AttributeAdapterFactory;
import visad.data.dods.ByteValuator;
import visad.data.dods.Float32Valuator;
import visad.data.dods.Float64Valuator;
import visad.data.dods.Int16Valuator;
import visad.data.dods.Int32Valuator;
import visad.data.dods.UByteValuator;
import visad.data.dods.UInt16Valuator;
import visad.data.dods.UInt32Valuator;
import visad.data.in.OffsetUnpacker;
import visad.data.in.ScaleAndOffsetUnpacker;
import visad.data.in.ScaleUnpacker;
import visad.data.in.ValueRanger;
import visad.data.in.ValueUnpacker;
import visad.data.in.ValueVetter;

public abstract class Valuator {
    protected final ValueVetter vetter;
    protected final ValueUnpacker unpacker;
    protected final ValueRanger ranger;

    public static Valuator valuator(AttributeTable attributeTable, int n) throws BadFormException, VisADException, RemoteException {
        Valuator valuator;
        switch (n) {
            case 3: {
                valuator = Valuator.valueRanger(attributeTable).getMin() >= 0.0 ? UByteValuator.valuator(attributeTable) : ByteValuator.valuator(attributeTable);
                break;
            }
            case 8: {
                valuator = Float32Valuator.valuator(attributeTable);
                break;
            }
            case 9: {
                valuator = Float64Valuator.valuator(attributeTable);
                break;
            }
            case 4: {
                valuator = Int16Valuator.valuator(attributeTable);
                break;
            }
            case 6: {
                valuator = Int32Valuator.valuator(attributeTable);
                break;
            }
            case 5: {
                valuator = UInt16Valuator.valuator(attributeTable);
                break;
            }
            case 7: {
                valuator = UInt32Valuator.valuator(attributeTable);
                break;
            }
            default: {
                throw new BadFormException("Valuator.valuator(AttributeTable,int): Unknown variable type: " + n);
            }
        }
        return valuator;
    }

    public abstract SimpleSet getRepresentationalSet(RealType var1) throws VisADException;

    public float process(float f) {
        return this.ranger.process(this.unpacker.process(this.vetter.process(f)));
    }

    public float[] process(float[] fArray) {
        return this.ranger.process(this.unpacker.process(this.vetter.process(fArray)));
    }

    public double process(double d) {
        return this.ranger.process(this.unpacker.process(this.vetter.process(d)));
    }

    public double[] process(double[] dArray) {
        return this.ranger.process(this.unpacker.process(this.vetter.process(dArray)));
    }

    protected static double decode(String string, AttributeTable attributeTable, int n) throws BadFormException, VisADException, RemoteException {
        double d = Double.NaN;
        Attribute attribute = attributeTable.getAttribute(string);
        if (attribute != null) {
            DataImpl dataImpl = AttributeAdapterFactory.attributeAdapterFactory().attributeAdapter(string, attribute).data(false);
            if (dataImpl instanceof Real && n == 0) {
                d = ((Real)dataImpl).getValue();
            } else if (dataImpl instanceof Gridded1DDoubleSet) {
                d = ((Gridded1DSet)dataImpl).indexToDouble(new int[]{n})[0][0];
            } else if (dataImpl instanceof Gridded1DSet) {
                d = ((Gridded1DSet)dataImpl).indexToValue(new int[]{n})[0][0];
            } else {
                System.err.println("ValueProcessor.decode(String,AttributeTable,int): Attribute \"" + string + "\" has non-numeric type: " + attribute.getTypeString());
            }
        }
        return d;
    }

    public static ValueVetter valueVetter(AttributeTable attributeTable) throws BadFormException, VisADException, RemoteException {
        double d = Double.NaN;
        double d2 = Double.NaN;
        if (attributeTable != null) {
            d = Valuator.decode("_FillValue", attributeTable, 0);
            d2 = Valuator.decode("missing_value", attributeTable, 0);
        }
        return ValueVetter.valueVetter(new double[]{d, d2});
    }

    public static ValueUnpacker valueUnpacker(AttributeTable attributeTable) throws BadFormException, VisADException, RemoteException {
        ValueUnpacker valueUnpacker;
        if (attributeTable == null) {
            valueUnpacker = ValueUnpacker.valueUnpacker();
        } else {
            double d = Valuator.decode("scale_factor", attributeTable, 0);
            double d2 = Valuator.decode("add_offset", attributeTable, 0);
            valueUnpacker = d == d && d != 1.0 && d2 == d2 && d2 != 0.0 ? ScaleAndOffsetUnpacker.scaleAndOffsetUnpacker(d, d2) : (d == d && d != 1.0 ? ScaleUnpacker.scaleUnpacker(d) : (d2 == d2 && d2 != 0.0 ? OffsetUnpacker.offsetUnpacker(d2) : ValueUnpacker.valueUnpacker()));
        }
        return valueUnpacker;
    }

    public static ValueRanger valueRanger(AttributeTable attributeTable) throws BadFormException, VisADException, RemoteException {
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        if (attributeTable != null) {
            if (attributeTable.getAttribute("valid_range") == null) {
                d = Valuator.decode("valid_min", attributeTable, 0);
                d2 = Valuator.decode("valid_max", attributeTable, 0);
            } else {
                d = Valuator.decode("valid_range", attributeTable, 0);
                d2 = Valuator.decode("valid_range", attributeTable, 1);
            }
        }
        return ValueRanger.valueRanger(d, d2);
    }

    protected Valuator(AttributeTable attributeTable) throws BadFormException, VisADException, RemoteException {
        this.vetter = Valuator.valueVetter(attributeTable);
        this.unpacker = Valuator.valueUnpacker(attributeTable);
        this.ranger = Valuator.valueRanger(attributeTable);
    }
}

