/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DStructure;
import dods.dap.NoSuchVariableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import visad.Data;
import visad.DataImpl;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.SimpleSet;
import visad.Tuple;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.Adapter;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;

public class StructureVariableAdapter
extends VariableAdapter {
    private final MathType mathType;
    private final VariableAdapter[] adapters;
    private final boolean isFlat;
    private final SimpleSet[] repSets;

    public static StructureVariableAdapter structureVariableAdapter(DStructure dStructure, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws BadFormException, VisADException, RemoteException {
        return new StructureVariableAdapter(dStructure, dAS, variableAdapterFactory);
    }

    public MathType getMathType() {
        return this.mathType;
    }

    public SimpleSet[] getRepresentationalSets(boolean bl) {
        return bl ? (SimpleSet[])this.repSets.clone() : this.repSets;
    }

    public DataImpl data(DStructure dStructure, boolean bl) throws BadFormException, VisADException, RemoteException {
        DataImpl dataImpl;
        try {
            if (this.adapters.length == 0) {
                dataImpl = null;
            } else if (this.adapters.length == 1) {
                dataImpl = this.adapters[0].data(dStructure.getVar(0), bl);
            } else if (this.isFlat) {
                Real[] realArray = new Real[this.adapters.length];
                int n = 0;
                while (n < this.adapters.length) {
                    realArray[n] = (Real)this.adapters[n].data(dStructure.getVar(n), bl);
                    ++n;
                }
                dataImpl = new RealTuple(realArray);
            } else {
                Data[] dataArray = new DataImpl[this.adapters.length];
                int n = 0;
                while (n < this.adapters.length) {
                    dataArray[n] = this.adapters[n].data(dStructure.getVar(n), bl);
                    ++n;
                }
                dataImpl = new Tuple(dataArray);
            }
        }
        catch (NoSuchVariableException noSuchVariableException) {
            throw new BadFormException(this.getClass().getName() + ".data(...): " + "DStructure is missing variable: " + noSuchVariableException);
        }
        return dataImpl;
    }

    private StructureVariableAdapter(DStructure dStructure, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws BadFormException, VisADException, RemoteException {
        ArrayList<SimpleSet> arrayList = new ArrayList<SimpleSet>();
        this.adapters = new VariableAdapter[dStructure.elementCount()];
        int n = 0;
        while (n < this.adapters.length) {
            BaseType baseType;
            try {
                baseType = dStructure.getVar(n);
            }
            catch (NoSuchVariableException noSuchVariableException) {
                throw new BadFormException(this.getClass().getName() + ".data(...): " + "DStructure is missing variable " + n + ": " + noSuchVariableException);
            }
            this.adapters[n] = variableAdapterFactory.variableAdapter(baseType, dAS);
            SimpleSet[] simpleSetArray = this.adapters[n].getRepresentationalSets(false);
            int n2 = 0;
            while (n2 < simpleSetArray.length) {
                arrayList.add(simpleSetArray[n2]);
                ++n2;
            }
            ++n;
        }
        this.mathType = VariableAdapter.mathType(this.adapters);
        this.isFlat = Adapter.isFlat(this.mathType);
        this.repSets = arrayList.toArray(new SimpleSet[0]);
    }
}

