/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DSequence;
import dods.dap.NoSuchVariableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SimpleSet;
import visad.Tuple;
import visad.TupleType;
import visad.VisADError;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FileAccessor;
import visad.data.FileFlatField;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;

public class SequenceVariableAdapter
extends VariableAdapter {
    private FunctionType funcType;
    private VariableAdapter[] adapters;
    private SimpleSet[] repSets;

    public static SequenceVariableAdapter sequenceVariableAdapter(DSequence dSequence, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws VisADException, RemoteException {
        return new SequenceVariableAdapter(dSequence, dAS, variableAdapterFactory);
    }

    public MathType getMathType() {
        return this.funcType;
    }

    public SimpleSet[] getRepresentationalSets(boolean bl) {
        return bl ? (SimpleSet[])this.repSets.clone() : this.repSets;
    }

    public DataImpl data(DSequence dSequence, boolean bl) throws VisADException, RemoteException {
        FieldImpl fieldImpl;
        Integer1DSet integer1DSet = new Integer1DSet(dSequence.getRowCount());
        if (this.funcType.getFlat()) {
            fieldImpl = new FileFlatField(new SequenceAccessor(integer1DSet, dSequence), this.getCacheStrategy());
        } else {
            fieldImpl = new FieldImpl(this.funcType, integer1DSet);
            this.setField(dSequence, fieldImpl, bl);
        }
        return fieldImpl;
    }

    protected void setField(DSequence dSequence, FieldImpl fieldImpl, boolean bl) throws VisADException, RemoteException {
        int n = fieldImpl.getLength();
        MathType mathType = this.funcType.getRange();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            Data[] dataArray;
            DataImpl dataImpl;
            Vector vector = dSequence.getRow(n2);
            if (this.adapters.length == 1) {
                dataImpl = this.adapters[0].data((BaseType)vector.get(0), bl);
            } else if (mathType instanceof RealTupleType) {
                dataArray = new Real[this.adapters.length];
                n3 = 0;
                while (n3 < dataArray.length) {
                    dataArray[n3] = (Real)this.adapters[n3].data((BaseType)vector.get(n3), bl);
                    ++n3;
                }
                dataImpl = new RealTuple((RealTupleType)mathType, (Real[])dataArray, null);
            } else {
                dataArray = new Data[this.adapters.length];
                n3 = 0;
                while (n3 < dataArray.length) {
                    dataArray[n3] = this.adapters[n3].data((BaseType)vector.get(n3), bl);
                    ++n3;
                }
                dataImpl = new Tuple((TupleType)mathType, dataArray);
            }
            fieldImpl.setSample(n2, (Data)dataImpl, false);
            ++n2;
        }
    }

    private SequenceVariableAdapter(DSequence dSequence, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws VisADException, RemoteException {
        int n = dSequence.elementCount();
        ArrayList<SimpleSet> arrayList = new ArrayList<SimpleSet>();
        this.adapters = new VariableAdapter[n];
        int n2 = 0;
        while (n2 < n) {
            BaseType baseType;
            try {
                baseType = dSequence.getVar(n2);
            }
            catch (NoSuchVariableException noSuchVariableException) {
                throw new BadFormException(this.getClass().getName() + ".data(DSequence,...): " + "Couldn't get sequence-variable " + n2);
            }
            this.adapters[n2] = variableAdapterFactory.variableAdapter(baseType, dAS);
            SimpleSet[] simpleSetArray = this.adapters[n2].getRepresentationalSets(false);
            int n3 = 0;
            while (n3 < simpleSetArray.length) {
                arrayList.add(simpleSetArray[n3]);
                ++n3;
            }
            ++n2;
        }
        this.funcType = new FunctionType(RealType.Generic, VariableAdapter.mathType(this.adapters));
        this.repSets = arrayList.toArray(new SimpleSet[0]);
    }

    protected class SequenceAccessor
    extends FileAccessor {
        private final SampledSet domain;
        private final DSequence sequence;

        public FunctionType getFunctionType() {
            return SequenceVariableAdapter.this.funcType;
        }

        public FlatField getFlatField() throws VisADException, RemoteException {
            FlatField flatField = new FlatField(SequenceVariableAdapter.this.funcType, (Set)this.domain, null, (Set[])SequenceVariableAdapter.this.repSets, null);
            SequenceVariableAdapter.this.setField(this.sequence, flatField, false);
            return flatField;
        }

        public void writeFlatField(double[][] dArray, FlatField flatField, int[] nArray) {
            throw new VisADError(this.getClass().getName() + ".writeFlatField(...): " + "Unimplemented method");
        }

        public double[][] readFlatField(FlatField flatField, int[] nArray) {
            throw new VisADError(this.getClass().getName() + ".readFlatField(...): " + "Unimplemented method");
        }

        public void writeFile(int[] nArray, Data data) {
            throw new VisADError(this.getClass().getName() + ".writeFile(...): " + "Unimplemented method");
        }

        public SequenceAccessor(SampledSet sampledSet, DSequence dSequence) {
            this.domain = sampledSet;
            this.sequence = dSequence;
        }
    }
}

