/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.DAS;
import dods.dap.DList;
import dods.dap.PrimitiveVector;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.SimpleSet;
import visad.VisADException;
import visad.data.FileFlatField;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;
import visad.data.dods.VectorAccessor;
import visad.data.dods.VectorAdapter;

public class ListVariableAdapter
extends VariableAdapter {
    private final FunctionType funcType;
    private final VectorAdapter vectorAdapter;

    public static ListVariableAdapter listVariableAdapter(DList dList, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws VisADException, RemoteException {
        return new ListVariableAdapter(dList, dAS, variableAdapterFactory);
    }

    public MathType getMathType() {
        return this.funcType;
    }

    public SimpleSet[] getRepresentationalSets(boolean bl) {
        return this.vectorAdapter.getRepresentationalSets(bl);
    }

    public DataImpl data(DList dList, boolean bl) throws VisADException, RemoteException {
        FieldImpl fieldImpl;
        Integer1DSet integer1DSet = new Integer1DSet(dList.getLength());
        PrimitiveVector primitiveVector = dList.getPrimitiveVector();
        if (this.funcType.getFlat()) {
            fieldImpl = new FileFlatField(new VectorAccessor(this.funcType, this.vectorAdapter, integer1DSet, primitiveVector), this.getCacheStrategy());
        } else {
            fieldImpl = new FieldImpl(this.funcType, integer1DSet);
            this.vectorAdapter.setField(primitiveVector, fieldImpl, bl);
        }
        return fieldImpl;
    }

    private ListVariableAdapter(DList dList, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws VisADException, RemoteException {
        this.vectorAdapter = variableAdapterFactory.vectorAdapter(dList.getPrimitiveVector(), dAS);
        this.funcType = new FunctionType(RealType.Generic, this.vectorAdapter.getMathType());
    }
}

