/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.DAS;
import dods.dap.DArray;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.WeakHashMap;
import visad.DataImpl;
import visad.GriddedSet;
import visad.MathType;
import visad.VisADException;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;
import visad.data.dods.VectorAdapter;

public class GridVariableMapAdapter
extends VariableAdapter {
    private static final Map setMap = new WeakHashMap();
    private final VectorAdapter vectorAdapter;

    public static GridVariableMapAdapter gridVariableMapAdapter(DArray dArray, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws VisADException, RemoteException {
        if (dArray.numDimensions() != 1) {
            throw new VisADException("visad.data.dods.GridVariableMapAdapter.gridVariableMapAdapter(...): Array not one-dimensional");
        }
        return new GridVariableMapAdapter(dArray, dAS, variableAdapterFactory);
    }

    public MathType getMathType() {
        return this.vectorAdapter.getMathType();
    }

    public DataImpl data(DArray dArray, boolean bl) throws VisADException, RemoteException {
        GriddedSet griddedSet = this.vectorAdapter.griddedSet(dArray.getPrimitiveVector());
        WeakReference weakReference = (WeakReference)setMap.get(griddedSet);
        if (weakReference == null) {
            setMap.put(griddedSet, new WeakReference<GriddedSet>(griddedSet));
        } else {
            GriddedSet griddedSet2 = (GriddedSet)weakReference.get();
            if (griddedSet2 == null) {
                setMap.put(griddedSet, new WeakReference<GriddedSet>(griddedSet));
            } else {
                griddedSet = griddedSet2;
            }
        }
        return griddedSet;
    }

    private GridVariableMapAdapter(DArray dArray, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws VisADException, RemoteException {
        this.vectorAdapter = variableAdapterFactory.vectorAdapter(dArray.getPrimitiveVector(), dAS);
    }
}

