/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DArray;
import dods.dap.DGrid;
import dods.dap.NoSuchVariableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.ProductSet;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.VisADError;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FileAccessor;
import visad.data.FileFlatField;
import visad.data.dods.Adapter;
import visad.data.dods.ArrayVariableAdapter;
import visad.data.dods.GridVariableMapAdapter;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;

public class GridVariableAdapter
extends VariableAdapter {
    private static RealTupleType latLonType;
    private static RealTupleType lonLatType;
    private ArrayVariableAdapter arrayAdapter;
    private FunctionType funcType;
    private boolean isFlat;
    private GridVariableMapAdapter[] domainAdapters;

    public static GridVariableAdapter gridVariableAdapter(DGrid dGrid, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws VisADException, RemoteException {
        GridVariableMapAdapter[] gridVariableMapAdapterArray;
        ArrayVariableAdapter arrayVariableAdapter;
        try {
            DArray dArray = (DArray)dGrid.getVar(0);
            int n = dArray.numDimensions();
            arrayVariableAdapter = variableAdapterFactory.arrayVariableAdapter(dArray, dAS);
            gridVariableMapAdapterArray = new GridVariableMapAdapter[n];
            int n2 = 1;
            while (n2 <= n) {
                dArray = (DArray)dGrid.getVar(n2);
                BaseType baseType = dArray.getPrimitiveVector().getTemplate();
                gridVariableMapAdapterArray[n - n2] = variableAdapterFactory.gridVariableMapAdapter(dArray, dAS);
                ++n2;
            }
        }
        catch (NoSuchVariableException noSuchVariableException) {
            throw new BadFormException("visad.data.dods.GridVariableAdapter.gridVariableAdapter(...): No such variable: " + noSuchVariableException);
        }
        return new GridVariableAdapter(gridVariableMapAdapterArray, arrayVariableAdapter);
    }

    public MathType getMathType() {
        return this.funcType;
    }

    public SimpleSet[] getRepresentationalSets(boolean bl) {
        return this.arrayAdapter.getRepresentationalSets(bl);
    }

    public DataImpl data(DGrid dGrid, boolean bl) throws VisADException, RemoteException {
        FieldImpl fieldImpl;
        try {
            Object object;
            SampledSet sampledSet;
            int n = this.domainAdapters.length;
            if (n == 1) {
                sampledSet = (SampledSet)this.domainAdapters[0].data((DArray)dGrid.getVar(1), bl);
            } else {
                object = new Gridded1DSet[n];
                int n2 = 0;
                while (n2 < n) {
                    object[n2] = (Gridded1DSet)this.domainAdapters[n2].data((DArray)dGrid.getVar(n - n2), bl);
                    ++n2;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                int n3 = 0;
                while (n3 < n) {
                    if (!(object[n3] instanceof LinearSet)) {
                        arrayList.add(object[n3++]);
                        continue;
                    }
                    int n4 = n3 + 1;
                    while (n4 < n && object[n4] instanceof LinearSet) {
                        ++n4;
                    }
                    int n5 = n4 - n3;
                    if (n5 == 1) {
                        arrayList.add(object[n3]);
                    } else {
                        RealType[] realTypeArray = new RealType[n5];
                        double[] dArray = new double[n5];
                        double[] dArray2 = new double[n5];
                        int[] nArray = new int[n5];
                        int n6 = 0;
                        while (n6 < n5) {
                            Linear1DSet linear1DSet = (Linear1DSet)object[n3 + n6];
                            realTypeArray[n6] = (RealType)((SetType)linear1DSet.getType()).getDomain().getComponent(0);
                            dArray[n6] = linear1DSet.getFirst();
                            dArray2[n6] = linear1DSet.getLast();
                            nArray[n6] = linear1DSet.getLength();
                            ++n6;
                        }
                        arrayList.add(LinearNDSet.create(new RealTupleType(realTypeArray), dArray, dArray2, nArray));
                    }
                    n3 = n4;
                }
                sampledSet = arrayList.size() == 1 ? (GriddedSet)arrayList.get(0) : new ProductSet((MathType)this.funcType.getDomain(), arrayList.toArray(new GriddedSet[0]));
            }
            object = (DArray)dGrid.getVar(0);
            if (this.isFlat) {
                fieldImpl = new FileFlatField(new GridAccessor(sampledSet, (DArray)object), this.getCacheStrategy());
            } else {
                fieldImpl = new FieldImpl(this.funcType, sampledSet);
                this.arrayAdapter.setField((DArray)object, fieldImpl, bl);
            }
        }
        catch (NoSuchVariableException noSuchVariableException) {
            throw new BadFormException(this.getClass().getName() + ".data(...): " + "No such variable: " + noSuchVariableException);
        }
        return fieldImpl;
    }

    private GridVariableAdapter(GridVariableMapAdapter[] gridVariableMapAdapterArray, ArrayVariableAdapter arrayVariableAdapter) throws BadFormException, VisADException, RemoteException {
        MathType mathType = arrayVariableAdapter.getFunctionType().getRange();
        this.funcType = new FunctionType(VariableAdapter.mathType(gridVariableMapAdapterArray), mathType);
        this.arrayAdapter = arrayVariableAdapter;
        this.isFlat = Adapter.isFlat(mathType);
        this.domainAdapters = gridVariableMapAdapterArray;
    }

    static {
        try {
            latLonType = new RealTupleType(RealType.Latitude, RealType.Longitude);
            lonLatType = new RealTupleType(RealType.Longitude, RealType.Latitude);
        }
        catch (Exception exception) {
            throw new VisADError("visad.data.dods.GridVariableAdapter.<clinit>: Couldn't initialize class: " + exception);
        }
    }

    protected class GridAccessor
    extends FileAccessor {
        private final SampledSet domain;
        private final DArray array;

        public FunctionType getFunctionType() {
            return GridVariableAdapter.this.funcType;
        }

        public FlatField getFlatField() throws VisADException, RemoteException {
            FlatField flatField = new FlatField(GridVariableAdapter.this.funcType, (Set)this.domain, null, (Set[])GridVariableAdapter.this.arrayAdapter.getRepresentationalSets(false), null);
            GridVariableAdapter.this.arrayAdapter.setField(this.array, flatField, false);
            return flatField;
        }

        public void writeFlatField(double[][] dArray, FlatField flatField, int[] nArray) {
            throw new VisADError(this.getClass().getName() + ".writeFlatField(...): " + "Unimplemented method");
        }

        public double[][] readFlatField(FlatField flatField, int[] nArray) {
            throw new VisADError(this.getClass().getName() + ".readFlatField(...): " + "Unimplemented method");
        }

        public void writeFile(int[] nArray, Data data) {
            throw new VisADError(this.getClass().getName() + ".writeFile(...): " + "Unimplemented method");
        }

        public GridAccessor(SampledSet sampledSet, DArray dArray) {
            this.domain = sampledSet;
            this.array = dArray;
        }
    }
}

