/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.DAS;
import dods.dap.Float64PrimitiveVector;
import dods.dap.PrimitiveVector;
import java.rmi.RemoteException;
import visad.FieldImpl;
import visad.FlatField;
import visad.Gridded1DDoubleSet;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.VisADException;
import visad.data.dods.Adapter;
import visad.data.dods.NumericVectorAdapter;
import visad.data.dods.Valuator;
import visad.data.dods.VariableAdapterFactory;
import visad.data.in.ArithProg;

public class Float64VectorAdapter
extends NumericVectorAdapter {
    private final Valuator valuator;

    public final void setField(PrimitiveVector primitiveVector, FieldImpl fieldImpl, boolean bl) throws VisADException, RemoteException {
        if (fieldImpl.isFlatField()) {
            ((FlatField)fieldImpl).setSamples(new double[][]{this.getDoubles(primitiveVector, bl)}, false);
        } else {
            fieldImpl.setSamples(new double[][]{this.getDoubles(primitiveVector, bl)});
        }
    }

    public GriddedSet griddedSet(PrimitiveVector primitiveVector) throws VisADException, RemoteException {
        double[] dArray = this.getDoubles(primitiveVector, true);
        ArithProg arithProg = new ArithProg();
        arithProg.accumulate(dArray);
        return arithProg.isConsistent() ? new Linear1DSet(this.getMathType(), arithProg.getFirst(), arithProg.getLast(), (int)arithProg.getNumber()) : Gridded1DDoubleSet.create(this.getMathType(), dArray, null, null, null);
    }

    public double[] getDoubles(PrimitiveVector primitiveVector, boolean bl) {
        Float64PrimitiveVector float64PrimitiveVector = (Float64PrimitiveVector)primitiveVector;
        double[] dArray = new double[float64PrimitiveVector.getLength()];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = float64PrimitiveVector.getValue(n);
            ++n;
        }
        return this.valuator.process(dArray);
    }

    public Float64VectorAdapter(Float64PrimitiveVector float64PrimitiveVector, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws VisADException, RemoteException {
        super(float64PrimitiveVector, dAS, variableAdapterFactory);
        this.valuator = Valuator.valuator(Adapter.attributeTable(dAS, float64PrimitiveVector.getTemplate()), 9);
    }
}

