/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.AttributeTable;
import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DConnect;
import dods.dap.DODSException;
import dods.dap.parser.ParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.DataFactory;
import visad.data.in.DataInputSource;

public class DODSSource
implements DataInputSource {
    private DataFactory dataFactory;
    private DConnect dConnect;
    private DAS das;
    private AttributeTable globalTable;
    private Enumeration attrEnum;
    private Enumeration varEnum;

    public synchronized void open(String string) throws BadFormException, RemoteException, VisADException {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getFile();
            String string3 = null;
            int n = string2.lastIndexOf(63);
            if (n != -1) {
                string3 = string2.substring(n);
                string2 = string2.substring(0, n);
            }
            String string4 = ".dods";
            if (string2.toLowerCase().endsWith(string4)) {
                string2 = string2.substring(0, string2.length() - string4.length());
                string = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string3 == null ? string2 : string2 + "?" + string3).toString();
            }
            this.dConnect = new DConnect(string);
            this.das = this.dConnect.getDAS();
            this.globalTable = this.das.getAttributeTable("NC_GLOBAL");
            if (this.globalTable == null) {
                this.globalTable = this.das.getAttributeTable("nc_global");
            }
            if (this.globalTable != null) {
                this.attrEnum = this.globalTable.getNames();
            } else {
                this.attrEnum = null;
                this.varEnum = this.dConnect.getData(null).getVariables();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new BadFormException(malformedURLException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BadFormException(fileNotFoundException.getMessage());
        }
        catch (ParseException parseException) {
            throw new BadFormException(parseException.getMessage());
        }
        catch (DODSException dODSException) {
            throw new BadFormException(dODSException.getMessage());
        }
        catch (IOException iOException) {
            throw new BadFormException(iOException.getMessage());
        }
    }

    public synchronized DataImpl readData() throws VisADException, RemoteException {
        DataImpl dataImpl;
        if (this.attrEnum != null) {
            if (this.attrEnum.hasMoreElements()) {
                String string = (String)this.attrEnum.nextElement();
                dataImpl = this.dataFactory.data(string, this.globalTable.getAttribute(string), true);
            } else {
                this.attrEnum = null;
                try {
                    this.varEnum = this.dConnect.getData(null).getVariables();
                }
                catch (DODSException dODSException) {
                    throw new RemoteException(this.getClass().getName() + ".readData(): " + "Couldn't get DDS of DODS dataset: " + dODSException);
                }
                catch (ParseException parseException) {
                    throw new RemoteException(this.getClass().getName() + ".readData(): " + "Couldn't get DDS of DODS dataset: " + parseException);
                }
                catch (IOException iOException) {
                    throw new RemoteException(this.getClass().getName() + ".readData(): " + "Couldn't get DDS of DODS dataset: " + iOException);
                }
                dataImpl = this.readData();
            }
        } else if (this.varEnum != null) {
            if (this.varEnum.hasMoreElements()) {
                dataImpl = this.dataFactory.data((BaseType)this.varEnum.nextElement(), this.das, true);
            } else {
                dataImpl = null;
                this.varEnum = null;
                this.dConnect = null;
                this.das = null;
                this.globalTable = null;
            }
        } else {
            dataImpl = null;
        }
        return dataImpl;
    }

    protected synchronized DataImpl readAttribute(String string) throws BadFormException, VisADException, RemoteException {
        return this.dataFactory.data(string, this.globalTable.getAttribute(string), true);
    }

    protected synchronized DataImpl readVariable() throws BadFormException, VisADException, RemoteException {
        DataImpl dataImpl;
        if (this.varEnum == null) {
            dataImpl = null;
        } else if (!this.varEnum.hasMoreElements()) {
            this.varEnum = null;
            dataImpl = null;
        } else {
            dataImpl = this.dataFactory.data((BaseType)this.varEnum.nextElement(), this.das, true);
        }
        return dataImpl;
    }

    public DODSSource() {
        this(DataFactory.dataFactory());
    }

    public DODSSource(DataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }
}

