/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import visad.DataImpl;
import visad.data.dods.DODSForm;
import visad.jmet.DumpType;

public class DODSFormTest {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.err.println("Usage: [-v] DODS_dataset_spec");
            System.err.println("e.g. http://www.unidata.ucar.edu/cgi-bin/dods/nph-nc/packages/dods/data/nc_test/COADS-climatology.nc.dods");
        } else {
            String string;
            boolean bl;
            if (stringArray.length == 1) {
                bl = false;
                string = stringArray[0];
            } else {
                bl = stringArray[0].equals("-v");
                string = stringArray[1];
            }
            Runtime runtime = Runtime.getRuntime();
            long l = runtime.freeMemory();
            long l2 = runtime.totalMemory();
            long l3 = l2 - l;
            System.out.println("Before DODS total/free/used memory: " + l2 + "/" + l + "/" + l3);
            DODSForm dODSForm = DODSForm.dodsForm();
            try {
                DataImpl dataImpl = dODSForm.open(string);
                long l4 = runtime.freeMemory();
                long l5 = runtime.totalMemory();
                long l6 = l5 - l4;
                if (bl) {
                    System.out.println(dataImpl.toString());
                } else {
                    DumpType.dumpDataType(dataImpl, System.out);
                }
                System.out.println("After DODS total/free/used memory:  " + l5 + "/" + l4 + "/" + l6);
                System.out.println("Used difference = " + (l6 - l3));
            }
            catch (Exception exception) {
                System.err.println("Unable to open \"" + string + "\": " + exception.getMessage());
            }
        }
    }
}

