/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.in.Consolidator;
import visad.data.in.DataInputStream;
import visad.data.in.TimeFactorer;

public class DODSForm
extends Form
implements FormFileInformer {
    public static final String SUFFIX = "dods";
    private static final String periodSuffix = ".dods";
    private static final DODSForm instance = new DODSForm();
    private static final String sourceMessage = "DODS data-import capability is not available -- probably because the DODS package wasn't available when this package was compiled.  If you want DODS data-import capability, then you'll have to first obtain the DODS package (see <http://www.unidata.ucar.edu/packages/dods/index.html>) and then recompile this package.";
    private static final String contactMessage = ".  This exception should not have occurred.  Contact VisAD support.";
    private static /* synthetic */ Class class$Ljava$lang$String;

    public static DODSForm dodsForm() {
        return instance;
    }

    public void save(String string, Data data, boolean bl) throws BadFormException, IOException, RemoteException, VisADException {
        throw new UnimplementedException(this.getClass().getName() + ".save(String,Data,boolean): " + "Can't save data to a DODS server");
    }

    public void add(String string, Data data, boolean bl) throws BadFormException {
        throw new BadFormException(this.getClass().getName() + ".add(String,Data,boolean): " + "Can't add data to a DODS server");
    }

    public DataImpl open(String string) throws BadFormException, IOException, VisADException {
        DataImpl dataImpl;
        String string2 = this.getClass().getName() + ".open(String): ";
        try {
            Class<?> clazz = Class.forName(this.getClass().getPackage().getName() + ".DODSSource");
            DataInputStream dataInputStream = (DataInputStream)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            clazz.getMethod("open", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = DODSForm.class$("java.lang.String"))).invoke((Object)dataInputStream, string);
            dataImpl = new Consolidator(new TimeFactorer(dataInputStream)).readData();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new VisADException(string2 + classNotFoundException + ".  " + sourceMessage);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new VisADException(string2 + noSuchMethodException + contactMessage);
        }
        catch (SecurityException securityException) {
            throw new VisADException(string2 + securityException + contactMessage);
        }
        catch (InstantiationException instantiationException) {
            throw new VisADException(string2 + instantiationException + contactMessage);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new VisADException(string2 + illegalAccessException + contactMessage);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new VisADException(string2 + illegalArgumentException + contactMessage);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new VisADException(invocationTargetException.getTargetException().getMessage());
        }
        return dataImpl;
    }

    public DataImpl open(URL uRL) throws BadFormException, VisADException, IOException {
        return this.open(uRL.toString());
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public boolean isThisType(String string) {
        int n = string.lastIndexOf(63);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string.toLowerCase().endsWith(periodSuffix);
    }

    public boolean isThisType(byte[] byArray) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        return new String[]{SUFFIX};
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected DODSForm() {
        super("DODS");
    }
}

