/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.Attribute;
import java.rmi.RemoteException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.AttributeAdapter;
import visad.data.dods.ByteAttributeAdapter;
import visad.data.dods.ContainerAttributeAdapter;
import visad.data.dods.Float32AttributeAdapter;
import visad.data.dods.Float64AttributeAdapter;
import visad.data.dods.Int16AttributeAdapter;
import visad.data.dods.Int32AttributeAdapter;
import visad.data.dods.StringAttributeAdapter;
import visad.data.dods.UInt16AttributeAdapter;
import visad.data.dods.UInt32AttributeAdapter;
import visad.data.dods.UnknownAttributeAdapter;

public class AttributeAdapterFactory {
    private static final AttributeAdapterFactory instance = new AttributeAdapterFactory();

    public static AttributeAdapterFactory attributeAdapterFactory() {
        return instance;
    }

    public AttributeAdapter attributeAdapter(String string, Attribute attribute) throws BadFormException, VisADException, RemoteException {
        AttributeAdapter attributeAdapter;
        int n = attribute.getType();
        if (n == 10) {
            attributeAdapter = this.stringAdapter(string, attribute);
        } else if (n == 3) {
            attributeAdapter = this.byteAdapter(string, attribute);
        } else if (n == 4) {
            attributeAdapter = this.int16Adapter(string, attribute);
        } else if (n == 5) {
            attributeAdapter = this.uInt16Adapter(string, attribute);
        } else if (n == 6) {
            attributeAdapter = this.int32Adapter(string, attribute);
        } else if (n == 7) {
            attributeAdapter = this.uInt32Adapter(string, attribute);
        } else if (n == 8) {
            attributeAdapter = this.float32Adapter(string, attribute);
        } else if (n == 9) {
            attributeAdapter = this.float64Adapter(string, attribute);
        } else if (n == 2) {
            attributeAdapter = this.containerAdapter(string, attribute);
        } else if (n == 1) {
            attributeAdapter = this.unknownAdapter(string, attribute);
        } else {
            throw new BadFormException(this.getClass().getName() + ".attributeAdapter(): " + "Unknown DODS attribute type: " + attribute.getTypeString());
        }
        return attributeAdapter;
    }

    public StringAttributeAdapter stringAdapter(String string, Attribute attribute) throws VisADException, RemoteException {
        return new StringAttributeAdapter(string, attribute);
    }

    public ByteAttributeAdapter byteAdapter(String string, Attribute attribute) throws VisADException, RemoteException {
        return new ByteAttributeAdapter(string, attribute);
    }

    public Int16AttributeAdapter int16Adapter(String string, Attribute attribute) throws VisADException, RemoteException {
        return new Int16AttributeAdapter(string, attribute);
    }

    public UInt16AttributeAdapter uInt16Adapter(String string, Attribute attribute) throws VisADException, RemoteException {
        return new UInt16AttributeAdapter(string, attribute);
    }

    public Int32AttributeAdapter int32Adapter(String string, Attribute attribute) throws VisADException, RemoteException {
        return new Int32AttributeAdapter(string, attribute);
    }

    public UInt32AttributeAdapter uInt32Adapter(String string, Attribute attribute) throws VisADException, RemoteException {
        return new UInt32AttributeAdapter(string, attribute);
    }

    public Float32AttributeAdapter float32Adapter(String string, Attribute attribute) throws VisADException, RemoteException {
        return new Float32AttributeAdapter(string, attribute);
    }

    public Float64AttributeAdapter float64Adapter(String string, Attribute attribute) throws VisADException, RemoteException {
        return new Float64AttributeAdapter(string, attribute);
    }

    public ContainerAttributeAdapter containerAdapter(String string, Attribute attribute) throws VisADException, RemoteException {
        return new ContainerAttributeAdapter(string, attribute, this);
    }

    public UnknownAttributeAdapter unknownAdapter(String string, Attribute attribute) throws VisADException, RemoteException {
        return UnknownAttributeAdapter.unknownAttributeAdapter(string, attribute);
    }

    protected AttributeAdapterFactory() {
    }
}

