/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.DAS;
import dods.dap.DArray;
import dods.dap.PrimitiveVector;
import dods.dap.Server.InvalidParameterException;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.GriddedSet;
import visad.IntegerNDSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SimpleSet;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FileFlatField;
import visad.data.dods.Adapter;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;
import visad.data.dods.VectorAccessor;
import visad.data.dods.VectorAdapter;

public class ArrayVariableAdapter
extends VariableAdapter {
    private final FunctionType funcType;
    private final VectorAdapter vectorAdapter;

    public static ArrayVariableAdapter arrayVariableAdapter(DArray dArray, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws VisADException, RemoteException {
        return new ArrayVariableAdapter(dArray, dAS, variableAdapterFactory);
    }

    public MathType getMathType() {
        return this.funcType;
    }

    public FunctionType getFunctionType() {
        return this.funcType;
    }

    public SimpleSet[] getRepresentationalSets(boolean bl) {
        return this.vectorAdapter.getRepresentationalSets(bl);
    }

    public DataImpl data(DArray dArray, boolean bl) throws VisADException, RemoteException {
        Cloneable cloneable;
        RealTupleType realTupleType = this.funcType.getDomain();
        int n = realTupleType.getDimension();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n - 1 - n2;
            try {
                cloneable = dArray.getDimension(n2);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new BadFormException(this.getClass().getName() + ".data(DArray,...): " + "Couldn't get DArray dimension: " + invalidParameterException);
            }
            int n4 = cloneable.getStart();
            int n5 = cloneable.getStop();
            int n6 = cloneable.getStride();
            nArray[n3] = n4;
            nArray2[n3] = n5;
            nArray3[n3] = 1 + (n5 - n4) / n6;
            bl2 &= n6 == 1 && n4 == 0 || n6 == -1 && n5 == 0;
            ++n2;
        }
        GriddedSet griddedSet = bl2 ? IntegerNDSet.create(realTupleType, nArray3) : (SampledSet)((Object)LinearNDSet.create(realTupleType, this.doubleArray(nArray), this.doubleArray(nArray2), nArray3));
        PrimitiveVector primitiveVector = dArray.getPrimitiveVector();
        if (this.vectorAdapter.isFlat()) {
            cloneable = new FileFlatField(new VectorAccessor(this.funcType, this.vectorAdapter, griddedSet, primitiveVector), this.getCacheStrategy());
        } else {
            cloneable = new FieldImpl(this.funcType, griddedSet);
            this.vectorAdapter.setField(primitiveVector, (FieldImpl)cloneable, bl);
        }
        return cloneable;
    }

    public void setField(DArray dArray, FieldImpl fieldImpl, boolean bl) throws VisADException, RemoteException {
        this.vectorAdapter.setField(dArray.getPrimitiveVector(), fieldImpl, bl);
    }

    private double[] doubleArray(int[] nArray) {
        double[] dArray = new double[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            dArray[n] = nArray[n];
            ++n;
        }
        return dArray;
    }

    private ArrayVariableAdapter(DArray dArray, DAS dAS, VariableAdapterFactory variableAdapterFactory) throws VisADException, RemoteException {
        this.vectorAdapter = variableAdapterFactory.vectorAdapter(dArray.getPrimitiveVector(), dAS);
        int n = dArray.numDimensions();
        MathType[] mathTypeArray = new RealType[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                mathTypeArray[n - 1 - n2] = RealType.getRealType(dArray.getDimension(n2).getName() + "_ndx");
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new BadFormException(this.getClass().getName() + ".<init>: " + "Couldn't get DArray dimension: " + invalidParameterException);
            }
            ++n2;
        }
        this.funcType = new FunctionType(Adapter.mathType(mathTypeArray), this.vectorAdapter.getMathType());
    }
}

