/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.Attribute;
import dods.dap.AttributeTable;
import dods.dap.BaseType;
import dods.dap.DAS;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.CacheStrategy;
import visad.data.units.Parser;

public abstract class Adapter {
    private static final CacheStrategy cacheStrategy = new CacheStrategy();

    protected static String scalarName(String string) {
        return string.replace('.', '-').replace(' ', '_').replace('(', '<').replace(')', '>');
    }

    protected static boolean isFlat(MathType mathType) {
        return mathType instanceof RealType || mathType instanceof RealTupleType || mathType instanceof TupleType && ((TupleType)mathType).getFlat();
    }

    protected static RealType realType(BaseType baseType, DAS dAS) {
        return Adapter.realType(baseType.getName(), Adapter.attributeTable(dAS, baseType));
    }

    protected static RealType realType(BaseType baseType, AttributeTable attributeTable) {
        return Adapter.realType(baseType.getName(), attributeTable);
    }

    protected static RealType realType(String string, DAS dAS) {
        return Adapter.realType(string, Adapter.attributeTable(dAS, string));
    }

    protected static RealType realType(String string, AttributeTable attributeTable) {
        Unit unit;
        if (attributeTable == null) {
            unit = null;
        } else {
            Attribute attribute = attributeTable.getAttribute("units");
            if (attribute == null && (attribute = attributeTable.getAttribute("unit")) == null && (attribute = attributeTable.getAttribute("UNITS")) == null) {
                attribute = attributeTable.getAttribute("UNIT");
            }
            if (attribute == null) {
                unit = null;
            } else if (attribute.getType() != 10) {
                unit = null;
            } else {
                String string2 = attribute.getValueAt(0);
                if (string2.startsWith("\"") && string2.endsWith("\"")) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                try {
                    Parser.instance();
                    unit = Parser.parse(string2);
                }
                catch (Exception exception) {
                    System.err.println("visad.data.dods.Adapter.realType(String,...): Ignoring non-decodable unit-specification \"" + string2 + "\" of variable \"" + string + "\"");
                    unit = null;
                }
            }
        }
        return RealType.getRealType(Adapter.scalarName(string), unit);
    }

    protected static AttributeTable attributeTable(DAS dAS, BaseType baseType) {
        return dAS.getAttributeTable(baseType.getName());
    }

    protected static AttributeTable attributeTable(DAS dAS, String string) {
        return dAS.getAttributeTable(string);
    }

    protected static MathType mathType(MathType[] mathTypeArray) throws VisADException {
        MathType mathType;
        if (mathTypeArray.length == 0) {
            mathType = null;
        } else if (mathTypeArray.length == 1) {
            mathType = mathTypeArray[0];
        } else {
            boolean bl = true;
            int n = 0;
            while (n < mathTypeArray.length && bl) {
                bl &= mathTypeArray[n] instanceof RealType;
                ++n;
            }
            if (bl) {
                RealType[] realTypeArray = new RealType[mathTypeArray.length];
                int n2 = 0;
                while (n2 < realTypeArray.length) {
                    realTypeArray[n2] = (RealType)mathTypeArray[n2];
                    ++n2;
                }
                mathType = new RealTupleType(realTypeArray);
            } else {
                mathType = new TupleType(mathTypeArray);
            }
        }
        return mathType;
    }

    protected CacheStrategy getCacheStrategy() {
        return cacheStrategy;
    }
}

