/*
 * Decompiled with CFR 0.152.
 */
package visad.data.biorad;

import java.io.DataOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Data;
import visad.DataImpl;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SI;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.biorad.BioRadForm;

public class BioRadNote {
    public static final Unit micron = SI.meter.pow(-6);
    public static final Unit second = SI.second;
    public static final int NO_INFORMATION = 0;
    public static final int METADATA = 1;
    public static final int HORIZ_UNIT = 2;
    public static final int VERT_UNIT = 3;
    public static final int INVALID_NOTE = -1;
    static final int NOTE_TYPE_LIVE = 1;
    static final int NOTE_TYPE_FILE1 = 2;
    static final int NOTE_TYPE_NUMBER = 3;
    static final int NOTE_TYPE_USER = 4;
    static final int NOTE_TYPE_LINE = 5;
    static final int NOTE_TYPE_COLLECT = 6;
    static final int NOTE_TYPE_FILE2 = 7;
    static final int NOTE_TYPE_SCALEBAR = 8;
    static final int NOTE_TYPE_MERGE = 9;
    static final int NOTE_TYPE_THRUVIEW = 10;
    static final int NOTE_TYPE_ARROW = 11;
    static final int NOTE_TYPE_VARIABLE = 20;
    static final int NOTE_TYPE_STRUCTURE = 21;
    static final String[] noteNames = new String[]{"0", "LIVE", "FILE1", "NUMBER", "USER", "LINE", "COLLECT", "FILE2", "SCALEBAR", "MERGE", "THRUVIEW", "ARROW", "12", "13", "14", "15", "16", "17", "18", "19", "VARIABLE", "STRUCTURE"};
    static final int NOTE_STATUS_ALL = 256;
    static final int NOTE_STATUS_DISPLAY = 512;
    static final int NOTE_STATUS_POSITION = 1024;
    private static final int axt_D = 1;
    private static final int axt_T = 2;
    private static final int axt_A = 3;
    private static final int axt_I = 4;
    private static final int axt_M4 = 5;
    private static final int axt_R = 6;
    private static final int axt_LR = 7;
    private static final int axt_P = 8;
    private static final int axt_C = 9;
    private static final int axt_PHOTON = 10;
    private static final int axt_RGB = 11;
    private static final int axt_SEQ = 12;
    private static final int axt_6D = 13;
    private static final int axt_TC = 14;
    private static final int axt_S = 15;
    private static final int axt_LS = 16;
    private static final int axt_MASK = 255;
    private static final int axt_XY = 256;
    private static final int axt_WORD = 512;
    private static final RealType rt_level = RealType.getRealType("level");
    private static final RealType rt_num = RealType.getRealType("num");
    private static final RealType rt_status = RealType.getRealType("status");
    private static final RealType rt_type = RealType.getRealType("type");
    private static final RealType rt_x = RealType.getRealType("x");
    private static final RealType rt_y = RealType.getRealType("y");
    private static final TextType tt_text = TextType.getTextType("text");
    static final TupleType noteTuple = BioRadNote.makeNoteTuple();
    int level;
    int num;
    int status;
    int type;
    int x;
    int y;
    String text;
    Data metadata;
    double origin;
    double step;
    boolean time;

    private static TupleType makeNoteTuple() {
        try {
            if (rt_level == null) {
                System.out.println("rt_level is NULL!");
            }
            if (rt_num == null) {
                System.out.println("rt_num is NULL!");
            }
            if (rt_status == null) {
                System.out.println("rt_status is NULL!");
            }
            if (rt_type == null) {
                System.out.println("rt_type is NULL!");
            }
            if (rt_x == null) {
                System.out.println("rt_x is NULL!");
            }
            if (rt_y == null) {
                System.out.println("rt_y is NULL!");
            }
            if (tt_text == null) {
                System.out.println("tt_text is NULL!");
            }
            return new TupleType(new MathType[]{rt_level, rt_num, rt_status, rt_type, rt_x, rt_y, tt_text});
        }
        catch (VisADException visADException) {
            return null;
        }
    }

    public DataImpl getNoteData() {
        try {
            Data[] dataArray = new DataImpl[]{new Real(rt_level, (double)this.level), new Real(rt_num, (double)this.num), new Real(rt_status, (double)this.status), new Real(rt_type, (double)this.type), new Real(rt_x, (double)this.x), new Real(rt_y, (double)this.y), new Text(tt_text, this.text)};
            return new Tuple(noteTuple, dataArray, false);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasUnitInfo() {
        int n;
        if (this.type == 20 && (n = this.text.indexOf(" ")) >= 0) {
            String string = this.text.substring(0, n).trim();
            String string2 = this.text.substring(n + 1).trim();
            if (string.equals("AXIS_2") || string.equals("AXIS_3")) {
                return true;
            }
        }
        return false;
    }

    public int analyze() {
        if (this.type == 8) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.text);
            if (stringTokenizer.countTokens() != 4) {
                this.warn();
                return -1;
            }
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            int n = -1;
            int n2 = -1;
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (!string.equals("SCALEBAR") || !string2.equals("=") || n < 0 || n2 < 0) {
                this.warn();
                return -1;
            }
            return 0;
        }
        if (this.type == 10) {
            return -1;
        }
        if (this.type == 11) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.text);
            if (stringTokenizer.countTokens() != 6) {
                this.warn();
                return -1;
            }
            String string = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            int n = -1;
            int n3 = -1;
            int n4 = -1;
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
                n3 = Integer.parseInt(stringTokenizer.nextToken());
                n4 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String string4 = stringTokenizer.nextToken();
            if (!string.equals("ARROW") || !string3.equals("=") || n < 0 || n3 < 0 || n4 < 0 || !string4.equals("Fill") && !string4.equals("Outline")) {
                this.warn(string);
                return -1;
            }
            return 0;
        }
        if (this.type == 20) {
            int n = this.text.indexOf(" ");
            if (n < 0) {
                this.warn();
                return -1;
            }
            String string = this.text.substring(0, n).trim();
            String string5 = this.text.substring(n + 1).trim();
            if (string.equals("SCALE_FACTOR") || string.equals("LENS_MAGNIFICATION") || string.equals("RAMP_GAMMA1") || string.equals("RAMP_GAMMA2") || string.equals("RAMP_GAMMA3") || string.equals("RAMP1_MIN") || string.equals("RAMP2_MIN") || string.equals("RAMP3_MIN") || string.equals("RAMP1_MAX") || string.equals("RAMP2_MAX") || string.equals("RAMP3_MAX") || string.equals("PIC_FF_VERSION") || string.equals("Z_CORRECT_FACTOR") || string.equals("AXIS_0") || string.equals("AXIS_1") || string.equals("AXIS_4") || string.equals("AXIS_5") || string.equals("AXIS_6") || string.equals("AXIS_7") || string.equals("AXIS_8") || string.equals("AXIS_9") || string.equals("AXIS_21")) {
                double d;
                try {
                    d = Double.parseDouble(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    this.warn();
                    return -1;
                }
                this.metadata = new Real(RealType.getRealType(string), d);
                return 1;
            }
            if (string.equals("AXIS_2")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string5);
                if (stringTokenizer.countTokens() != 4) {
                    this.warn(string);
                    return -1;
                }
                int n5 = -1;
                int n6 = -1;
                int n7 = -1;
                try {
                    n5 = Integer.parseInt(stringTokenizer.nextToken());
                    n6 = Integer.parseInt(stringTokenizer.nextToken());
                    n7 = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n5 < 0 || n6 < 0 || n7 < 0) {
                    this.warn(string);
                    return -1;
                }
                String string6 = stringTokenizer.nextToken();
                if (n5 != 1) {
                    this.warn(string);
                    return -1;
                }
                this.origin = n6;
                this.step = n7;
                this.time = false;
                return 2;
            }
            if (string.equals("AXIS_3")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string5);
                if (stringTokenizer.countTokens() != 4) {
                    this.warn(string);
                    return -1;
                }
                int n8 = -1;
                int n9 = -1;
                int n10 = -1;
                try {
                    n8 = Integer.parseInt(stringTokenizer.nextToken());
                    n9 = Integer.parseInt(stringTokenizer.nextToken());
                    n10 = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n8 < 0 || n9 < 0 || n10 < 0) {
                    this.warn(string);
                    return -1;
                }
                String string7 = stringTokenizer.nextToken();
                if (n8 == 1) {
                    this.origin = n9;
                    this.step = n10;
                    this.time = false;
                    return 3;
                }
                if (n8 == 2) {
                    this.origin = n9;
                    this.step = n10;
                    this.time = true;
                    return 3;
                }
                this.warn();
                return -1;
            }
            this.warn(string);
            return -1;
        }
        if (this.type == 21) {
            return 0;
        }
        return 0;
    }

    public void write(DataOutputStream dataOutputStream, boolean bl) throws IOException {
        BioRadForm.writeShort(dataOutputStream, this.level);
        BioRadForm.writeInt(dataOutputStream, bl ? 1 : 0);
        BioRadForm.writeShort(dataOutputStream, this.num);
        BioRadForm.writeShort(dataOutputStream, this.status);
        BioRadForm.writeShort(dataOutputStream, this.type);
        BioRadForm.writeShort(dataOutputStream, this.x);
        BioRadForm.writeShort(dataOutputStream, this.y);
        BioRadForm.writeString(dataOutputStream, this.text, 80);
    }

    private void warn() {
        this.warn(null);
    }

    private void warn(String string) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl = (this.status & 0x100) != 0;
        boolean bl2 = (this.status & 0x200) != 0;
        boolean bl3 = (this.status & 0x400) != 0;
        stringBuffer.append("Note: level=" + this.level + ", num=" + this.num + ", status=");
        boolean bl4 = true;
        if (bl) {
            stringBuffer.append("NOTE_STATUS_ALL");
            bl4 = false;
        }
        if (bl2) {
            if (!bl4) {
                stringBuffer.append("|");
            }
            stringBuffer.append("NOTE_STATUS_DISPLAY");
            bl4 = false;
        }
        if (bl3) {
            if (!bl4) {
                stringBuffer.append("|");
            }
            stringBuffer.append("NOTE_STATUS_POSITION");
            bl4 = false;
        }
        if (bl4) {
            stringBuffer.append("NONE");
        }
        stringBuffer.append(", type=" + noteNames[this.type] + ", x=" + this.x + ", y=" + this.y + ", text=" + (this.text == null ? "null" : this.text.trim()));
        return stringBuffer.toString();
    }

    public static BioRadNote getUnitNote(Unit unit, Linear1DSet linear1DSet, boolean bl) {
        double d;
        double d2;
        if (unit == null || linear1DSet == null) {
            return null;
        }
        boolean bl2 = unit.isConvertible(second);
        if (!bl2 && !unit.isConvertible(micron)) {
            return null;
        }
        int n = bl2 ? 2 : 1;
        try {
            d2 = unit.toThat(linear1DSet.getFirst(), bl2 ? second : micron);
            d = unit.toThat(linear1DSet.getStep(), bl2 ? second : micron);
        }
        catch (UnitException unitException) {
            return null;
        }
        String string = "Calibration unknown";
        int n2 = 1;
        int n3 = 0;
        int n4 = 1280;
        int n5 = 20;
        int n6 = 0;
        int n7 = 0;
        String string2 = "AXIS_" + (bl ? "2" : "3") + " " + n + " " + d2 + " " + d + " " + string;
        return new BioRadNote(n2, n3, n4, n5, n6, n7, string2);
    }

    public BioRadNote(int n, int n2, int n3, int n4, int n5, int n6, String string) {
        this.level = n;
        this.num = n2;
        this.status = n3;
        this.type = n4;
        this.x = n5;
        this.y = n6;
        this.text = string;
    }
}

