/*
 * Decompiled with CFR 0.152.
 */
package visad.data.biorad;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import ucar.netcdf.RandomAccessFile;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SimpleSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.Unit;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.CacheStrategy;
import visad.data.DefaultFamily;
import visad.data.FileAccessor;
import visad.data.FileFlatField;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.biorad.BioRadNote;

public class BioRadForm
extends Form
implements FormFileInformer {
    private static CacheStrategy strategy = new CacheStrategy();
    static final boolean DEBUG = false;
    static final int DEBUG_LEVEL = 1;
    private static final int PIC_FILE_ID = 12345;
    private static final int MERGE_OFF = 0;
    private static final int MERGE_16 = 1;
    private static final int MERGE_ALTERNATE = 2;
    private static final int MERGE_COLUMN = 3;
    private static final int MERGE_ROW = 4;
    private static final int MERGE_MAXIMUM = 5;
    private static final int MERGE_OPT12 = 6;
    private static final int MERGE_OPT12_V2 = 7;
    private static final String[] mergeNames = new String[]{"MERGE_OFF", "MERGE_16", "MERGE_ALTERNATE", "MERGE_COLUMN", "MERGE_ROW", "MERGE_MAXIMUM", "MERGE_OPT12", "MERGE_OPT12_V2"};
    private static final int RED_LUT = 1;
    private static final int GREEN_LUT = 2;
    private static final int BLUE_LUT = 4;
    private static int num = 0;
    private static final RealType noteIndex = RealType.getRealType("NoteIndex");
    private static final RealType rt_ramp1_min = RealType.getRealType("ramp1_min");
    private static final RealType rt_ramp1_max = RealType.getRealType("ramp1_max");
    private static final RealType rt_byte_format = RealType.getRealType("byte_format");
    private static final TextType tt_name = TextType.getTextType("name");
    private static final RealType rt_ramp2_min = RealType.getRealType("ramp2_min");
    private static final RealType rt_ramp2_max = RealType.getRealType("ramp2_max");
    private static final RealType rt_lens = RealType.getRealType("lens");
    private static final RealType rt_mag_factor = RealType.getRealType("mag_factor");
    private static final String[] noteVarNames = new String[]{"SCALE_FACTOR", "LENS_MAGNIFICATION", "RAMP_GAMMA1", "RAMP_GAMMA2", "RAMP_GAMMA3", "RAMP1_MIN", "RAMP2_MIN", "RAMP3_MIN", "RAMP1_MAX", "RAMP2_MAX", "RAMP3_MAX", "PIC_FF_VERSION", "Z_CORRECT_FACTOR"};
    private static MathType image;
    private static MathType imageSequence;
    private static MathType table;
    private static MathType tableSequence;
    private static FunctionType noteFunction;

    private static int getUnsignedShort(byte by, byte by2) {
        int n = 0xFF & by;
        int n2 = 0xFF & by2;
        return n2 << 8 | n;
    }

    private static float getFloat(byte by, byte by2, byte by3, byte by4) {
        int n = 0xFF & by;
        int n2 = 0xFF & by2;
        int n3 = 0xFF & by3;
        int n4 = 0xFF & by4;
        int n5 = n4 << 24 | n3 << 16 | n2 << 8 | n;
        return Float.intBitsToFloat(n5);
    }

    static void writeShort(DataOutputStream dataOutputStream, int n) throws IOException {
        int n2 = 0xFF & n;
        int n3 = (0xFF00 & n) >> 8;
        byte[] byArray = new byte[]{(byte)n2, (byte)n3};
        dataOutputStream.write(byArray, 0, 2);
    }

    static void writeInt(DataOutputStream dataOutputStream, int n) throws IOException {
        int n2 = 0xFF & n;
        int n3 = (0xFF00 & n) >> 8;
        int n4 = (0xFF0000 & n) >> 16;
        int n5 = (0xFF000000 & n) >> 24;
        byte[] byArray = new byte[]{(byte)n2, (byte)n3, (byte)n4, (byte)n5};
        dataOutputStream.write(byArray, 0, 4);
    }

    static void writeFloat(DataOutputStream dataOutputStream, float f) throws IOException {
        int n = Float.floatToIntBits(f);
        int n2 = (0xFF & n) << 24;
        int n3 = (0xFF00 & n) << 8;
        int n4 = (0xFF0000 & n) >> 8;
        int n5 = (0xFF000000 & n) >> 24;
        byte[] byArray = new byte[]{(byte)n2, (byte)n3, (byte)n4, (byte)n5};
        dataOutputStream.write(byArray, 0, 4);
    }

    static void writeString(DataOutputStream dataOutputStream, String string, int n) throws IOException {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length < n ? byArray.length : n);
        dataOutputStream.write(byArray2, 0, n);
    }

    public boolean isThisType(String string) {
        return string.toLowerCase().endsWith(".pic");
    }

    public boolean isThisType(byte[] byArray) {
        if (byArray.length < 56) {
            return false;
        }
        return BioRadForm.getUnsignedShort(byArray[54], byArray[55]) == 12345;
    }

    public String[] getDefaultSuffixes() {
        return new String[]{"pic"};
    }

    public void save(String string, Data data, boolean bl) throws BadFormException, IOException, RemoteException, VisADException {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        Object object2;
        FlatField flatField;
        int n5;
        byte[] byArray;
        float f;
        int n6;
        FlatField flatField2;
        Set set;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        Object object3;
        Object object4;
        Serializable serializable;
        Object object5;
        Object object6;
        Object object7;
        DataImpl dataImpl;
        Cloneable cloneable;
        data = data.local();
        Vector<Data> vector = new Vector<Data>();
        if (data instanceof Tuple) {
            cloneable = (Tuple)data;
            int n13 = 0;
            while (n13 < ((Tuple)cloneable).getDimension()) {
                vector.add(((Tuple)cloneable).getComponent(n13));
                ++n13;
            }
        } else {
            vector.add(data);
        }
        cloneable = new Vector();
        Vector<Data> vector2 = new Vector<Data>();
        Vector<Object> vector3 = new Vector<Object>();
        Real real = null;
        Real real2 = null;
        Real real3 = null;
        Text text = null;
        Real real4 = null;
        Real real5 = null;
        Real real6 = null;
        Real real7 = null;
        boolean bl2 = false;
        int n14 = vector.size();
        Object object8 = 0;
        while (object8 < n14) {
            DataImpl dataImpl2 = (DataImpl)vector.elementAt((int)object8);
            MathType mathType = dataImpl2.getType();
            if (mathType.equalsExceptName(image)) {
                ((Vector)cloneable).add(dataImpl2);
            } else if (mathType.equalsExceptName(imageSequence)) {
                FieldImpl fieldImpl = (FieldImpl)dataImpl2;
                int n15 = fieldImpl.getLength();
                int n16 = 0;
                while (n16 < n15) {
                    ((Vector)cloneable).add(fieldImpl.getSample(n16));
                    ++n16;
                }
            } else if (mathType.equalsExceptName(table)) {
                vector2.add(dataImpl2);
            } else if (mathType.equalsExceptName(tableSequence)) {
                FieldImpl fieldImpl = (FieldImpl)dataImpl2;
                int n17 = fieldImpl.getLength();
                int n18 = 0;
                while (n18 < n17) {
                    vector2.add(fieldImpl.getSample(n18));
                    ++n18;
                }
            } else if (mathType.equalsExceptName(noteFunction)) {
                vector3.removeAllElements();
                FieldImpl fieldImpl = (FieldImpl)dataImpl2;
                int n19 = fieldImpl.getLength();
                int n20 = 0;
                while (n20 < n19) {
                    dataImpl = (Tuple)fieldImpl.getSample(n20);
                    object7 = (Real)((Tuple)dataImpl).getComponent(0);
                    object6 = (Real)((Tuple)dataImpl).getComponent(1);
                    object5 = (Real)((Tuple)dataImpl).getComponent(2);
                    serializable = (Real)((Tuple)dataImpl).getComponent(3);
                    object4 = (Real)((Tuple)dataImpl).getComponent(4);
                    object3 = (Real)((Tuple)dataImpl).getComponent(5);
                    Text text2 = (Text)((Tuple)dataImpl).getComponent(6);
                    n12 = (int)((Real)object7).getValue();
                    n11 = (int)((Real)object6).getValue();
                    n10 = (int)((Real)object5).getValue();
                    n9 = (int)((Real)serializable).getValue();
                    n8 = (int)((Real)object4).getValue();
                    n7 = (int)((Real)object3).getValue();
                    String string2 = text2.getValue();
                    BioRadNote bioRadNote = new BioRadNote(n12, n11, n10, n9, n8, n7, string2);
                    vector3.add(bioRadNote);
                    ++n20;
                }
                bl2 = true;
            } else if (mathType.equals(rt_ramp1_min)) {
                real = (Real)dataImpl2;
            } else if (mathType.equals(rt_ramp1_max)) {
                real2 = (Real)dataImpl2;
            } else if (mathType.equals(rt_byte_format)) {
                real3 = (Real)dataImpl2;
            } else if (mathType.equals(tt_name)) {
                text = (Text)dataImpl2;
            } else if (mathType.equals(rt_ramp2_min)) {
                real4 = (Real)dataImpl2;
            } else if (mathType.equals(rt_ramp2_max)) {
                real5 = (Real)dataImpl2;
            } else if (mathType.equals(rt_lens)) {
                real6 = (Real)dataImpl2;
            } else if (mathType.equals(rt_mag_factor)) {
                real7 = (Real)dataImpl2;
            } else {
                boolean bl3 = false;
                if (mathType instanceof RealType) {
                    if (bl2) {
                        bl3 = true;
                    } else {
                        RealType realType = (RealType)mathType;
                        String string3 = realType.getName();
                        int n21 = 0;
                        while (n21 < noteVarNames.length) {
                            if (string3.equals(noteVarNames[n21])) {
                                object7 = new BioRadNote(1, 0, 1280, 20, 0, 0, string3 + " " + ((Real)dataImpl2).getValue());
                                vector3.add(object7);
                                bl3 = true;
                            }
                            ++n21;
                        }
                    }
                }
                if (!bl3) {
                    throw new BadFormException("Unsupported data object");
                }
            }
            ++object8;
        }
        object8 = -1;
        Object object9 = -1;
        int n22 = ((Vector)cloneable).size();
        int n23 = 0;
        while (n23 < n22) {
            Object e = ((Vector)cloneable).elementAt(n23);
            if (!(e instanceof FlatField)) {
                throw new BadFormException("Invalid image data");
            }
            FlatField flatField3 = (FlatField)e;
            dataImpl = flatField3.getDomainSet();
            if (!(dataImpl instanceof GriddedSet)) {
                throw new BadFormException("Invalid image set");
            }
            object7 = (GriddedSet)dataImpl;
            if (((Set)object7).getDimension() != 2) {
                throw new BadFormException("Invalid domain dimension");
            }
            if (((SimpleSet)object7).getManifoldDimension() != 2) {
                throw new BadFormException("Invalid manifold dimension");
            }
            object6 = ((GriddedSet)object7).getLengths();
            if (object8 < 0) {
                object8 = object6[0];
                object9 = object6[1];
            } else if (object8 != object6[0] || object9 != object6[1]) {
                throw new BadFormException("All images must have same width and height");
            }
            object5 = flatField3.getValues(false);
            if (((Object)object5).length != 1 || ((Object)object5[0]).length != object8 * object9) {
                throw new BadFormException("Invalid image samples");
            }
            ++n23;
        }
        if (!bl2 && (set = (flatField2 = (FlatField)((Vector)cloneable).elementAt(0)).getDomainSet()) instanceof Linear2DSet) {
            Linear2DSet linear2DSet = (Linear2DSet)set;
            dataImpl = linear2DSet.getX();
            object7 = linear2DSet.getY();
            object6 = set.getSetUnits();
            object5 = object6[0];
            serializable = object6[1];
            object4 = BioRadNote.getUnitNote((Unit)object5, (Linear1DSet)dataImpl, true);
            object3 = BioRadNote.getUnitNote((Unit)serializable, (Linear1DSet)object7, false);
            if (object4 != null) {
                vector3.add(object4);
            }
            if (object3 != null) {
                vector3.add(object3);
            }
        }
        if ((n6 = vector2.size()) > 3) {
            throw new BadFormException("Too many color tables");
        }
        int n24 = 0;
        while (n24 < n6) {
            Object e = vector2.elementAt(n24);
            if (!(e instanceof FlatField)) {
                throw new BadFormException("Invalid color table data");
            }
            dataImpl = (FlatField)e;
            object7 = ((FieldImpl)dataImpl).getDomainSet();
            if (!(object7 instanceof Gridded1DSet)) {
                throw new BadFormException("Invalid color table set");
            }
            object6 = (Gridded1DSet)object7;
            object5 = ((GriddedSet)object6).getLengths();
            if (object5[0] != 256) {
                throw new BadFormException("Invalid color table length");
            }
            ++n24;
        }
        n24 = object8;
        int n25 = object9;
        int n26 = n22;
        int n27 = real == null ? 0 : (int)real.getValue();
        int n28 = real2 == null ? 255 : (int)real2.getValue();
        int n29 = vector3.size();
        int n30 = real3 == null ? 1 : (int)real3.getValue();
        int n31 = 0;
        object3 = text == null ? string : text.getValue();
        int n32 = 0;
        n12 = 7;
        n11 = 12345;
        n10 = real4 == null ? 0 : (int)real4.getValue();
        n9 = real5 == null ? 255 : (int)real5.getValue();
        n8 = 7;
        n7 = 1;
        int n33 = real6 == null ? 0 : (int)real6.getValue();
        float f2 = f = real7 == null ? 0.0f : (float)real7.getValue();
        if (n30 == 0) {
            byArray = new byte[2 * n26 * n24 * n25];
            n5 = 0;
            while (n5 < n26) {
                flatField = (FlatField)((Vector)cloneable).elementAt(n5);
                object2 = flatField.getValues(false);
                object = object2[0];
                n4 = 0;
                while (n4 < ((double[])object).length) {
                    n3 = 2 * (((double[])object).length * n5 + n4);
                    int n34 = (int)object[n4];
                    n2 = (0xFF00 & n34) >> 8;
                    n = 0xFF & n34;
                    byArray[n3] = (byte)n2;
                    byArray[n3 + 1] = (byte)n;
                    ++n4;
                }
                ++n5;
            }
        } else {
            byArray = new byte[n26 * n24 * n25];
            n5 = 0;
            while (n5 < n26) {
                flatField = (FlatField)((Vector)cloneable).elementAt(n5);
                object2 = flatField.getValues(false);
                object = object2[0];
                n4 = 0;
                while (n4 < ((double[])object).length) {
                    n3 = ((double[])object).length * n5 + n4;
                    byArray[n3] = (byte)object[n4];
                    ++n4;
                }
                ++n5;
            }
        }
        byte[] byArray2 = new byte[n6 * 768];
        int n35 = 0;
        while (n35 < n6) {
            object2 = (FlatField)vector2.elementAt(n35);
            object = ((FlatField)object2).getValues(false);
            double d = object[0];
            double d2 = object[1];
            double d3 = object[2];
            n2 = 0;
            while (n2 < 256) {
                n = 768 * n35 + n2;
                byArray2[n] = (byte)d[n2];
                byArray2[n + 256] = (byte)d2[n2];
                byArray2[n + 512] = (byte)d3[n2];
                ++n2;
            }
            ++n35;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
        BioRadForm.writeShort(dataOutputStream, n24);
        BioRadForm.writeShort(dataOutputStream, n25);
        BioRadForm.writeShort(dataOutputStream, n26);
        BioRadForm.writeShort(dataOutputStream, n27);
        BioRadForm.writeShort(dataOutputStream, n28);
        BioRadForm.writeInt(dataOutputStream, n29);
        BioRadForm.writeShort(dataOutputStream, n30);
        BioRadForm.writeShort(dataOutputStream, n31);
        BioRadForm.writeString(dataOutputStream, (String)object3, 32);
        BioRadForm.writeShort(dataOutputStream, n32);
        BioRadForm.writeShort(dataOutputStream, n12);
        BioRadForm.writeShort(dataOutputStream, n11);
        BioRadForm.writeShort(dataOutputStream, n10);
        BioRadForm.writeShort(dataOutputStream, n9);
        BioRadForm.writeShort(dataOutputStream, n8);
        BioRadForm.writeShort(dataOutputStream, n7);
        BioRadForm.writeShort(dataOutputStream, n33);
        BioRadForm.writeFloat(dataOutputStream, f);
        dataOutputStream.write(new byte[]{0, 0, 0, 0, 0, 0}, 0, 6);
        dataOutputStream.write(byArray, 0, byArray.length);
        int n36 = 0;
        while (n36 < n29) {
            object = (BioRadNote)vector3.elementAt(n36);
            ((BioRadNote)object).write(dataOutputStream, n36 != n29 - 1);
            ++n36;
        }
        dataOutputStream.write(byArray2, 0, byArray2.length);
        dataOutputStream.close();
    }

    public void add(String string, Data data, boolean bl) throws BadFormException {
        throw new BadFormException("BioRadForm.add");
    }

    public DataImpl open(String string) throws BadFormException, IOException, VisADException {
        return this.open(new FileInputStream(string));
    }

    public DataImpl open(URL uRL) throws BadFormException, VisADException, IOException {
        return this.open(uRL.openStream());
    }

    private DataImpl open(InputStream inputStream) throws BadFormException, IOException, VisADException {
        DataImpl dataImpl;
        try {
            dataImpl = this.readFile(new DataInputStream(inputStream), false);
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dataImpl;
    }

    DataImpl readFile(DataInput dataInput, boolean bl) throws IOException, RemoteException, VisADException {
        Cloneable cloneable;
        DataImpl dataImpl;
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Comparable comparable;
        Comparable comparable2;
        Comparable comparable3;
        Comparable comparable4;
        Object object;
        int n;
        Object object2;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object3;
        float[][][] fArray;
        long l;
        byte[] byArray = new byte[76];
        dataInput.readFully(byArray);
        int n6 = BioRadForm.getUnsignedShort(byArray[0], byArray[1]);
        int n7 = BioRadForm.getUnsignedShort(byArray[2], byArray[3]);
        int n8 = BioRadForm.getUnsignedShort(byArray[4], byArray[5]);
        int n9 = BioRadForm.getUnsignedShort(byArray[6], byArray[7]);
        int n10 = BioRadForm.getUnsignedShort(byArray[8], byArray[9]);
        boolean bl2 = (byArray[10] | byArray[11] | byArray[12] | byArray[13]) != 0;
        boolean bl3 = BioRadForm.getUnsignedShort(byArray[14], byArray[15]) != 0;
        int n11 = BioRadForm.getUnsignedShort(byArray[16], byArray[17]);
        String string = new String(byArray, 18, 32);
        int n12 = BioRadForm.getUnsignedShort(byArray[50], byArray[51]);
        int n13 = BioRadForm.getUnsignedShort(byArray[52], byArray[53]);
        int n14 = BioRadForm.getUnsignedShort(byArray[54], byArray[55]);
        int n15 = BioRadForm.getUnsignedShort(byArray[56], byArray[57]);
        int n16 = BioRadForm.getUnsignedShort(byArray[58], byArray[59]);
        int n17 = BioRadForm.getUnsignedShort(byArray[60], byArray[61]);
        int n18 = BioRadForm.getUnsignedShort(byArray[62], byArray[63]);
        int n19 = BioRadForm.getUnsignedShort(byArray[64], byArray[65]);
        float f = BioRadForm.getFloat(byArray[66], byArray[67], byArray[68], byArray[69]);
        if (n14 != 12345) {
            throw new BadFormException("Invalid file header: " + n14);
        }
        int n20 = n6 * n7;
        if (bl) {
            l = ((RandomAccessFile)dataInput).getFilePointer();
            dataInput.skipBytes(n8 * n20);
            fArray = null;
        } else {
            l = 0L;
            fArray = new float[n8][1][n20];
            if (bl3) {
                object3 = new byte[n20];
                int n21 = 0;
                while (n21 < n8) {
                    dataInput.readFully((byte[])object3);
                    n5 = 0;
                    while (n5 < n20) {
                        n4 = 0xFF & object3[n5];
                        fArray[n21][0][n5] = n4;
                        ++n5;
                    }
                    ++n21;
                }
            } else {
                int n22 = 2 * n20;
                byte[] byArray2 = new byte[n22];
                n5 = 0;
                while (n5 < n8) {
                    dataInput.readFully(byArray2);
                    n4 = 0;
                    while (n4 < n22) {
                        n3 = BioRadForm.getUnsignedShort(byArray2[n4], byArray2[n4 + 1]);
                        fArray[n5][0][n4 / 2] = n3;
                        n4 += 2;
                    }
                    ++n5;
                }
            }
        }
        object3 = new Vector();
        while (bl2) {
            byte[] byArray3 = new byte[96];
            dataInput.readFully(byArray3);
            n5 = BioRadForm.getUnsignedShort(byArray3[0], byArray3[1]);
            bl2 = (byArray3[2] | byArray3[3] | byArray3[4] | byArray3[5]) != 0;
            n4 = BioRadForm.getUnsignedShort(byArray3[6], byArray3[7]);
            n3 = BioRadForm.getUnsignedShort(byArray3[8], byArray3[9]);
            int n23 = BioRadForm.getUnsignedShort(byArray3[10], byArray3[11]);
            n2 = BioRadForm.getUnsignedShort(byArray3[12], byArray3[13]);
            int n24 = BioRadForm.getUnsignedShort(byArray3[14], byArray3[15]);
            String string2 = new String(byArray3, 16, 80);
            ((Vector)object3).add(new BioRadNote(n5, n4, n3, n23, n2, n24, string2));
        }
        int n25 = 0;
        byte[][] byArray4 = new byte[3][768];
        n4 = 0;
        while (n4 == 0 && n25 < 3) {
            try {
                dataInput.readFully(byArray4[n25]);
                ++n25;
            }
            catch (IOException iOException) {
                n4 = 1;
            }
        }
        int n26 = ((Vector)object3).size();
        Data[] dataArray = new DataImpl[n26];
        n2 = 0;
        while (n2 < n26) {
            BioRadNote bioRadNote = (BioRadNote)((Vector)object3).elementAt(n2);
            dataArray[n2] = bioRadNote.getNoteData();
            ++n2;
        }
        FieldImpl fieldImpl = null;
        if (n26 > 0) {
            Integer1DSet integer1DSet = new Integer1DSet(n26);
            fieldImpl = new FieldImpl(noteFunction, integer1DSet);
            fieldImpl.setSamples(dataArray, false);
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Unit unit = null;
        Unit unit2 = null;
        int n27 = 0;
        while (n27 < ((Vector)object3).size()) {
            object2 = (BioRadNote)((Vector)object3).elementAt(n27);
            if (((BioRadNote)object2).hasUnitInfo()) {
                n = ((BioRadNote)object2).analyze();
                if (n == 2) {
                    if (d3 == 0.0) {
                        d = ((BioRadNote)object2).origin;
                        d3 = ((BioRadNote)object2).step;
                        unit = BioRadNote.micron;
                    }
                    ((Vector)object3).remove(n27);
                    continue;
                }
                if (n == 3) {
                    if (d4 == 0.0) {
                        d2 = ((BioRadNote)object2).origin;
                        d4 = ((BioRadNote)object2).step;
                        unit2 = ((BioRadNote)object2).time ? BioRadNote.second : BioRadNote.micron;
                    }
                    ((Vector)object3).remove(n27);
                    continue;
                }
                if (n == -1 || n == 0) {
                    ((Vector)object3).remove(n27);
                    continue;
                }
                ++n27;
                continue;
            }
            ++n27;
        }
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        if (d4 == 0.0) {
            d4 = 1.0;
        }
        object2 = new float[n25][3][256];
        n = 0;
        while (n < n25) {
            int n28 = 0;
            while (n28 < 256) {
                int n29 = 0xFF & byArray4[n][n28];
                int n30 = 0xFF & byArray4[n][n28 + 256];
                int n31 = 0xFF & byArray4[n][n28 + 512];
                object2[n][0][n28] = (float)n29;
                object2[n][1][n28] = (float)n30;
                object2[n][2][n28] = (float)n31;
                ++n28;
            }
            ++n;
        }
        RealType realType = RealType.getRealType("index");
        RealType realType2 = RealType.getRealType("ImageElement", unit);
        RealType realType3 = RealType.getRealType("ImageLine", unit2);
        RealType realType4 = RealType.getRealType("value");
        RealTupleType realTupleType = new RealTupleType(realType2, realType3);
        FunctionType functionType = new FunctionType(realTupleType, realType4);
        FunctionType functionType2 = new FunctionType(realType, functionType);
        Linear2DSet linear2DSet = new Linear2DSet(realTupleType, d, d + (double)(n6 - 1) * d3, n6, d2, d2 + (double)(n7 - 1) * d4, n7, null, new Unit[]{unit, unit2}, null);
        Integer1DSet integer1DSet = new Integer1DSet((MathType)realType, n8);
        Data[] dataArray2 = new FlatField[n8];
        int n32 = 0;
        while (n32 < n8) {
            if (bl) {
                object = new BioRadAccessor((RandomAccessFile)dataInput, l, n32, functionType, linear2DSet, n20, bl3);
                dataArray2[n32] = new FileFlatField((FileAccessor)object, strategy);
            } else {
                dataArray2[n32] = new FlatField(functionType, linear2DSet);
                ((FlatField)dataArray2[n32]).setSamples(fArray[n32], false);
            }
            ++n32;
        }
        FieldImpl fieldImpl2 = new FieldImpl(functionType2, integer1DSet);
        fieldImpl2.setSamples(dataArray2, false);
        object = null;
        if (n25 > 0) {
            comparable4 = RealType.getRealType("TableNumber");
            comparable3 = RealType.getRealType("Red");
            comparable2 = RealType.getRealType("Green");
            comparable = RealType.getRealType("Blue");
            serializable3 = new RealTupleType((RealType)comparable3, (RealType)comparable2, (RealType)comparable);
            serializable2 = new FunctionType(realType4, (MathType)serializable3);
            serializable = new FunctionType((MathType)((Object)comparable4), (MathType)serializable2);
            dataImpl = new Integer1DSet(256);
            cloneable = new Integer1DSet(n25);
            Data[] dataArray3 = new FlatField[n25];
            int n33 = 0;
            while (n33 < n25) {
                dataArray3[n33] = new FlatField((FunctionType)serializable2, (Set)dataImpl);
                ((FlatField)dataArray3[n33]).setSamples((float[][])object2[n33], false);
                ++n33;
            }
            object = new FieldImpl((FunctionType)serializable, (Set)cloneable);
            ((FieldImpl)object).setSamples(dataArray3, false);
        }
        comparable4 = new Real(rt_ramp1_min, (double)n9);
        comparable3 = new Real(rt_ramp1_max, (double)n10);
        comparable2 = new Real(rt_byte_format, bl3 ? 1.0 : 0.0);
        comparable = new Text(tt_name, string);
        serializable3 = new Real(rt_ramp2_min, (double)n15);
        serializable2 = new Real(rt_ramp2_max, (double)n16);
        serializable = new Real(rt_lens, (double)n19);
        dataImpl = new Real(rt_mag_factor, (double)f);
        cloneable = new Vector();
        ((Vector)cloneable).add(fieldImpl2);
        if (object != null) {
            ((Vector)cloneable).add(object);
        }
        if (fieldImpl != null) {
            ((Vector)cloneable).add(fieldImpl);
        }
        ((Vector)cloneable).add(comparable4);
        ((Vector)cloneable).add(comparable3);
        ((Vector)cloneable).add(comparable2);
        ((Vector)cloneable).add(comparable);
        ((Vector)cloneable).add(serializable3);
        ((Vector)cloneable).add(serializable2);
        ((Vector)cloneable).add(serializable);
        ((Vector)cloneable).add(dataImpl);
        n26 = ((Vector)object3).size();
        int n34 = 0;
        while (n34 < n26) {
            BioRadNote bioRadNote = (BioRadNote)((Vector)object3).elementAt(n34);
            int n35 = bioRadNote.analyze();
            if (n35 == 1) {
                ((Vector)cloneable).add(bioRadNote.metadata);
            }
            ++n34;
        }
        Object[] objectArray = new Data[((Vector)cloneable).size()];
        ((Vector)cloneable).copyInto(objectArray);
        return new Tuple((Data[])objectArray, false);
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        if (stringArray == null || stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("To convert a file to BioRad .PIC, run:");
            System.out.println("  java visad.data.biorad.BioRadForm in_file out_file");
            System.out.println("To test read a BioRad .PIC file, run:");
            System.out.println("  java visad.data.biorad.BioRadForm in_file");
            System.exit(2);
        }
        if (stringArray.length == 1) {
            BioRadForm bioRadForm = new BioRadForm();
            System.out.print("Reading " + stringArray[0] + " ");
            DataImpl dataImpl = bioRadForm.open(stringArray[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + dataImpl.getType().prettyString());
        } else if (stringArray.length == 2) {
            System.out.print(stringArray[0] + " -> " + stringArray[1] + " ");
            DefaultFamily defaultFamily = new DefaultFamily("loader");
            DataImpl dataImpl = defaultFamily.open(stringArray[0]);
            defaultFamily = null;
            BioRadForm bioRadForm = new BioRadForm();
            bioRadForm.save(stringArray[1], dataImpl, true);
            System.out.println("[done]");
        }
        System.exit(0);
    }

    public BioRadForm() {
        super("BioRadForm" + num++);
    }

    static {
        try {
            image = MathType.stringToType("((x, y) -> a)");
            imageSequence = MathType.stringToType("(t -> ((x, y) -> a))");
            table = MathType.stringToType("(value -> (r, g, b))");
            tableSequence = MathType.stringToType("(t -> (value -> (r, g, b)))");
            noteFunction = new FunctionType(noteIndex, BioRadNote.noteTuple);
        }
        catch (VisADException visADException) {
            // empty catch block
        }
    }

    class BioRadAccessor
    extends FileAccessor {
        private final RandomAccessFile rdr;
        private final long filePtr;
        private final int imageNumber;
        private final FunctionType imageType;
        private final Linear2DSet imageSet;
        private final int imageLen;
        private final boolean byteFmt;

        public FlatField getFlatField() throws RemoteException, VisADException {
            FlatField flatField;
            byte[] byArray = new byte[this.imageLen];
            float[][] fArray = new float[1][this.imageLen];
            try {
                long l = this.rdr.getFilePointer();
                this.rdr.seek(this.filePtr);
                if (this.imageNumber > 0) {
                    this.rdr.skipBytes(this.imageLen * this.imageNumber);
                }
                this.rdr.readFully(byArray);
                if (this.byteFmt) {
                    int n = 0;
                    while (n < this.imageLen) {
                        fArray[0][n] = 0xFF & byArray[n];
                        ++n;
                    }
                } else {
                    int n = 2 * this.imageLen;
                    int n2 = 0;
                    while (n2 < n) {
                        fArray[0][n2 / 2] = BioRadForm.getUnsignedShort(byArray[n2], byArray[n2 + 1]);
                        n2 += 2;
                    }
                }
                flatField = new FlatField(this.imageType, this.imageSet);
                flatField.setSamples(fArray, false);
            }
            catch (IOException iOException) {
                throw new VisADException(iOException.getClass().getName() + ": " + iOException.getMessage());
            }
            return flatField;
        }

        public FunctionType getFunctionType() throws VisADException {
            return this.imageType;
        }

        public double[][] readFlatField(FlatField flatField, int[] nArray) {
            throw new RuntimeException("Unimplemented");
        }

        public void writeFile(int[] nArray, Data data) {
            throw new RuntimeException("Unimplemented");
        }

        public void writeFlatField(double[][] dArray, FlatField flatField, int[] nArray) {
            throw new RuntimeException("Unimplemented");
        }

        public BioRadAccessor(RandomAccessFile randomAccessFile, long l, int n, FunctionType functionType, Linear2DSet linear2DSet, int n2, boolean bl) {
            this.rdr = randomAccessFile;
            this.filePtr = l;
            this.imageNumber = n;
            this.imageType = functionType;
            this.imageSet = linear2DSet;
            this.imageLen = n2;
            this.byteFmt = bl;
        }
    }
}

