/*
 * Decompiled with CFR 0.152.
 */
package visad.data.biorad;

import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import ucar.netcdf.RandomAccessFile;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.biorad.BioRadForm;

public class BioRadCachingForm
extends BioRadForm {
    public DataImpl open(String string) throws BadFormException, IOException, VisADException {
        return this.readFile(new RandomAccessFile(string, "r"), true);
    }

    public DataImpl open(URL uRL) throws BadFormException, VisADException, IOException {
        throw new VisADException("Cannot cache URL " + uRL);
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        if (stringArray == null || stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("To convert a file to BioRad .PIC, run:");
            System.out.println("  java visad.data.biorad.BioRadCachingForm in_file out_file");
            System.out.println("To test read a BioRad .PIC file, run:");
            System.out.println("  java visad.data.biorad.BioRadCachingForm in_file");
            System.exit(2);
        }
        if (stringArray.length == 1) {
            BioRadCachingForm bioRadCachingForm = new BioRadCachingForm();
            System.out.print("Reading " + stringArray[0] + " ");
            DataImpl dataImpl = bioRadCachingForm.open(stringArray[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + dataImpl.getType().prettyString());
        } else if (stringArray.length == 2) {
            System.out.print(stringArray[0] + " -> " + stringArray[1] + " ");
            DefaultFamily defaultFamily = new DefaultFamily("loader");
            DataImpl dataImpl = defaultFamily.open(stringArray[0]);
            defaultFamily = null;
            BioRadCachingForm bioRadCachingForm = new BioRadCachingForm();
            bioRadCachingForm.save(stringArray[1], dataImpl, true);
            System.out.println("[done]");
        }
        System.exit(0);
    }
}

